/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.value;

import com.sas.svcs.content.search.client.RepositoryException;
import com.sas.svcs.content.search.client.namepath.ValueFormatException;
import com.sas.svcs.content.search.client.value.SerialValue;
import com.sas.svcs.content.search.client.value.SerialValueFactory;
import com.sas.svcs.content.search.client.value.StatefulValue;
import com.sas.svcs.content.search.client.value.StringValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;

final class InitialValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = -3277781963593015976L;
    private final SerialValue general;
    private final StatefulValue value;

    InitialValue(SerialValue general, StatefulValue value) {
        this.general = general;
        this.value = value;
    }

    private static String toString(InputStream input) throws ValueFormatException, RepositoryException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
            return new String(output.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            throw new ValueFormatException("Failed to convert from binary to string value", e);
        }
    }

    @Override
    public InputStream getStream() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() != 2 ? SerialValueFactory.getInstance().createBinaryValue(this.value.getString()) : this.value;
        this.general.setValue(realValue);
        return realValue.getStream();
    }

    @Override
    public String getString() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() == 2 ? new StringValue(InitialValue.toString(this.value.getStream())) : this.value;
        this.general.setValue(realValue);
        return realValue.getString();
    }

    @Override
    public long getLong() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() == 2 ? SerialValueFactory.getInstance().createLongValue(InitialValue.toString(this.value.getStream())) : this.value;
        this.general.setValue(realValue);
        return realValue.getLong();
    }

    @Override
    public double getDouble() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() == 2 ? SerialValueFactory.getInstance().createDoubleValue(InitialValue.toString(this.value.getStream())) : this.value;
        this.general.setValue(realValue);
        return realValue.getDouble();
    }

    @Override
    public Calendar getDate() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() == 2 ? SerialValueFactory.getInstance().createDateValue(InitialValue.toString(this.value.getStream())) : this.value;
        this.general.setValue(realValue);
        return realValue.getDate();
    }

    @Override
    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        StatefulValue realValue = this.getType() == 2 ? SerialValueFactory.getInstance().createBooleanValue(InitialValue.toString(this.value.getStream())) : this.value;
        this.general.setValue(realValue);
        return realValue.getBoolean();
    }

    @Override
    public int getType() {
        return this.value.getType();
    }
}

