/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.qom.impl;

import com.sas.svcs.content.search.client.InvalidQueryException;
import com.sas.svcs.content.search.client.qom.Selector;
import com.sas.svcs.content.search.client.qom.impl.AbstractQOMNode;
import com.sas.svcs.content.search.client.qom.impl.ChildNodeImpl;
import com.sas.svcs.content.search.client.qom.impl.ColumnImpl;
import com.sas.svcs.content.search.client.qom.impl.ConstraintImpl;
import com.sas.svcs.content.search.client.qom.impl.DefaultTraversingQOMTreeVisitor;
import com.sas.svcs.content.search.client.qom.impl.DescendantNodeImpl;
import com.sas.svcs.content.search.client.qom.impl.EquiJoinConditionImpl;
import com.sas.svcs.content.search.client.qom.impl.FullTextSearchImpl;
import com.sas.svcs.content.search.client.qom.impl.FullTextSearchScoreImpl;
import com.sas.svcs.content.search.client.qom.impl.NodeLocalNameImpl;
import com.sas.svcs.content.search.client.qom.impl.NodeNameImpl;
import com.sas.svcs.content.search.client.qom.impl.OrderingImpl;
import com.sas.svcs.content.search.client.qom.impl.PropertyExistenceImpl;
import com.sas.svcs.content.search.client.qom.impl.PropertyValueImpl;
import com.sas.svcs.content.search.client.qom.impl.QOMTreeVisitor;
import com.sas.svcs.content.search.client.qom.impl.SameNodeImpl;
import com.sas.svcs.content.search.client.qom.impl.SameNodeJoinConditionImpl;
import com.sas.svcs.content.search.client.qom.impl.SelectorImpl;
import com.sas.svcs.content.search.client.qom.impl.SourceImpl;
import java.util.HashMap;
import java.util.Map;

public class QueryObjectModelTree
extends AbstractQOMNode {
    private final SourceImpl source;
    private final ConstraintImpl constraint;
    private final OrderingImpl[] orderings;
    private final ColumnImpl[] columns;
    private final Map<String, Selector> selectors = new HashMap<String, Selector>();

    public QueryObjectModelTree(SourceImpl source, ConstraintImpl constraint, OrderingImpl[] orderings, ColumnImpl[] columns) throws InvalidQueryException {
        this.source = source;
        this.constraint = constraint;
        this.orderings = orderings;
        this.columns = columns;
        for (SelectorImpl selector : source.getSelectors()) {
            if (this.selectors.put(selector.getSelectorName(), selector) == null) continue;
            throw new InvalidQueryException("Duplicate selector name: " + selector.getSelectorName());
        }
        if (this.selectors.size() == 1) {
            this.selectors.put(null, this.selectors.values().iterator().next());
        }
        this.checkQuery();
    }

    public SourceImpl getSource() {
        return this.source;
    }

    public ConstraintImpl getConstraint() {
        return this.constraint;
    }

    public OrderingImpl[] getOrderings() {
        OrderingImpl[] temp = new OrderingImpl[this.orderings.length];
        System.arraycopy(this.orderings, 0, temp, 0, this.orderings.length);
        return temp;
    }

    public ColumnImpl[] getColumns() {
        ColumnImpl[] temp = new ColumnImpl[this.columns.length];
        System.arraycopy(this.columns, 0, temp, 0, this.columns.length);
        return temp;
    }

    public SelectorImpl getSelector(String name) {
        return (SelectorImpl)this.selectors.get(name);
    }

    @Override
    public Object accept(QOMTreeVisitor visitor, Object data) throws Exception {
        return visitor.visit(this, data);
    }

    private void checkQuery() throws InvalidQueryException {
        try {
            this.accept(new DefaultTraversingQOMTreeVisitor(){

                @Override
                public Object visit(ChildNodeImpl node, Object data) throws Exception {
                    return this.checkSelector(node.getSelectorName());
                }

                @Override
                public Object visit(ColumnImpl node, Object data) throws Exception {
                    return this.checkSelector(node.getSelectorName());
                }

                @Override
                public Object visit(DescendantNodeImpl node, Object data) throws Exception {
                    return this.checkSelector(node.getSelectorName());
                }

                @Override
                public Object visit(EquiJoinConditionImpl node, Object data) throws Exception {
                    this.checkSelector(node.getSelector1Name());
                    return this.checkSelector(node.getSelector2Name());
                }

                @Override
                public Object visit(FullTextSearchImpl node, Object data) throws Exception {
                    return this.checkSelector(node.getSelectorName());
                }

                @Override
                public Object visit(FullTextSearchScoreImpl node, Object data) throws Exception {
                    return this.checkSelector(node.getSelectorName());
                }

                @Override
                public Object visit(NodeLocalNameImpl node, Object data) throws Exception {
                    return this.checkSelector(node.getSelectorName());
                }

                @Override
                public Object visit(NodeNameImpl node, Object data) throws Exception {
                    return this.checkSelector(node.getSelectorName());
                }

                @Override
                public Object visit(PropertyExistenceImpl node, Object data) throws Exception {
                    return this.checkSelector(node.getSelectorName());
                }

                @Override
                public Object visit(PropertyValueImpl node, Object data) throws Exception {
                    return this.checkSelector(node.getSelectorName());
                }

                @Override
                public Object visit(SameNodeImpl node, Object data) throws Exception {
                    return this.checkSelector(node.getSelectorName());
                }

                @Override
                public Object visit(SameNodeJoinConditionImpl node, Object data) throws Exception {
                    this.checkSelector(node.getSelector1Name());
                    return this.checkSelector(node.getSelector2Name());
                }

                private Object checkSelector(String selectorName) throws InvalidQueryException {
                    if (!QueryObjectModelTree.this.selectors.containsKey(selectorName)) {
                        String msg = "Unknown selector: ";
                        msg = selectorName != null ? msg + selectorName : msg + "<default>";
                        throw new InvalidQueryException(msg);
                    }
                    return null;
                }
            }, null);
        }
        catch (Exception e) {
            throw new InvalidQueryException(e.getMessage());
        }
    }
}

