/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.qom.impl;

import com.sas.svcs.content.search.client.InvalidQueryException;
import com.sas.svcs.content.search.client.RepositoryException;
import com.sas.svcs.content.search.client.namepath.Path;
import com.sas.svcs.content.search.client.namepath.PathFactoryImpl;
import com.sas.svcs.content.search.client.namepath.Value;
import com.sas.svcs.content.search.client.qom.And;
import com.sas.svcs.content.search.client.qom.BindVariableValue;
import com.sas.svcs.content.search.client.qom.ChildNode;
import com.sas.svcs.content.search.client.qom.ChildNodeJoinCondition;
import com.sas.svcs.content.search.client.qom.Column;
import com.sas.svcs.content.search.client.qom.Comparison;
import com.sas.svcs.content.search.client.qom.Constraint;
import com.sas.svcs.content.search.client.qom.DescendantNode;
import com.sas.svcs.content.search.client.qom.DescendantNodeJoinCondition;
import com.sas.svcs.content.search.client.qom.DynamicOperand;
import com.sas.svcs.content.search.client.qom.EquiJoinCondition;
import com.sas.svcs.content.search.client.qom.FullTextSearch;
import com.sas.svcs.content.search.client.qom.FullTextSearchScore;
import com.sas.svcs.content.search.client.qom.Join;
import com.sas.svcs.content.search.client.qom.JoinCondition;
import com.sas.svcs.content.search.client.qom.JoinType;
import com.sas.svcs.content.search.client.qom.Length;
import com.sas.svcs.content.search.client.qom.Literal;
import com.sas.svcs.content.search.client.qom.LowerCase;
import com.sas.svcs.content.search.client.qom.NodeLocalName;
import com.sas.svcs.content.search.client.qom.NodeName;
import com.sas.svcs.content.search.client.qom.Not;
import com.sas.svcs.content.search.client.qom.Operator;
import com.sas.svcs.content.search.client.qom.Or;
import com.sas.svcs.content.search.client.qom.Ordering;
import com.sas.svcs.content.search.client.qom.PropertyExistence;
import com.sas.svcs.content.search.client.qom.PropertyValue;
import com.sas.svcs.content.search.client.qom.QueryObjectModel;
import com.sas.svcs.content.search.client.qom.QueryObjectModelFactory;
import com.sas.svcs.content.search.client.qom.SameNode;
import com.sas.svcs.content.search.client.qom.SameNodeJoinCondition;
import com.sas.svcs.content.search.client.qom.Selector;
import com.sas.svcs.content.search.client.qom.Source;
import com.sas.svcs.content.search.client.qom.StaticOperand;
import com.sas.svcs.content.search.client.qom.UpperCase;
import com.sas.svcs.content.search.client.qom.impl.AndImpl;
import com.sas.svcs.content.search.client.qom.impl.BindVariableValueImpl;
import com.sas.svcs.content.search.client.qom.impl.ChildNodeImpl;
import com.sas.svcs.content.search.client.qom.impl.ChildNodeJoinConditionImpl;
import com.sas.svcs.content.search.client.qom.impl.ColumnImpl;
import com.sas.svcs.content.search.client.qom.impl.ComparisonImpl;
import com.sas.svcs.content.search.client.qom.impl.ConstraintImpl;
import com.sas.svcs.content.search.client.qom.impl.DescendantNodeImpl;
import com.sas.svcs.content.search.client.qom.impl.DescendantNodeJoinConditionImpl;
import com.sas.svcs.content.search.client.qom.impl.DynamicOperandImpl;
import com.sas.svcs.content.search.client.qom.impl.EquiJoinConditionImpl;
import com.sas.svcs.content.search.client.qom.impl.FullTextSearchImpl;
import com.sas.svcs.content.search.client.qom.impl.FullTextSearchScoreImpl;
import com.sas.svcs.content.search.client.qom.impl.JoinConditionImpl;
import com.sas.svcs.content.search.client.qom.impl.JoinImpl;
import com.sas.svcs.content.search.client.qom.impl.LengthImpl;
import com.sas.svcs.content.search.client.qom.impl.LiteralImpl;
import com.sas.svcs.content.search.client.qom.impl.LowerCaseImpl;
import com.sas.svcs.content.search.client.qom.impl.NodeLocalNameImpl;
import com.sas.svcs.content.search.client.qom.impl.NodeNameImpl;
import com.sas.svcs.content.search.client.qom.impl.NotImpl;
import com.sas.svcs.content.search.client.qom.impl.OrImpl;
import com.sas.svcs.content.search.client.qom.impl.OrderingImpl;
import com.sas.svcs.content.search.client.qom.impl.PropertyExistenceImpl;
import com.sas.svcs.content.search.client.qom.impl.PropertyValueImpl;
import com.sas.svcs.content.search.client.qom.impl.QueryObjectModelTree;
import com.sas.svcs.content.search.client.qom.impl.SameNodeImpl;
import com.sas.svcs.content.search.client.qom.impl.SameNodeJoinConditionImpl;
import com.sas.svcs.content.search.client.qom.impl.SelectorImpl;
import com.sas.svcs.content.search.client.qom.impl.SourceImpl;
import com.sas.svcs.content.search.client.qom.impl.StaticOperandImpl;
import com.sas.svcs.content.search.client.qom.impl.UpperCaseImpl;

public abstract class QueryObjectModelFactoryImpl
implements QueryObjectModelFactory {
    protected abstract QueryObjectModel createQuery(QueryObjectModelTree var1) throws InvalidQueryException, RepositoryException;

    public QueryObjectModel createQuery(Selector selector, Constraint constraint, Ordering[] orderings, Column[] columns) throws InvalidQueryException, RepositoryException {
        return this.createQuery((Source)selector, constraint, orderings, columns);
    }

    @Override
    public QueryObjectModel createQuery(Source source, Constraint constraint, Ordering[] orderings, Column[] columns) throws InvalidQueryException, RepositoryException {
        ColumnImpl[] cols;
        OrderingImpl[] ords;
        if (source == null) {
            throw new InvalidQueryException("source must not be null");
        }
        if (!(source instanceof SourceImpl)) {
            throw new RepositoryException("Unknown Source implementation");
        }
        if (constraint != null && !(constraint instanceof ConstraintImpl)) {
            throw new RepositoryException("Unknown Constraint implementation");
        }
        if (orderings != null) {
            ords = new OrderingImpl[orderings.length];
            for (int i = 0; i < orderings.length; ++i) {
                if (!(orderings[i] instanceof OrderingImpl)) {
                    throw new RepositoryException("Unknown Ordering implementation");
                }
                ords[i] = (OrderingImpl)orderings[i];
            }
        } else {
            ords = OrderingImpl.EMPTY_ARRAY;
        }
        if (columns != null) {
            cols = new ColumnImpl[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                if (!(columns[i] instanceof ColumnImpl)) {
                    throw new RepositoryException("Unknown Column implementation");
                }
                cols[i] = (ColumnImpl)columns[i];
            }
        } else {
            cols = ColumnImpl.EMPTY_ARRAY;
        }
        QueryObjectModelTree qomTree = new QueryObjectModelTree((SourceImpl)source, (ConstraintImpl)constraint, ords, cols);
        return this.createQuery(qomTree);
    }

    public Selector selector(String nodeTypeName) throws InvalidQueryException, RepositoryException {
        return new SelectorImpl(nodeTypeName, nodeTypeName);
    }

    @Override
    public Selector selector(String nodeTypeName, String selectorName) throws InvalidQueryException, RepositoryException {
        return new SelectorImpl(this.checkNodeTypeName(nodeTypeName), this.checkSelectorName(selectorName));
    }

    @Override
    public Join join(Source left, Source right, String joinTypeName, JoinCondition joinCondition) throws InvalidQueryException, RepositoryException {
        if (!(left instanceof SourceImpl) || !(right instanceof SourceImpl)) {
            throw new RepositoryException("Unknown Source implementation");
        }
        if (!(joinCondition instanceof JoinConditionImpl)) {
            throw new RepositoryException("Unknwon JoinCondition implementation");
        }
        return new JoinImpl((SourceImpl)left, (SourceImpl)right, JoinType.getJoinTypeByName(joinTypeName), (JoinConditionImpl)joinCondition);
    }

    @Override
    public EquiJoinCondition equiJoinCondition(String selector1Name, String property1Name, String selector2Name, String property2Name) throws InvalidQueryException, RepositoryException {
        return new EquiJoinConditionImpl(this.checkSelectorName(selector1Name), this.checkPropertyName(property1Name), this.checkSelectorName(selector2Name), this.checkPropertyName(property2Name));
    }

    public SameNodeJoinCondition sameNodeJoinCondition(String selector1Name, String selector2Name) throws InvalidQueryException, RepositoryException {
        return new SameNodeJoinConditionImpl(this.checkSelectorName(selector1Name), this.checkSelectorName(selector2Name), null);
    }

    @Override
    public SameNodeJoinCondition sameNodeJoinCondition(String selector1Name, String selector2Name, String selector2Path) throws InvalidQueryException, RepositoryException {
        return new SameNodeJoinConditionImpl(this.checkSelectorName(selector1Name), this.checkSelectorName(selector2Name), this.checkPath(selector2Path));
    }

    @Override
    public ChildNodeJoinCondition childNodeJoinCondition(String childSelectorName, String parentSelectorName) throws InvalidQueryException, RepositoryException {
        return new ChildNodeJoinConditionImpl(this.checkSelectorName(childSelectorName), this.checkSelectorName(parentSelectorName));
    }

    @Override
    public DescendantNodeJoinCondition descendantNodeJoinCondition(String descendantSelectorName, String ancestorSelectorName) throws InvalidQueryException, RepositoryException {
        return new DescendantNodeJoinConditionImpl(this.checkSelectorName(descendantSelectorName), this.checkSelectorName(ancestorSelectorName));
    }

    @Override
    public And and(Constraint constraint1, Constraint constraint2) throws InvalidQueryException, RepositoryException {
        if (constraint1 == null || constraint2 == null) {
            throw new InvalidQueryException("Constraints must not be null");
        }
        if (constraint1 instanceof ConstraintImpl && constraint2 instanceof ConstraintImpl) {
            return new AndImpl((ConstraintImpl)constraint1, (ConstraintImpl)constraint2);
        }
        throw new RepositoryException("Unknown constraint implementation");
    }

    @Override
    public Or or(Constraint constraint1, Constraint constraint2) throws InvalidQueryException, RepositoryException {
        if (constraint1 == null || constraint2 == null) {
            throw new InvalidQueryException("Constraints must not be null");
        }
        if (constraint1 instanceof ConstraintImpl && constraint2 instanceof ConstraintImpl) {
            return new OrImpl((ConstraintImpl)constraint1, (ConstraintImpl)constraint2);
        }
        throw new RepositoryException("Unknown constraint implementation");
    }

    @Override
    public Not not(Constraint constraint) throws InvalidQueryException, RepositoryException {
        if (!(constraint instanceof ConstraintImpl)) {
            throw new RepositoryException("Unknown Constraint implementation");
        }
        return new NotImpl((ConstraintImpl)constraint);
    }

    @Override
    public Comparison comparison(DynamicOperand left, String operatorName, StaticOperand right) throws InvalidQueryException, RepositoryException {
        if (!(left instanceof DynamicOperandImpl)) {
            throw new RepositoryException("Invalid left operand: " + left);
        }
        if (!(right instanceof StaticOperandImpl)) {
            throw new RepositoryException("Invalid right operand: " + right);
        }
        return new ComparisonImpl((DynamicOperandImpl)left, Operator.getOperatorByName(operatorName), (StaticOperandImpl)right);
    }

    public PropertyExistence propertyExistence(String propertyName) throws InvalidQueryException, RepositoryException {
        return new PropertyExistenceImpl(null, this.checkPropertyName(propertyName));
    }

    @Override
    public PropertyExistence propertyExistence(String selectorName, String propertyName) throws InvalidQueryException, RepositoryException {
        return new PropertyExistenceImpl(this.checkSelectorName(selectorName), this.checkPropertyName(propertyName));
    }

    public FullTextSearch fullTextSearch(String propertyName, StaticOperand fullTextSearchExpression) throws InvalidQueryException, RepositoryException {
        return new FullTextSearchImpl(null, this.checkPropertyName(propertyName), this.checkFullTextSearchExpression(fullTextSearchExpression));
    }

    @Override
    public FullTextSearch fullTextSearch(String selectorName, String propertyName, StaticOperand fullTextSearchExpression) throws InvalidQueryException, RepositoryException {
        if (fullTextSearchExpression == null) {
            throw new IllegalArgumentException("Full text search expression is null");
        }
        return new FullTextSearchImpl(this.checkSelectorName(selectorName), this.checkPropertyName(propertyName), this.checkFullTextSearchExpression(fullTextSearchExpression));
    }

    public SameNode sameNode(String path) throws InvalidQueryException, RepositoryException {
        return new SameNodeImpl(null, this.checkPath(path));
    }

    @Override
    public SameNode sameNode(String selectorName, String path) throws InvalidQueryException, RepositoryException {
        return new SameNodeImpl(this.checkSelectorName(selectorName), this.checkPath(path));
    }

    public ChildNode childNode(String path) throws InvalidQueryException, RepositoryException {
        return new ChildNodeImpl(null, this.checkPath(path));
    }

    @Override
    public ChildNode childNode(String selectorName, String path) throws InvalidQueryException, RepositoryException {
        return new ChildNodeImpl(this.checkSelectorName(selectorName), this.checkPath(path));
    }

    public DescendantNode descendantNode(String path) throws InvalidQueryException, RepositoryException {
        return new DescendantNodeImpl(null, this.checkPath(path));
    }

    @Override
    public DescendantNode descendantNode(String selectorName, String path) throws InvalidQueryException, RepositoryException {
        return new DescendantNodeImpl(this.checkSelectorName(selectorName), this.checkPath(path));
    }

    public PropertyValue propertyValue(String propertyName) throws InvalidQueryException, RepositoryException {
        return new PropertyValueImpl(null, this.checkPropertyName(propertyName));
    }

    @Override
    public PropertyValue propertyValue(String selectorName, String propertyName) throws InvalidQueryException, RepositoryException {
        return new PropertyValueImpl(this.checkSelectorName(selectorName), this.checkPropertyName(propertyName));
    }

    @Override
    public Length length(PropertyValue propertyValue) throws InvalidQueryException, RepositoryException {
        if (!(propertyValue instanceof PropertyValueImpl)) {
            throw new RepositoryException("Unknown PropertyValue implementation");
        }
        return new LengthImpl((PropertyValueImpl)propertyValue);
    }

    public NodeName nodeName() throws InvalidQueryException, RepositoryException {
        return new NodeNameImpl(null);
    }

    @Override
    public NodeName nodeName(String selectorName) throws InvalidQueryException, RepositoryException {
        return new NodeNameImpl(this.checkSelectorName(selectorName));
    }

    public NodeLocalName nodeLocalName() throws InvalidQueryException, RepositoryException {
        return new NodeLocalNameImpl(null);
    }

    @Override
    public NodeLocalName nodeLocalName(String selectorName) throws InvalidQueryException, RepositoryException {
        return new NodeLocalNameImpl(this.checkSelectorName(selectorName));
    }

    public FullTextSearchScore fullTextSearchScore() throws InvalidQueryException, RepositoryException {
        return new FullTextSearchScoreImpl(null);
    }

    @Override
    public FullTextSearchScore fullTextSearchScore(String selectorName) throws InvalidQueryException, RepositoryException {
        return new FullTextSearchScoreImpl(this.checkSelectorName(selectorName));
    }

    @Override
    public LowerCase lowerCase(DynamicOperand operand) throws InvalidQueryException, RepositoryException {
        if (!(operand instanceof DynamicOperandImpl)) {
            throw new RepositoryException("Unknown DynamicOperand implementation");
        }
        return new LowerCaseImpl((DynamicOperandImpl)operand);
    }

    @Override
    public UpperCase upperCase(DynamicOperand operand) throws InvalidQueryException, RepositoryException {
        if (!(operand instanceof DynamicOperandImpl)) {
            throw new RepositoryException("Unknown DynamicOperand implementation");
        }
        return new UpperCaseImpl((DynamicOperandImpl)operand);
    }

    @Override
    public BindVariableValue bindVariable(String bindVariableName) throws InvalidQueryException, RepositoryException {
        if (bindVariableName == null) {
            throw new InvalidQueryException("bindVariableName must not be null");
        }
        return new BindVariableValueImpl(bindVariableName);
    }

    @Override
    public Literal literal(Value value) throws InvalidQueryException, RepositoryException {
        if (value == null) {
            throw new InvalidQueryException("value must not be null");
        }
        return new LiteralImpl(value);
    }

    @Override
    public Ordering ascending(DynamicOperand operand) throws InvalidQueryException, RepositoryException {
        if (!(operand instanceof DynamicOperandImpl)) {
            throw new RepositoryException("Unknown DynamicOperand implementation");
        }
        return new OrderingImpl((DynamicOperandImpl)operand, "jcr.order.ascending");
    }

    @Override
    public Ordering descending(DynamicOperand operand) throws InvalidQueryException, RepositoryException {
        if (!(operand instanceof DynamicOperandImpl)) {
            throw new RepositoryException("Unknown DynamicOperand implementation");
        }
        return new OrderingImpl((DynamicOperandImpl)operand, "jcr.order.descending");
    }

    public Column column(String propertyName) throws InvalidQueryException, RepositoryException {
        String propName = this.checkPropertyName(propertyName);
        return new ColumnImpl(null, propName, propName);
    }

    public Column column(String propertyName, String columnName) throws InvalidQueryException, RepositoryException {
        if (propertyName == null && columnName != null) {
            throw new InvalidQueryException("columnName must be null if propertyName is null");
        }
        return new ColumnImpl(null, this.checkPropertyName(propertyName), columnName);
    }

    @Override
    public Column column(String selectorName, String propertyName, String columnName) throws InvalidQueryException, RepositoryException {
        if (propertyName == null && columnName != null) {
            throw new InvalidQueryException("columnName must be null if propertyName is null");
        }
        return new ColumnImpl(this.checkSelectorName(selectorName), this.checkPropertyName(propertyName), columnName);
    }

    private String checkSelectorName(String selectorName) throws RepositoryException {
        return selectorName;
    }

    private String checkNodeTypeName(String nodeTypeName) throws RepositoryException {
        return nodeTypeName;
    }

    private Path checkPath(String path) throws RepositoryException {
        if (path == null) {
            throw new InvalidQueryException("path must not be null");
        }
        return PathFactoryImpl.getInstance().create(path.replace('/', '\t'));
    }

    private String checkPropertyName(String propertyName) throws RepositoryException {
        if (propertyName == null) {
            throw new InvalidQueryException("propertyName must not be null");
        }
        return propertyName;
    }

    private StaticOperand checkFullTextSearchExpression(StaticOperand fullTextSearchExpression) throws RepositoryException {
        if (fullTextSearchExpression == null) {
            throw new InvalidQueryException("fullTextSearchExpression must not be null");
        }
        return fullTextSearchExpression;
    }
}

