/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.namepath;

import com.sas.svcs.content.search.client.namepath.MalformedPathException;
import com.sas.svcs.content.search.client.namepath.Path;
import com.sas.svcs.content.search.client.namepath.PathFactory;
import com.sas.svcs.content.search.client.namepath.PathFactoryImpl;
import java.util.LinkedList;
import javax.xml.namespace.QName;

public final class PathBuilder {
    private final PathFactory factory;
    private final LinkedList queue;
    boolean isNormalized = true;
    boolean leadingParent = true;

    public PathBuilder() {
        this(PathFactoryImpl.getInstance());
    }

    public PathBuilder(PathFactory factory) {
        this.factory = factory != null ? factory : PathFactoryImpl.getInstance();
        this.queue = new LinkedList();
    }

    public PathBuilder(Path.Element[] elements) {
        this();
        this.addAll(elements);
    }

    public PathBuilder(Path parent) {
        this();
        this.addAll(parent.getElements());
    }

    public void addRoot() {
        this.addFirst(this.factory.getRootElement());
    }

    public void addAll(Path.Element[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            this.addLast(elements[i]);
        }
    }

    public void addFirst(Path.Element elem) {
        if (this.queue.isEmpty()) {
            this.isNormalized &= !elem.denotesCurrent();
            this.leadingParent = elem.denotesParent();
        } else {
            this.isNormalized &= !elem.denotesCurrent() && (!this.leadingParent || elem.denotesParent());
            this.leadingParent |= elem.denotesParent();
        }
        this.queue.addFirst(elem);
    }

    public void addFirst(QName name) {
        this.addFirst(this.factory.createElement(name));
    }

    public void addFirst(QName name, int index) {
        this.addFirst(this.factory.createElement(name, index));
    }

    public void addLast(Path.Element elem) {
        this.queue.addLast(elem);
        this.leadingParent &= elem.denotesParent();
        this.isNormalized &= !elem.denotesCurrent() && (this.leadingParent || !elem.denotesParent());
    }

    public void addLast(QName name) {
        this.addLast(this.factory.createElement(name));
    }

    public void addLast(QName name, int index) {
        this.addLast(this.factory.createElement(name, index));
    }

    public Path getPath() throws MalformedPathException {
        if (this.queue.size() == 0) {
            throw new MalformedPathException("empty path");
        }
        Path.Element[] elements = this.queue.toArray(new Path.Element[this.queue.size()]);
        return this.factory.create(elements);
    }
}

