/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.namepath;

import com.sas.svcs.content.search.client.namepath.Name;
import com.sas.svcs.content.search.client.namepath.NameFactory;
import javax.xml.namespace.QName;

public class NameFactoryImpl
implements NameFactory {
    private static NameFactory FACTORY;

    private NameFactoryImpl() {
    }

    public static NameFactory getInstance() {
        if (FACTORY == null) {
            FACTORY = new NameFactoryImpl();
        }
        return FACTORY;
    }

    @Override
    public QName create(String namespaceURI, String localName) throws IllegalArgumentException {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("invalid namespaceURI specified");
        }
        if (localName == null) {
            throw new IllegalArgumentException("invalid localName specified");
        }
        return new QName(namespaceURI, localName);
    }

    @Override
    public QName create(String nameString) throws IllegalArgumentException {
        if (nameString == null || "".equals(nameString)) {
            throw new IllegalArgumentException("Invalid Name literal.");
        }
        if (nameString.charAt(0) != '{') {
            throw new IllegalArgumentException("Invalid Name literal");
        }
        int i = nameString.indexOf(125);
        if (i == -1) {
            throw new IllegalArgumentException("Invalid Name literal");
        }
        if (i == nameString.length() - 1) {
            throw new IllegalArgumentException("Invalid Name literal");
        }
        return new QName(nameString.substring(1, i), nameString.substring(i + 1));
    }

    private static class NameImpl
    implements Name {
        private transient int hash;
        private transient String string;
        private final String namespaceURI;
        private final String localName;

        private NameImpl(String namespaceURI, String localName) {
            this.namespaceURI = namespaceURI.intern();
            this.localName = localName;
            this.hash = 0;
        }

        @Override
        public String getLocalName() {
            return this.localName;
        }

        @Override
        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String toString() {
            if (this.string == null) {
                this.string = '{' + this.namespaceURI + '}' + this.localName;
            }
            return this.string;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof NameImpl) {
                NameImpl other = (NameImpl)obj;
                return this.namespaceURI == other.namespaceURI && this.localName.equals(other.localName);
            }
            if (obj instanceof Name) {
                Name other = (Name)obj;
                return this.namespaceURI.equals(other.getNamespaceURI()) && this.localName.equals(other.getLocalName());
            }
            return false;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                h = 17;
                h = 37 * h + this.namespaceURI.hashCode();
                this.hash = h = 37 * h + this.localName.hashCode();
            }
            return h;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            Name other = (Name)o;
            if (this.namespaceURI.equals(other.getNamespaceURI())) {
                return this.localName.compareTo(other.getLocalName());
            }
            return this.namespaceURI.compareTo(other.getNamespaceURI());
        }

        private Object readResolve() {
            return new NameImpl(this.namespaceURI, this.localName);
        }
    }
}

