/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.logging.client.util;

import com.sas.svcs.content.logging.client.ContentLoggingService;
import com.sas.svcs.content.logging.client.LogItem;
import com.sas.svcs.content.logging.client.util.RB;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ContentLoggingUtil {
    public static String transformReport(String xmlReport, Locale locale) {
        ResourceBundle bundle = RB.getResources(locale);
        return ContentLoggingUtil.transformReport(xmlReport, "/com/sas/svcs/content/logging/client/util/plainLog.xsl", bundle);
    }

    public static String transformReport(String xmlReport, String transformResource, ResourceBundle bundle) {
        try {
            StringReader reader = new StringReader(xmlReport);
            StringWriter writer = new StringWriter();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            InputStream inputStream = ContentLoggingUtil.class.getResourceAsStream(transformResource);
            Transformer transformer = tFactory.newTransformer(new StreamSource(inputStream));
            transformer.transform(new StreamSource(reader), new StreamResult(writer));
            String result = writer.toString();
            if (bundle != null) {
                result = ContentLoggingUtil.tokenReplace(result, bundle);
            }
            return result;
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
        }
        return xmlReport;
    }

    private static String tokenReplace(String input, ResourceBundle bundle) {
        StringBuilder sb = new StringBuilder();
        int index1 = 0;
        while (index1 < input.length()) {
            int index2 = input.indexOf("@@", index1);
            if (index2 < 0) {
                sb.append(input.substring(index1));
                break;
            }
            sb.append(input.substring(index1, index2));
            int index3 = input.indexOf("@@", index2 + 2);
            if (index3 < 0) {
                sb.append(input.substring(index2));
                break;
            }
            String token = input.substring(index2 + 2, index3);
            String value = null;
            try {
                value = bundle.getString(token);
                sb.append(value);
            }
            catch (MissingResourceException ex) {
                sb.append(input.substring(index2, index3 + 2));
            }
            index1 = index3 + 2;
        }
        return sb.toString();
    }

    public static void logMessage(ContentLoggingService contentLoggingService, String contentLogId, String message, int priority, String classifier) {
        ContentLoggingUtil.logMessage(contentLoggingService, contentLogId, message, priority, classifier, null);
    }

    public static void logMessage(ContentLoggingService contentLoggingService, String contentLogId, String message, int priority, String classifier, Throwable t) {
        if (contentLogId == null) {
            return;
        }
        LogItem logItem = new LogItem(contentLogId);
        logItem.setDate(new Date());
        logItem.setClassifier(classifier);
        logItem.setPriority(priority);
        if (t == null) {
            logItem.setText(message);
        } else {
            logItem.setText(message + "  " + t.getMessage());
        }
        contentLoggingService.addLogItem(logItem);
        if (t != null) {
            logItem = new LogItem(contentLogId);
            logItem.setDate(new Date());
            logItem.setClassifier(classifier);
            logItem.setPriority(500);
            logItem.setText(message, t);
            contentLoggingService.addLogItem(logItem);
        }
    }

    public static void logEnumerationMessages(ContentLoggingService contentLoggingService, String contentLogId, List<String> messages, int priority, String classifier) {
        if (contentLogId == null) {
            return;
        }
        ArrayList<LogItem> itemList = new ArrayList<LogItem>();
        for (String msg : messages) {
            LogItem logItem = new LogItem(contentLogId);
            logItem.setDate(new Date());
            logItem.setClassifier(classifier);
            logItem.setPriority(priority);
            HashMap<String, String> propMap = new HashMap<String, String>(1);
            propMap.put("mode", "enumeration");
            logItem.setProperties(propMap);
            logItem.setText(msg);
            itemList.add(logItem);
        }
        contentLoggingService.addLogItems(itemList);
    }

    public static LogItem createLogItem(String contentLogId, String message, int priority, String classifier) {
        return ContentLoggingUtil.createLogItem(contentLogId, message, priority, classifier, null);
    }

    public static LogItem createLogItem(String contentLogId, String message, int priority, String classifier, Throwable t) {
        LogItem logItem = new LogItem(contentLogId);
        logItem.setDate(new Date());
        logItem.setClassifier(classifier);
        logItem.setPriority(priority);
        if (t == null) {
            logItem.setText(message);
        } else {
            logItem.setText(message, t);
        }
        return logItem;
    }
}

