/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.client;

import java.io.Serializable;

public class TransportState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STATE_UNSET = 0;
    public static final int STATE_OFF = 1;
    public static final int STATE_NEW = 2;
    public static final int STATE_EXISTS = 4;
    public static final int STATE_DELETE = 8;
    public static final int STATE_WRITEPERMISSION_DENIED = 16;
    public static final int STATE_WRITEPERMISSION_DENIED_ONPARENT = 64;
    public static final int STATE_READPERMISSION_DENIED = 128;
    public static final int STATE_INVALID_GENERIC = 256;
    public static final int STATE_INVALID_PARENT = 512;
    public static final int STATE_INVALID_NAME = 1024;
    public static final int STATE_INVALID_LENGTH = 2048;
    public static final int STATE_PRESERVED_PATH = 4096;
    private static int invalidStateMask;
    public static final TransportState UNSET_NODE_STATE;
    private int stateValue = 0;
    private String msg = null;

    public TransportState() {
    }

    public TransportState(int stateValue) {
        this.setStateValue(stateValue);
    }

    public TransportState(int stateValue, String msg) {
        this.setStateValue(stateValue);
        this.setMessage(msg);
    }

    public void setStateValue(int stateValue) {
        this.stateValue = stateValue;
    }

    public int getStateValue() {
        return this.stateValue;
    }

    public String getMessage() {
        return this.msg;
    }

    public void setMessage(String msg) {
        this.msg = msg;
    }

    public void addState(int state) {
        this.stateValue |= state;
    }

    public void removeState(int state) {
        this.stateValue ^= state;
    }

    public boolean isStateSet(int state) {
        return !this.isUnset() && (this.stateValue & state) != 0;
    }

    public boolean isValidState() {
        return !this.isUnset() && (this.stateValue & invalidStateMask) == 0;
    }

    public boolean isUnset() {
        return this.stateValue == 0;
    }

    static {
        int[] invalidStates = new int[]{16, 64, 128, 256, 512, 1024, 2048};
        int mask = 0;
        for (int i = 0; i < invalidStates.length; ++i) {
            mask |= invalidStates[i];
        }
        invalidStateMask = mask;
        UNSET_NODE_STATE = new TransportState(0);
    }
}

