/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.client;

import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TransportOperation;
import com.sas.svcs.content.navigation.client.ContainerNode;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class TargetTransportOperation<T extends TargetTransportNode>
extends TransportOperation<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ContainerNode targetContainer;
    private Map<T, ContainerNode> updatedPathMap = null;

    public String getTargetContainerPath() {
        ContentComponent comp = this.targetContainer.getContentObject();
        if (comp instanceof ContentNode) {
            return ((ContentNode)comp).getPath();
        }
        return null;
    }

    public ContainerNode getTargetContainer() {
        return this.targetContainer;
    }

    public void setTargetContainer(ContainerNode container) {
        this.targetContainer = container;
    }

    public void moveNode(T node, ContainerNode newContainer) {
        if (this.updatedPathMap == null) {
            this.updatedPathMap = new LinkedHashMap<T, ContainerNode>();
        }
        this.updatedPathMap.put(node, newContainer);
    }

    public boolean hasNodeMoved(T node) {
        return this.updatedPathMap == null ? false : this.updatedPathMap.containsKey(node);
    }

    public ContainerNode getNewContainerForNode(T node) {
        return this.updatedPathMap == null ? null : this.updatedPathMap.get(node);
    }
}

