/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.client;

import com.sas.svcs.content.lifecycle.client.NodeProcessingState;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.client.TransportState;
import java.io.Serializable;

public abstract class TargetTransportNode
extends TransportNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String targetId;
    protected String targetPath;
    protected String newName;
    protected TransportState transportState;
    protected NodeProcessingState processingState;

    public NodeProcessingState getProcessingState() {
        return this.processingState;
    }

    public void setProcessingState(NodeProcessingState processingState) {
        this.processingState = processingState;
    }

    public void setTransportState(TransportState transportState) {
        this.transportState = transportState;
    }

    public TransportState getTransportState() {
        return this.transportState == null ? TransportState.UNSET_NODE_STATE : this.transportState;
    }

    public void setTargetId(String id) {
        this.targetId = id;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetPath(String path) {
        this.targetPath = path;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    @Override
    public String getName() {
        return this.newName == null ? super.getName() : this.newName;
    }

    public void rename(String newName) {
        if (newName != null && !newName.equals(this.getName())) {
            int index;
            this.newName = newName;
            String targetPath = this.getTargetPath();
            if (targetPath != null && (index = targetPath.lastIndexOf(47)) > -1) {
                targetPath = targetPath.substring(0, index + 1) + newName;
                this.setTargetPath(targetPath);
            }
        }
    }

    public boolean isRenamed() {
        return this.newName == null ? false : !this.newName.equals(super.getName());
    }

    @Override
    public String toString() {
        return this.targetPath != null ? this.targetPath : (this.getName() == null ? super.toString() : this.getName());
    }
}

