/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.client;

import com.sas.svcs.content.lifecycle.client.MappableEntity;
import com.sas.svcs.content.lifecycle.client.SubstitutionKey;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Substitution
extends MappableEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id = null;
    private String contextValue = null;
    private String targetContextValue = null;
    private String sourceValue = null;
    private String targetValue = null;
    private Map<TransportNode, List<SubstitutionKey>> substitutionKeys = new LinkedHashMap<TransportNode, List<SubstitutionKey>>(5);

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSourceValue() {
        return this.sourceValue;
    }

    public void setSourceValue(String source) {
        this.sourceValue = source;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String target) {
        this.targetValue = target;
        this.setMapped(true);
    }

    public String getContextValue() {
        return this.contextValue;
    }

    public void setContextValue(String value) {
        this.contextValue = value;
    }

    public String getTargetContextValue() {
        return this.targetContextValue;
    }

    public void setTargetContextValue(String context) {
        this.targetContextValue = context;
    }

    public String toString() {
        return this.name + ": " + (this.sourceValue == null || this.sourceValue.length() == 0 ? "<none>" : this.sourceValue);
    }

    public void addSubstitutionKey(TransportNode node, SubstitutionKey key) {
        List<SubstitutionKey> keys = this.substitutionKeys.get(node);
        if (keys == null) {
            keys = new ArrayList<SubstitutionKey>();
            this.substitutionKeys.put(node, keys);
        }
        keys.add(key);
    }

    public List<SubstitutionKey> getSubstitutionKeys(TransportNode node) {
        List<SubstitutionKey> keys = this.substitutionKeys.get(node);
        if (keys == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(keys);
    }
}

