/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import com.sas.services.util.GetPropertyAction;
import com.sas.services.util.NamespaceRegistry;
import com.sas.services.util.RB;
import com.sas.services.util.TransformerFactoryFactory;
import com.sas.text.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@SASScope
public class XMLUtil {
    public static final String ACCESS_EXTERNAL_DTD = "http://javax.xml.XMLConstants/property/accessExternalDTD";
    public static final String ACCESS_EXTERNAL_STYLESHEET = "http://javax.xml.XMLConstants/property/accessExternalStylesheet";
    public static final String NODE = "node";
    public static final String XML_VERSION = "1.0";
    public static final String CHARSET_ENCODING_UTF8 = "utf-8";
    public static final String CHARSET_ENCODING = "utf-8";
    private static final String REGEX_XML_DECLARATION = "<\\?xml.*>\\s";
    private static final Pattern REGEX_PATTERN_XML_DECLARATION = Pattern.compile("<\\?xml.*>\\s");
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String W3C_XML_SCHEMAINSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String JAXP_PROPERTY_SCHEMALANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_PROPERTY_SCHEMASOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final int BUFFER_LENGTH = 50;

    private XMLUtil() {
    }

    public static final String applyXSL(String input, String xsl) throws TransformerConfigurationException, TransformerException, IllegalArgumentException {
        return XMLUtil.applyXSL(input, xsl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String applyXSL(String input, String xsl, Map transformationParameters) throws TransformerConfigurationException, TransformerException, IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg("input"));
        }
        if (xsl == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg("xsl"));
        }
        StringWriter result = new StringWriter(input.length());
        String string = XML_VERSION;
        synchronized (XML_VERSION) {
            TransformerFactory tFactory = TransformerFactoryFactory.newFactory();
            Transformer transformer = tFactory.newTransformer(new StreamSource(new StringReader(xsl)));
            if (transformationParameters != null && transformationParameters.size() > 0) {
                Iterator iter = transformationParameters.entrySet().iterator();
                Map.Entry mapEntry = null;
                while (iter.hasNext()) {
                    mapEntry = iter.next();
                    transformer.setParameter((String)mapEntry.getKey(), mapEntry.getValue());
                }
            }
            transformer.transform(new StreamSource(new StringReader(input)), new StreamResult(result));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return result.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseXML(String xml, DefaultHandler handler) throws SAXException {
        if (xml == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullMsg());
        }
        StringReader reader = new StringReader(xml);
        InputSource source = new InputSource(reader);
        try {
            XMLUtil.parseXML(source, handler);
        }
        finally {
            reader.close();
        }
    }

    public static void parseXML(InputStream stream, DefaultHandler handler) throws SAXException {
        if (stream == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullMsg());
        }
        InputSource source = new InputSource(stream);
        XMLUtil.parseXML(source, handler);
    }

    public static void parseXML(InputSource source, DefaultHandler handler) throws SAXException {
        if (source == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullMsg());
        }
        try {
            SAXParser parser = XMLUtil.createSAXParser();
            if (source != null) {
                parser.parse(source, handler);
                parser = null;
            }
        }
        catch (IOException io) {
            throw new SAXException(io);
        }
    }

    public static SAXParser createSAXParser() throws SAXException {
        try {
            String FEATURE = null;
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(false);
            parserFactory.setValidating(false);
            FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            parserFactory.setFeature(FEATURE, true);
            FEATURE = "http://xml.org/sax/features/external-general-entities";
            parserFactory.setFeature(FEATURE, false);
            FEATURE = "http://xml.org/sax/features/external-parameter-entities";
            parserFactory.setFeature(FEATURE, false);
            FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            parserFactory.setFeature(FEATURE, false);
            parserFactory.setXIncludeAware(false);
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXParser parser = parserFactory.newSAXParser();
            return parser;
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce);
        }
    }

    public static final String convertNodeToString(Node node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullMsg());
        }
        return XMLUtil.convertNodeToString(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String convertNodeToString(Node node, Properties outputFormatProperties) throws IllegalArgumentException {
        String string;
        block9: {
            if (node == null) {
                throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg(NODE));
            }
            string = null;
            TransformerException ex = null;
            try {
                DOMSource domSource = new DOMSource(node);
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                TransformerFactory transformerFactory = TransformerFactoryFactory.newFactory();
                Transformer transformer = transformerFactory.newTransformer();
                if (outputFormatProperties != null && outputFormatProperties.size() > 0) {
                    transformer.setOutputProperties(outputFormatProperties);
                }
                transformer.transform(domSource, streamResult);
                string = stringWriter.toString();
            }
            catch (TransformerConfigurationException e) {
                ex = e;
                return ex;
            }
            catch (TransformerException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block9;
                throw new IllegalArgumentException(ex.getLocalizedMessage());
            }
        }
        return string;
    }

    public static final String convertNodeToString(Node node, boolean isOmitXMLDeclarationInOutput) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg(NODE));
        }
        Properties outputFormatProperties = new Properties();
        if (isOmitXMLDeclarationInOutput) {
            outputFormatProperties.put("omit-xml-declaration", "yes");
        }
        return XMLUtil.convertNodeToString(node, outputFormatProperties);
    }

    public static final Document convertStringToDocument(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullMsg());
        }
        Document document = null;
        try (StringReader stringReader = null;){
            stringReader = new StringReader(string);
            document = XMLUtil.convertInputSourceToDocument(new InputSource(stringReader));
        }
        return document;
    }

    public static final Document convertStreamToDocument(InputStream stream) throws IllegalArgumentException {
        if (stream == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullMsg());
        }
        return XMLUtil.convertInputSourceToDocument(new InputSource(stream));
    }

    /*
     * Exception decompiling
     */
    public static final Document convertInputSourceToDocument(InputSource inputSource) throws IllegalArgumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String node2String(Node node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullMsg());
        }
        String value = null;
        StringBuilder sw = new StringBuilder();
        XMLUtil.print(node, null, sw);
        value = sw.toString();
        return value;
    }

    private static void print(Node node, NamespaceRegistry namespaceStack, StringBuilder sbuilder) {
        if (node == null) {
            return;
        }
        boolean hasChildren = false;
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                sbuilder.append("<?xml version=\"1.0\"?>\n");
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int numChildren = children.getLength();
                for (int i = 0; i < numChildren; ++i) {
                    XMLUtil.print(children.item(i), namespaceStack, sbuilder);
                }
                break;
            }
            case 1: {
                NamedNodeMap attrs;
                namespaceStack = new NamespaceRegistry(namespaceStack);
                sbuilder.append('<' + node.getNodeName());
                String elPrefix = node.getPrefix();
                String elNamespaceURI = node.getNamespaceURI();
                if (elPrefix != null && elNamespaceURI != null) {
                    boolean prefixIsDeclared = false;
                    try {
                        String namespaceURI = namespaceStack.lookup(elPrefix);
                        if (elNamespaceURI.equals(namespaceURI)) {
                            prefixIsDeclared = true;
                        }
                    }
                    catch (IllegalArgumentException namespaceURI) {
                        // empty catch block
                    }
                    if (!prefixIsDeclared) {
                        XMLUtil.printNamespaceDecl(node, namespaceStack, sbuilder);
                    }
                }
                int len = (attrs = node.getAttributes()) != null ? attrs.getLength() : 0;
                StringBuilder buffer = null;
                for (int i = 0; i < len; ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    buffer = new StringBuilder(50);
                    buffer.append(' ');
                    buffer.append(attr.getNodeName());
                    XMLUtil.buildQuotedValue(buffer, XMLUtil.normalize(attr.getValue()));
                    sbuilder.append(buffer.toString());
                    String attrPrefix = attr.getPrefix();
                    String attrNamespaceURI = attr.getNamespaceURI();
                    if (attrPrefix == null || attrNamespaceURI == null) continue;
                    boolean prefixIsDeclared = false;
                    try {
                        String namespaceURI = namespaceStack.lookup(attrPrefix);
                        if (attrNamespaceURI.equals(namespaceURI)) {
                            prefixIsDeclared = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (prefixIsDeclared) continue;
                    XMLUtil.printNamespaceDecl(attr, namespaceStack, sbuilder);
                }
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int numChildren = children.getLength();
                    boolean bl = hasChildren = numChildren > 0;
                    if (hasChildren) {
                        sbuilder.append('>');
                    }
                    for (int i = 0; i < numChildren; ++i) {
                        XMLUtil.print(children.item(i), namespaceStack, sbuilder);
                    }
                } else {
                    hasChildren = false;
                }
                if (hasChildren) break;
                sbuilder.append("/>");
                break;
            }
            case 5: {
                sbuilder.append('&');
                sbuilder.append(node.getNodeName());
                sbuilder.append(';');
                break;
            }
            case 4: {
                sbuilder.append("<![CDATA[");
                sbuilder.append(node.getNodeValue());
                sbuilder.append("]]>");
                break;
            }
            case 3: {
                sbuilder.append(XMLUtil.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                sbuilder.append("<!--");
                sbuilder.append(node.getNodeValue());
                sbuilder.append("-->");
                break;
            }
            case 7: {
                sbuilder.append("<?");
                sbuilder.append(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    sbuilder.append(' ');
                    sbuilder.append(data);
                }
                sbuilder.append("?>");
                break;
            }
        }
        if (type == 1 && hasChildren) {
            sbuilder.append("</");
            sbuilder.append(node.getNodeName());
            sbuilder.append('>');
            hasChildren = false;
        }
    }

    public static String getAttributeNS(Element element, String namespaceURI, String localPart) {
        if (element == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg("element"));
        }
        Attr attr = element.getAttributeNodeNS(namespaceURI, localPart);
        return attr != null ? attr.getValue() : null;
    }

    private static void printNamespaceDecl(Node node, NamespaceRegistry namespaceStack, StringBuilder sbuilder) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg(NODE));
        }
        switch (node.getNodeType()) {
            case 2: {
                XMLUtil.printNamespaceDecl(((Attr)node).getOwnerElement(), node, namespaceStack, sbuilder);
                break;
            }
            case 1: {
                XMLUtil.printNamespaceDecl((Element)node, node, namespaceStack, sbuilder);
                break;
            }
        }
    }

    private static void printNamespaceDecl(Element owner, Node node, NamespaceRegistry namespaceStack, StringBuilder sbuilder) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(XMLUtil.getInvalidArgumentNullParameterMsg(NODE));
        }
        String namespaceURI = node.getNamespaceURI();
        String prefix = node.getPrefix();
        if (!namespaceURI.equals("http://www.w3.org/2000/xmlns/") || !prefix.equals("xmlns")) {
            if (XMLUtil.getAttributeNS(owner, "http://www.w3.org/2000/xmlns/", prefix) == null) {
                StringBuilder buffer = new StringBuilder(50);
                buffer.append(' ');
                buffer.append("xmlns:");
                buffer.append(prefix);
                XMLUtil.buildQuotedValue(buffer, namespaceURI);
                sbuilder.append(buffer.toString());
            }
        } else {
            prefix = node.getLocalName();
            namespaceURI = node.getNodeValue();
        }
        namespaceStack.register(prefix, namespaceURI);
    }

    public static String normalize(String s) {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        int strlen = s != null ? s.length() : 0;
        StringBuilder str = new StringBuilder(strlen + strlen / 10);
        block7: for (int i = 0; i < strlen; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    if (i > 0) {
                        char lastChar = str.charAt(str.length() - 1);
                        if (lastChar != '\r') {
                            str.append(lineSeparator);
                            continue block7;
                        }
                        str.append('\n');
                        continue block7;
                    }
                    str.append(lineSeparator);
                    continue block7;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static final String stripXMLDeclaration(String xml) {
        String value = xml;
        if (xml != null && REGEX_XML_DECLARATION != null) {
            value = REGEX_PATTERN_XML_DECLARATION.matcher(xml).replaceFirst("");
        }
        return value;
    }

    public static final String getInvalidArgumentNullMsg() {
        return RB.getStringResource("IllegalArgument.null.ex.txt");
    }

    public static final String getInvalidArgumentNullParameterMsg(Object nullParameterName) {
        return Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.null.ex.fmt.txt", (Object)nullParameterName);
    }

    public static final void bufferQuotedValue(StringBuffer buffer, String value) {
        buffer.append("=\"");
        buffer.append(value);
        buffer.append('\"');
    }

    public static final void buildQuotedValue(StringBuilder buffer, String value) {
        buffer.append("=\"");
        buffer.append(value);
        buffer.append('\"');
    }
}

