/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactory;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ConnectionRequest;
import com.sas.services.connection.Credential;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.connection.LoginException;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.TrustedPeerCredential;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.RB;
import com.sas.services.util.ServicesConnectionFactoryInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

@SASScope
public class ServicesConnectionFactory
extends ConnectionFactory
implements ServicesConnectionFactoryInterface {
    @Override
    public ConnectionInterface getConnection(UserContextInterface userContext) throws ConnectionFactoryException {
        ConnectionInterface cx = this.getConnection(userContext, 0L);
        return cx;
    }

    @Override
    public ConnectionInterface getConnection(UserContextInterface userContext, long waitMilliseconds) throws ConnectionFactoryException {
        if (userContext == null) {
            ConnectionInterface cx = this.getConnection(waitMilliseconds);
            return cx;
        }
        String authService = this.getAuthService();
        ConnectionInterface cx = null;
        cx = "Host".equals(authService) || "Prompt".equals(authService) ? this.getConnectionHost(userContext, waitMilliseconds) : ("Metadata".equals(authService) ? this.getConnectionMetadata(userContext, waitMilliseconds) : this.getConnectionNone(userContext, waitMilliseconds));
        return cx;
    }

    public static String getEffectiveDisplayName(UserContextInterface userContext) {
        IdentityInterface person = null;
        try {
            String authServerName = userContext.getAuthServerName();
            if (authServerName != null) {
                person = userContext.getPerson();
            }
        }
        catch (RemoteException authServerName) {
        }
        catch (ServiceException authServerName) {
            // empty catch block
        }
        String name = null;
        if (person != null) {
            try {
                name = person.getEffectiveDisplayName();
            }
            catch (RemoteException remoteException) {
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        if (name == null) {
            try {
                name = userContext.getName();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (name == null) {
            name = "UNKNOWN";
        }
        return name;
    }

    private ConnectionInterface getConnectionHost(UserContextInterface userContext, long waitMilliseconds) throws ConnectionFactoryException {
        String idp;
        Object lastException;
        HashSet<String> triedDomainSet;
        int cxfDomainLstL;
        List cxfDomainLst;
        Locale locale;
        String name;
        block24: {
            String msg;
            name = ServicesConnectionFactory.getEffectiveDisplayName(userContext);
            locale = null;
            try {
                locale = userContext.getLocale();
            }
            catch (ServiceException se) {
                throw new ConnectionFactoryException((Throwable)((Object)se));
            }
            catch (RemoteException re) {
                throw new ConnectionFactoryException((Throwable)re);
            }
            ConnectionFactoryRequest cxfReq = this.getRequest();
            cxfDomainLst = this.getDomains();
            cxfDomainLstL = cxfDomainLst.size();
            triedDomainSet = new HashSet<String>(cxfDomainLstL);
            lastException = null;
            for (String cxfDomain : cxfDomainLst) {
                List identityLst;
                block23: {
                    IdentityGetterAction action = new IdentityGetterAction(userContext, cxfDomain);
                    identityLst = null;
                    try {
                        identityLst = (List)AccessController.doPrivileged(action);
                    }
                    catch (PrivilegedActionException pae) {
                        Exception e = pae.getException();
                        lastException = e;
                        if (!cxfReq.isLoggableFINE()) break block23;
                        int l = name.length() + cxfDomain.length() + 50;
                        StringBuffer buf = new StringBuffer(l);
                        buf.append("Unable to obtain identity for user ");
                        buf.append(name).append(" in domain ").append(cxfDomain).append(":");
                        cxfReq.logFINE(buf.toString(), (Throwable)e);
                    }
                }
                if (identityLst == null || identityLst.size() <= 0) continue;
                for (UserIdentityInterface identity : identityLst) {
                    String password = (String)identity.getCredential();
                    if (password == null || password.length() == 0) continue;
                    triedDomainSet.add(cxfDomain);
                    ConnectionFactoryKernel kernel = this.getKernel();
                    String userName = (String)identity.getPrincipal();
                    PasswordCredential login = new PasswordCredential(userName, password, cxfDomain);
                    login.setLocale(locale);
                    try {
                        ConnectionRequest cxReq = ConnectionRequest.wrap((ConnectionFactoryKernel)kernel, (Credential)login, (long)waitMilliseconds);
                        ConnectionInterface cx = this.getConnection(cxReq);
                        return cx;
                    }
                    catch (LoginException le) {
                        lastException = le;
                        if (cxfReq.isLoggableFINE()) {
                            int l = userName.length() + cxfDomain.length() + name.length() + 200;
                            StringBuffer buf = new StringBuffer(l);
                            buf.append("Attempt to authorize identity ");
                            buf.append(userName).append(" for user ").append(name).append(" in domain ");
                            buf.append(cxfDomain).append(" failed. The following traceback is for information only. ");
                            buf.append("The user may have another identity which may be valid for this factory.");
                            cxfReq.logFINE(buf.toString(), (Throwable)le);
                        }
                        if (!(le instanceof InvalidCredentialsException)) continue;
                        try {
                            userContext.removeIdentity(identity);
                        }
                        catch (RemoteException l) {}
                    }
                }
            }
            idp = null;
            try {
                idp = userContext.getIDPropagation();
            }
            catch (RemoteException re) {
                lastException = re;
                if (cxfReq.isLoggableFINE()) {
                    msg = "Unable to determine if connection factory user was authenticated with SSPI";
                    cxfReq.logFINE(msg, (Throwable)re);
                }
            }
            catch (ServiceException se) {
                lastException = se;
                if (!cxfReq.isLoggableFINE()) break block24;
                msg = "Unable to determine if connection factory user was authenticated with SSPI";
                cxfReq.logFINE(msg, (Throwable)((Object)se));
            }
        }
        SecurityPackageCredential cred = null;
        if ("sspi".equals(idp) && this.isSecurityPackageAllowed()) {
            cred = SecurityPackageCredential.getInstance();
        } else if ("trustedpeer".equals(idp) && this.isTrustedPeerAllowed()) {
            cred = TrustedPeerCredential.getInstance();
        }
        if (cred != null) {
            cred.setLocale(locale);
            ConnectionFactoryKernel kernel = this.getKernel();
            ConnectionRequest cxReq = ConnectionRequest.wrap((ConnectionFactoryKernel)kernel, (Credential)cred, (long)waitMilliseconds);
            ConnectionInterface cx = this.getConnection(cxReq);
            return cx;
        }
        int triedDomainSetL = triedDomainSet.size();
        String serverName = this.getLogicalServerName();
        if (triedDomainSetL > 0) {
            String messageIndex = "ServicesConnectionFactory.102.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex, locale);
            String message = Message.format((String)messagePattern, (Object)name, (Object)serverName);
            throw new LoginException(message, (Throwable)lastException);
        }
        if (cxfDomainLstL == 1) {
            String cxfDomain = (String)cxfDomainLst.get(0);
            String messageIndex = "ServicesConnectionFactory.101.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex, locale);
            String message = Message.format((String)messagePattern, (Object)name, (Object)serverName, (Object)cxfDomain);
            throw new LoginException(message, (Throwable)lastException);
        }
        int l = cxfDomainLstL * 65 + 21;
        StringBuffer cxfDomainStrBuf = new StringBuffer(l);
        cxfDomainStrBuf.append('<');
        for (String cxfDomain : cxfDomainLst) {
            cxfDomainStrBuf.append(cxfDomain).append(',');
        }
        int cxfDomainStrL = cxfDomainStrBuf.length();
        cxfDomainStrBuf.setCharAt(cxfDomainStrL - 1, '>');
        String cxfDomainStr = cxfDomainStrBuf.toString();
        String messageIndex = "ServicesConnectionFactory.102.ex.fmt";
        String messagePattern = RB.getStringResource(messageIndex, locale);
        String message = Message.format((String)messagePattern, (Object)name, (Object)serverName, (Object)cxfDomainStr);
        throw new LoginException(message, (Throwable)lastException);
    }

    private ConnectionInterface getConnectionMetadata(UserContextInterface userContext, long waitMilliseconds) throws ConnectionFactoryException {
        List domainLst = this.getDomains();
        String spoofDomain = (String)domainLst.get(0);
        PasswordGeneratingCredential cred = new PasswordGeneratingCredential(userContext, spoofDomain);
        ConnectionFactoryKernel kernel = this.getKernel();
        ConnectionRequest cxReq = ConnectionRequest.wrap((ConnectionFactoryKernel)kernel, (Credential)cred, (long)waitMilliseconds);
        try {
            ConnectionInterface cx = this.getConnection(cxReq);
            return cx;
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            if (cause != null && cause instanceof ConnectionFactoryException) {
                throw (ConnectionFactoryException)cause;
            }
            throw re;
        }
    }

    private ConnectionInterface getConnectionNone(UserContextInterface userContext, long waitMilliseconds) throws ConnectionFactoryException {
        ConnectionFactoryKernel kernel = this.getKernel();
        String userName = "";
        String password = "";
        List domainLst = this.getDomains();
        String spoofDomain = (String)domainLst.get(0);
        PasswordCredential cred = new PasswordCredential(userName, password, spoofDomain);
        try {
            Locale locale = userContext.getLocale();
            cred.setLocale(locale);
        }
        catch (ServiceException se) {
            throw new ConnectionFactoryException((Throwable)((Object)se));
        }
        catch (RemoteException re) {
            throw new ConnectionFactoryException((Throwable)re);
        }
        ConnectionRequest cxReq = ConnectionRequest.wrap((ConnectionFactoryKernel)kernel, (Credential)cred, (long)waitMilliseconds);
        ConnectionInterface cx = this.getConnection(cxReq);
        return cx;
    }

    @SASScope
    private class IdentityGetterAction
    implements PrivilegedExceptionAction {
        private UserContextInterface _userContext;
        private String _domain;

        protected IdentityGetterAction(UserContextInterface userContext, String domain) {
            this._userContext = userContext;
            this._domain = domain;
        }

        public Object run() throws Exception {
            List idLst = this._domain != null ? this._userContext.getIdentitiesByDomain(this._domain, false, null) : this._userContext.getIdentities();
            return idLst;
        }
    }

    @SASScope
    public static class PasswordGeneratingCredential
    extends PasswordCredential {
        private static final long serialVersionUID = 1L;
        private UserContextInterface _userContext;
        private String _userName;
        private String _password;
        private Locale _locale;

        public PasswordGeneratingCredential(UserContextInterface userContext, String spoofDomain) {
            super(null, null, spoofDomain);
            this._userContext = userContext;
        }

        public synchronized String getUserName() {
            if (this._userName == null) {
                this.generatePassword();
            }
            return this._userName;
        }

        public synchronized String getPassword() {
            if (this._password == null) {
                this.generatePassword();
            }
            String password = this._password;
            this._password = null;
            return password;
        }

        public synchronized Locale getLocale() {
            if (this._locale == null) {
                this.generatePassword();
            }
            return this._locale;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || !that.getClass().equals(((Object)((Object)this)).getClass())) {
                return false;
            }
            PasswordGeneratingCredential thatCred = (PasswordGeneratingCredential)((Object)that);
            String thisDomain = this.getDomain();
            String thatDomain = thatCred.getDomain();
            if (thisDomain != null ? !thisDomain.equals(thatDomain) : thatDomain != null) {
                return false;
            }
            UserContextInterface thatUserContext = thatCred._userContext;
            if (this._userContext != null ? !this._userContext.equals(thatUserContext) : thatUserContext != null) {
                return false;
            }
            String thatUserName = thatCred._userName;
            if (this._userName != null ? !this._userName.equals(thatUserName) : thatUserName != null) {
                return false;
            }
            String thatPassword = thatCred._password;
            if (this._password != null ? !this._password.equals(thatPassword) : thatPassword != null) {
                return false;
            }
            Locale thatLocale = thatCred._locale;
            return !(this._locale != null ? !this._locale.equals(thatLocale) : thatLocale != null);
        }

        public int hashCode() {
            int hc = ((Object)((Object)this)).getClass().hashCode();
            String domain = this.getDomain();
            if (domain != null) {
                hc ^= domain.hashCode();
            }
            if (this._userContext != null) {
                hc ^= this._userContext.hashCode();
            }
            if (this._userName != null) {
                hc ^= this._userName.hashCode();
            }
            if (this._password != null) {
                hc ^= this._password.hashCode();
            }
            if (this._locale != null) {
                hc ^= this._locale.hashCode();
            }
            return hc;
        }

        private void generatePassword() throws RuntimeException {
            try {
                ServerInterface server = this._userContext.getAuthServer();
                UserIdentityInterface id = server.generatePassword(null);
                this._userName = (String)id.getPrincipal();
                this._password = (String)id.getCredential();
                this._locale = this._userContext.getLocale();
            }
            catch (ServiceException se) {
                ConnectionFactoryException cfe = new ConnectionFactoryException((Throwable)((Object)se));
                throw new RuntimeException(cfe);
            }
            catch (RemoteException re) {
                ConnectionFactoryException cfe = new ConnectionFactoryException((Throwable)re);
                throw new RuntimeException(cfe);
            }
        }
    }
}

