/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.services.util.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class ProcessStatus {
    public static final int SUCCESS = 0;
    public static final int WARNING = 4;
    public static final int ERROR = 8;
    private int _status = 0;
    private Map _infos = new HashMap(10);
    private Map _warnings = new HashMap(10);
    private Map _errors = new HashMap(10);
    private Map _exceptions = new HashMap(10);
    private Logger _logger = null;
    private String _objectIdentifier;
    private static ProcessStatus _globalInstance = null;

    public ProcessStatus(Logger logger, String objectIdentifier) {
        if (logger == null) {
            throw new IllegalArgumentException("Logger must be specified.");
        }
        this._logger = logger;
        if (objectIdentifier == null) {
            throw new IllegalArgumentException("Object identifier must be specified");
        }
        this._objectIdentifier = objectIdentifier;
    }

    public void addInfo(String message) {
        this.addInfo(this._objectIdentifier, message);
    }

    public void addInfo(String objectPath, String message) {
        this.addMessage(this._infos, objectPath, message);
    }

    public void addWarning(String message) {
        this.addWarning(this._objectIdentifier, message);
    }

    public void addWarning(String objectPath, String message) {
        this.setStatus(4);
        this.addMessage(this._warnings, objectPath, message);
    }

    public void addError(String message) {
        this.addError(this._objectIdentifier, message);
    }

    public void addError(String objectPath, String message) {
        this.setStatus(8);
        this.addMessage(this._errors, objectPath, message);
    }

    public void addErrorException(String objectPath, Throwable e) {
        this.setStatus(8);
        this._exceptions.put(objectPath, e);
    }

    private void addMessage(Map messageMap, String objectPath, String message) {
        ArrayList<String> messages = (ArrayList<String>)messageMap.get(objectPath);
        if (messages == null) {
            messages = new ArrayList<String>();
            messageMap.put(objectPath, messages);
        }
        messages.add(message);
    }

    private synchronized void setStatus(int status) {
        this._status |= status;
    }

    public void logStatus() {
        if (this._logger != null) {
            this.logStatus(this._logger);
        }
    }

    public void logStatus(Logger logger) {
        List messages;
        if (this.isSuccessful()) {
            logger.info(Message.format((String)RB.getStringResource("ProcessStatus.SuccessMessage.fmt.txt"), (Object)this._objectIdentifier));
        }
        if (this.hasInfos()) {
            logger.info(Message.format((String)RB.getStringResource("ProcessStatus.InfosFollowMessage.fmt.txt"), (Object)this._objectIdentifier));
            for (String objectId : this._infos.keySet()) {
                messages = (List)this._infos.get(objectId);
                for (String message : messages) {
                    if (objectId.equals(this._objectIdentifier)) {
                        logger.info(Message.format((String)RB.getStringResource("ProcessStatus.infomessagecontent.fmt.txt"), (Object)message));
                        continue;
                    }
                    logger.info(Message.format((String)RB.getStringResource("ProcessStatus.infomessagecontentfrObj.fmt.txt"), (Object)objectId, (Object)message));
                }
            }
        }
        if (this.hasWarnings()) {
            logger.warn(Message.format((String)RB.getStringResource("ProcessStatus.WarningsFollowMessage.fmt.txt"), (Object)this._objectIdentifier));
            for (String objectId : this._warnings.keySet()) {
                messages = (List)this._warnings.get(objectId);
                for (String message : messages) {
                    if (objectId.equals(this._objectIdentifier)) {
                        logger.warn(Message.format((String)RB.getStringResource("ProcessStatus.warningmessagecontent.fmt.txt"), (Object)message));
                        continue;
                    }
                    logger.warn(Message.format((String)RB.getStringResource("ProcessStatus.warningmessagecontentfrObj.fmt.txt"), (Object)objectId, (Object)message));
                }
            }
        }
        if (this.hasErrors()) {
            logger.error(Message.format((String)RB.getStringResource("ProcessStatus.ErrorsFollowMessage.fmt.txt"), (Object)this._objectIdentifier));
            for (String objectId : this._errors.keySet()) {
                messages = (List)this._errors.get(objectId);
                for (String message : messages) {
                    if (objectId.equals(this._objectIdentifier)) {
                        logger.error(Message.format((String)RB.getStringResource("ProcessStatus.errormessagecontent.fmt.txt"), (Object)message));
                        continue;
                    }
                    logger.error(Message.format((String)RB.getStringResource("ProcessStatus.errormessagecontentfrObj.fmt.txt"), (Object)objectId, (Object)message));
                }
            }
            for (String object : this._exceptions.keySet()) {
                Throwable e;
                Throwable processException = e = (Throwable)this._exceptions.get(object);
                if (e.getCause() != null) {
                    processException = e.getCause();
                }
                logger.error(Message.format((String)RB.getStringResource("ProcessStatus.exceptionMessage.fmt.txt"), (Object)object, (Object)processException.getLocalizedMessage()), processException);
            }
        }
    }

    private boolean hasInfos() {
        boolean returnValue = false;
        if (this._infos.size() > 0) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean isSuccessful() {
        return this._status == 0;
    }

    public boolean hasWarnings() {
        return (this._status & 4) > 0;
    }

    public boolean hasErrors() {
        return (this._status & 8) > 0;
    }

    public int getStatus() {
        return this._status;
    }

    public void addStatus(ProcessStatus newStatus) {
        List messages;
        this.setStatus(newStatus._status);
        for (String objectId : newStatus._infos.keySet()) {
            messages = (List)newStatus._infos.get(objectId);
            for (String message : messages) {
                this.addInfo(objectId, message);
            }
        }
        for (String objectId : newStatus._warnings.keySet()) {
            messages = (List)newStatus._warnings.get(objectId);
            for (String message : messages) {
                this.addWarning(objectId, message);
            }
        }
        for (String objectId : newStatus._errors.keySet()) {
            messages = (List)newStatus._errors.get(objectId);
            for (String message : messages) {
                this.addError(objectId, message);
            }
        }
        for (String objectId : newStatus._exceptions.keySet()) {
            Throwable t = (Throwable)newStatus._exceptions.get(objectId);
            this.addErrorException(objectId, t);
        }
    }

    public static boolean clearGlobalStatus() {
        boolean bCleared = false;
        if (_globalInstance != null) {
            _globalInstance = null;
            bCleared = true;
        }
        return bCleared;
    }

    public static boolean setGlobalStatus(ProcessStatus newGlobal) {
        boolean bCleared = ProcessStatus.clearGlobalStatus();
        _globalInstance = newGlobal;
        return bCleared;
    }

    public static ProcessStatus getGlobalStatus() {
        return _globalInstance;
    }

    public static String generateLoggingName(CMetadata root) {
        String returnValue = "";
        try {
            PrimaryType type;
            String publicType;
            returnValue = root.getName() + ":" + root.getId();
            if (root instanceof PrimaryType && (publicType = (type = (PrimaryType)root).getPublicType()) != null && publicType.length() > 0) {
                returnValue = root.getObjectStore().getFactory().getOMIUtil().getObjectPath((MdObjectStore)root.getObjectStore(), (PrimaryType)root, true);
            }
        }
        catch (RemoteException re) {
            LogManager.getLogger((String)"com.sas.services.util").error(re.getLocalizedMessage(), (Throwable)re);
        }
        catch (MdException e) {
            LogManager.getLogger((String)"com.sas.services.util").error(e.getLocalizedMessage(), (Throwable)e);
        }
        return returnValue;
    }
}

