/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user.omi;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.AssociationPathComponent;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.user.Profile;
import com.sas.services.user.ProfileDomain;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.ProfileStoreInterface;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.user.omi.RB;
import com.sas.text.Message;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class OMIProfileStore
implements ProfileStoreInterface,
Serializable {
    static final long serialVersionUID = -3683259503472346979L;
    static final Map<String, SyncEntry> syncMap = new HashMap<String, SyncEntry>();
    private static final int EXCEPTION_LIST_INIT = 4;
    MetadataInterface _anchor;
    ProfileInterface _profile;
    RepositoryInterface _repos;
    PropertySet _ps;

    public OMIProfileStore(MetadataInterface anchor, ProfileInterface profile, RepositoryInterface repos) {
        this._anchor = anchor;
        this._profile = profile;
        this._repos = repos;
    }

    @Override
    public void refresh() throws ServiceException {
        this.load(false);
    }

    @Override
    public synchronized void load() throws ServiceException {
        this.load(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncEntry getSyncObject(String username) {
        Map<String, SyncEntry> map = syncMap;
        synchronized (map) {
            SyncEntry o = syncMap.get(username);
            if (o == null) {
                o = new SyncEntry(username);
                syncMap.put(username, o);
            } else {
                o.incrementRef();
            }
            Logger loggerIf = LogManager.getLogger((String)OMIProfileStore.class.getName());
            loggerIf.trace("m3f: Returning object " + o.hashCode() + " as sync object for " + username);
            return o;
        }
    }

    private synchronized void releaseSyncEntry(SyncEntry entry) {
        if (entry.decrementRef() <= 0) {
            Logger loggerIf = LogManager.getLogger((String)OMIProfileStore.class.getName());
            loggerIf.trace("m3f: Releasing object " + entry.hashCode() + " as sync object for " + entry.username);
            syncMap.remove(entry);
        }
    }

    @Override
    public ProfileInterface loadSubprofile(String application) throws ServiceException {
        Profile result;
        ArrayList<Throwable> exceptionList;
        block12: {
            if (this._ps == null) {
                throw new ServiceException(RB.getStringResource("OMIProfileStore.nullpropset.msg.txt"));
            }
            exceptionList = new ArrayList<Throwable>(4);
            result = null;
            UserServiceInterface usi = UserContext.getUserService();
            MetadataInterface subAnchor = null;
            try {
                UserContextInterface uc = this._repos.getUserContext();
                PropertySet ps = this.getProfileSet((Root)this._ps, application);
                if (ps == null) break block12;
                ProfileInterface newProfile = null;
                ProfileDomain pd = null;
                if (usi != null) {
                    pd = usi.getProfileDefinition(application);
                    if (pd == null) {
                        pd = usi.getProfileDefinition("default");
                    }
                    if (pd == null) {
                        newProfile = new Profile(application);
                    } else {
                        try {
                            ClassLoader cl = this.getClass().getClassLoader();
                            Class<?> objectClass = cl.loadClass(pd.getClassName());
                            Constructor<?> ctor = null;
                            Class[] ctorArgs = new Class[]{String.class};
                            ctor = objectClass.getConstructor(ctorArgs);
                            if (ctor != null) {
                                Object[] ctorParms = new Object[]{application};
                                newProfile = (ProfileInterface)ctor.newInstance(ctorParms);
                            }
                        }
                        catch (Throwable t) {
                            exceptionList.add(t);
                            newProfile = new Profile(application);
                        }
                    }
                } else {
                    newProfile = new Profile(application);
                }
                subAnchor = this._repos.factoryProcess(this._ps);
                newProfile.setLoadParameters(subAnchor, uc, this._repos, pd);
                result = newProfile;
            }
            catch (RemoteException ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
        }
        if (exceptionList.size() > 0) {
            throw new ServiceException((Throwable)exceptionList.get(0), ((Throwable)exceptionList.get(0)).getMessage());
        }
        return result;
    }

    private void load(boolean recursive) throws ServiceException {
        if (this._anchor == null) {
            throw new ServiceException(RB.getStringResource("OMIProfileStore.nullanchor.ex.txt"));
        }
        ArrayList exceptionList = new ArrayList(4);
        Object user = null;
        Logger loggerIf = LogManager.getLogger((String)OMIProfileStore.class.getName());
        try {
            loggerIf.info(Message.format((ResourceBundle)RB.getResources(), (String)"OMIProfileStore.loadprof.msg.fmt", (Object)this._profile.getApplication(), (Object)this._repos.getUrl(), (Object)this._anchor.getEntityKey()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object o = null;
        try {
            PropertySet ps;
            this._ps = ps = this.getOrMakePropertySet(true);
            AssociationList propAss = recursive ? ps.getSetProperties() : ps.getSetProperties(true);
            for (Property prop : propAss) {
                String value;
                String name = prop.getPropertyName();
                if (name == null || name.trim().length() == 0) {
                    name = prop.getName();
                }
                if ((value = prop.getDefaultValue().trim()) == null || value.length() == 0) continue;
                this._profile.addAttribute(null, name, value);
            }
        }
        catch (RemoteException rex) {
            throw new ServiceException(rex, RB.getStringResource("OMIProfileStore.remoteexception.ex.txt"));
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        if (exceptionList.size() > 0) {
            Throwable t = (Throwable)exceptionList.get(0);
            throw new ServiceException(t, t.getMessage());
        }
    }

    private void checkUnreadable(Root anchor, String application) throws ServiceException, RemoteException {
        String role = "Profile/" + application;
        Filter filter = new Filter("SetRole", 0, role);
        AssociationPathComponent pathComponent = new AssociationPathComponent("OwningObject", anchor.getCMetadataType());
        pathComponent.setAttributeCriteria(new FilterComponent("Id", 0, anchor.getFQID()));
        filter.getFilterComponent().addAssociationPathComponent(pathComponent);
        filter.setType("PropertySet");
        ServerInterface server = this._repos.getServer();
        int psCount = ((MetadataServerInterface)server).getCountNoSecurity(filter, null);
        if (psCount != 0) {
            throw new ServiceException(RB.getStringResource("OMIProfileStore.psexists.ex.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist() throws ServiceException {
        Logger logger = LogManager.getLogger((String)OMIProfileStore.class.getName());
        SyncEntry entry = null;
        try {
            UserContextInterface uc = this._repos.getUserContext();
            entry = this.getSyncObject(uc.getName());
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        Object ps = null;
        try {
            SyncEntry syncEntry = entry;
            synchronized (syncEntry) {
                block25: {
                    if (this._ps != null) break block25;
                    this.create();
                    if (this._ps != null) break block25;
                    return;
                }
                String userName = "User";
                try {
                    if (this._anchor != null) {
                        UserContextInterface user = this._anchor.getRepository().getUserContext();
                        userName = user.getName();
                    }
                }
                catch (Throwable user) {
                    // empty catch block
                }
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("m3f: " + Message.format((ResourceBundle)RB.getResources(), (String)"OMIProfileStore.persistprof.msg.fmt.txt", (Object)this._profile.getApplication(), (Object)this._repos.getUrl(), (Object)userName));
                    }
                    AssociationList propAss = null;
                    try {
                        propAss = this._ps.getSetProperties(true);
                    }
                    catch (Exception e) {
                        throw new ServiceException(e, RB.getStringResource("OMIProfileStore.nopropset.ex.txt"));
                    }
                    Map dataMap = this.makePropMap();
                    Set keys = null;
                    try {
                        keys = this._profile.keySet();
                    }
                    catch (RemoteException e) {
                        throw new ServiceException(e, RB.getStringResource("OMIProfileStore.keyseterr.ex.txt"));
                    }
                    ArrayList deadList = new ArrayList(5);
                    ArrayList newList = new ArrayList(5);
                    for (String nextKey : keys) {
                        List profileList = this._profile.getAttributes(null, nextKey);
                        List dataList = (List)dataMap.get(nextKey);
                        if (dataList == null) {
                            dataList = Collections.EMPTY_LIST;
                        }
                        this.syncLists(nextKey, profileList, dataList, newList, deadList);
                        dataMap.remove(nextKey);
                    }
                    for (List list : dataMap.values()) {
                        deadList.addAll(list);
                    }
                    this.finishPersist(newList, deadList);
                    try {
                        propAss.setState(16);
                        this._ps.setSetProperties(propAss);
                        this._ps.updateMetadataAll();
                    }
                    catch (Exception e) {
                        throw new ServiceException(e, RB.getStringResource("OMIProfileStore.updpropset.ex.txt"));
                    }
                }
                catch (RemoteException rex) {
                    throw new ServiceException(rex, RB.getStringResource("OMIProfileStore.updateprop.ex.txt"));
                }
            }
        }
        finally {
            this.releaseSyncEntry(entry);
        }
    }

    private void syncLists(String key, List profileList, List dataList, List newList, List deadList) throws ServiceException {
        try {
            if (profileList.size() == 1 && dataList.size() == 1) {
                String metadataValue;
                String profileValue = (String)profileList.get(0);
                if (!profileValue.equals(metadataValue = ((Property)dataList.get(0)).getDefaultValue())) {
                    ((Property)dataList.get(0)).setDefaultValue(profileValue);
                }
                return;
            }
            Collections.sort(profileList);
            Collections.sort(dataList, new PropertyComparator());
            int profileSize = profileList.size();
            int dataSize = dataList.size();
            int profilecnt = 0;
            int datacnt = 0;
            for (profilecnt = 0; profilecnt < profileList.size(); ++profilecnt) {
                String nextValue = (String)profileList.get(profilecnt);
                if (profilecnt + 1 > dataSize) {
                    newList.add(new PropertyHolder(key, nextValue));
                    continue;
                }
                Property prop = (Property)dataList.get(profilecnt);
                String defaultValue = prop.getDefaultValue();
                if (nextValue.equals(defaultValue)) continue;
                prop.setDefaultValue(nextValue);
            }
            if (profileSize < dataSize) {
                for (datacnt = profileSize; datacnt < dataSize; ++datacnt) {
                    Property prop = (Property)dataList.get(datacnt);
                    deadList.add(prop);
                }
            }
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void finishPersist(List newList, List deadList) throws ServiceException {
        try {
            int newSize = newList.size();
            for (int i = 0; i < newSize; ++i) {
                PropertyHolder ph = (PropertyHolder)newList.get(i);
                if (deadList.size() > 0) {
                    Property prop = (Property)deadList.get(0);
                    deadList.remove(0);
                    prop.setPropertyName(ph.key);
                    prop.setName(ph.key);
                    prop.setDefaultValue(ph.value);
                    continue;
                }
                this.addProperty(ph.key, ph.value);
            }
            if (deadList.size() > 0) {
                this.deleteProperties(deadList);
            }
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private Map makePropMap() throws ServiceException {
        if (this._ps == null) {
            return null;
        }
        try {
            AssociationList propList = this._ps.getSetProperties();
            HashMap<String, ArrayList<Property>> result = new HashMap<String, ArrayList<Property>>(propList.size());
            for (Property prop : propList) {
                String propName = prop.getPropertyName();
                ArrayList<Property> list = (ArrayList<Property>)result.get(propName);
                if (list == null) {
                    list = new ArrayList<Property>(1);
                    list.add(prop);
                    result.put(propName, list);
                    continue;
                }
                list.add(prop);
            }
            return result;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void addProperty(String name, String value) throws ServiceException {
        OMIRepositoryInterface ori = (OMIRepositoryInterface)this._repos;
        boolean canCreate = true;
        try {
            canCreate = ori.isUserAuthorizedInRepository("WriteMetadata");
        }
        catch (RemoteException rex) {
            canCreate = true;
        }
        catch (ServiceException ex) {
            canCreate = true;
        }
        if (!canCreate) {
            throw new ServiceException(RB.getStringResource("OMIProfileStore.usercantcreate.ex.txt"));
        }
        try {
            MdObjectStore store = (MdObjectStore)this._ps.getObjectStore();
            MdFactory factory = store.getFactory();
            Property prop = (Property)factory.createComplexMetadataObject(store, null, name, "Property", this._ps.getRepositoryID());
            prop.setName(name);
            prop.setPropertyName(name);
            prop.setDefaultValue(value);
            PropertyType propType = (PropertyType)factory.createComplexMetadataObject(store, null, "StringType", "PropertyType", this._ps.getRepositoryID());
            propType.setSQLType(12);
            prop.setOwningType(propType);
            this._ps.getSetProperties().add((Object)prop);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private void deleteProperties(List propList) throws ServiceException {
        ArrayList<PropertyType> typeList = new ArrayList<PropertyType>(propList.size());
        Iterator it = propList.iterator();
        try {
            while (it.hasNext()) {
                Property prop = (Property)it.next();
                typeList.add(prop.getOwningType());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        try {
            ((OMIRepositoryInterface)this._repos).deleteEntities(propList);
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        try {
            ((OMIRepositoryInterface)this._repos).deleteEntities(typeList);
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void create() throws ServiceException {
        Logger logger = LogManager.getLogger((String)OMIProfileStore.class.getName());
        String userName = "User";
        try {
            if (this._anchor != null) {
                UserContextInterface user = this._anchor.getRepository().getUserContext();
                userName = user.getName();
            }
        }
        catch (Throwable user) {
            // empty catch block
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("m3f " + Message.format((ResourceBundle)RB.getResources(), (String)"OMIProfileStore.creatprof.msg.fmt.txt", (Object)this._profile.getApplication(), (Object)this._repos.getUrl(), (Object)userName));
            }
        }
        catch (RemoteException rex) {
            throw new ServiceException(rex, rex.getMessage());
        }
        OMIRepositoryInterface ori = (OMIRepositoryInterface)this._repos;
        boolean canCreate = true;
        try {
            canCreate = ori.isUserAuthorizedInRepository("WriteMetadata");
        }
        catch (RemoteException rex) {
            canCreate = true;
        }
        catch (ServiceException ex) {
            canCreate = true;
        }
        if (!canCreate) {
            throw new ServiceException(RB.getStringResource("OMIProfileStore.usercantcreate.ex.txt"));
        }
        Object o = null;
        try {
            o = this._anchor.getRepositoryEntity();
        }
        catch (RemoteException rex) {
            throw new ServiceException(rex, RB.getStringResource("OMIProfileStore.remoteexception.ex.txt"));
        }
        if (!(o instanceof CMetadata)) {
            if (o == null) {
                throw new ServiceException(RB.getStringResource("OMIProfileStore.creatnonull.ex.fmt.txt"));
            }
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIProfileStore.wrongtype.ex.fmt", (Object)o.getClass().getName()));
        }
        try {
            PropertySet ps = this.getOrMakePropertySet(false);
            if (ps != null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIProfileStore.atmptcretdup.ex.fmt.txt", (Object)this._profile.getApplication()));
            }
            this._ps = ps = this.getOrMakePropertySet(true);
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void delete() throws ServiceException {
        Logger logger = LogManager.getLogger((String)OMIProfileStore.class.getName());
        String userName = "User";
        if (this._anchor != null) {
            try {
                UserContextInterface user = this._anchor.getRepository().getUserContext();
                userName = user.getName();
            }
            catch (Throwable user) {
                // empty catch block
            }
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OMIProfileStore.creatprof.msg.fmt.txt", (Object)this._profile.getApplication(), (Object)this._repos.getUrl(), (Object)userName));
            }
        }
        catch (RemoteException rex) {
            throw new ServiceException(rex, rex.getMessage());
        }
        Object o = null;
        try {
            o = this._anchor.getRepositoryEntity();
        }
        catch (RemoteException rex) {
            throw new ServiceException(rex, RB.getStringResource("OMIProfileStore.remoteexception.ex.txt"));
        }
        if (!(o instanceof CMetadata)) {
            if (o == null) {
                throw new ServiceException(RB.getStringResource("OMIProfileStore.creatnonull.ex.fmt.txt"));
            }
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIProfileStore.wrongtype.ex.fmt", (Object)o.getClass().getName()));
        }
        this.deletePropertySet(this._ps);
        try {
            this._ps.updateMetadataAll();
        }
        catch (MdException mdException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePropertySet(PropertySet propSet) throws ServiceException {
        SyncEntry entry = null;
        try {
            UserContextInterface uc = this._repos.getUserContext();
            entry = this.getSyncObject(uc.getName());
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        Object ps = null;
        try {
            SyncEntry syncEntry = entry;
            synchronized (syncEntry) {
                Logger loggerIf = LogManager.getLogger((String)OMIProfileStore.class.getName());
                try {
                    ArrayList propertySetList = new ArrayList(propSet.getPropertySets(true));
                    if (propertySetList.size() > 0) {
                        for (PropertySet nextPS : propertySetList) {
                            this.deletePropertySet(nextPS);
                        }
                    }
                    ArrayList attributeList = new ArrayList(propSet.getSetProperties());
                    for (Property nextProp : attributeList) {
                        PropertyType pt = nextProp.getOwningType();
                        nextProp.delete();
                        pt.delete();
                    }
                    propSet.delete();
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
                catch (RemoteException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        finally {
            this.releaseSyncEntry(entry);
        }
    }

    @Override
    public MetadataInterface getRepositoryEntity() {
        MetadataInterface mi = null;
        try {
            try {
                mi = this._repos.factoryProcess(this._ps);
            }
            catch (ServiceException svcEx) {
                mi = new Metadata(this._ps);
                mi.setRepository(this._repos);
            }
        }
        catch (RemoteException rex) {
            mi = null;
        }
        return mi;
    }

    @Override
    public RepositoryInterface getRepository() {
        return this._repos;
    }

    @Override
    public void destroy() {
        this._anchor = null;
        this._profile = null;
        this._repos = null;
        this._ps = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertySet getOrMakePropertySet(boolean doCreate) throws RemoteException, ServiceException, MdException {
        UserContextInterface uc = this._repos.getUserContext();
        SyncEntry entry = this.getSyncObject(uc.getName());
        PropertySet ps = null;
        try {
            SyncEntry syncEntry = entry;
            synchronized (syncEntry) {
                Logger loggerIf = LogManager.getLogger((String)OMIProfileStore.class.getName());
                Object o = this._anchor.getRepositoryEntity();
                if (!(o instanceof CMetadata)) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OMIProfileStore.wrongtype.ex.fmt", (Object)o.getClass().getName()));
                }
                Root entity = (Root)o;
                OMIRepositoryInterface ori = (OMIRepositoryInterface)this._repos;
                boolean canCreate = true;
                canCreate = ori.isUserAuthorizedInRepository("WriteMetadata");
                if (!canCreate) {
                    throw new ServiceException(RB.getStringResource("OMIProfileStore.usercantcreate.ex.txt"));
                }
                ps = this.getProfileSet(entity, this._profile.getApplication());
                if (ps == null && doCreate) {
                    this.checkUnreadable(entity, this._profile.getApplication());
                    MdObjectStore store = (MdObjectStore)entity.getObjectStore();
                    MdFactory factory = store.getFactory();
                    loggerIf.debug("m3f: Creating propertyset for user " + uc.getName() + " for application " + this._profile.getApplication());
                    PropertySet propSet = (PropertySet)factory.createComplexMetadataObject(store, null, this._profile.getApplication(), "PropertySet", entity.getRepositoryID());
                    propSet.setSetRole("Profile/" + this._profile.getApplication());
                    propSet.setOwningObject(entity);
                    ps = propSet;
                    propSet.updateMetadataAll();
                }
            }
        }
        finally {
            this.releaseSyncEntry(entry);
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertySet getProfileSet(Root root, String application) throws ServiceException, RemoteException {
        ArrayList<PropertySet> propertySetsToDelete = new ArrayList<PropertySet>();
        PropertySet result = null;
        Logger loggerIf = LogManager.getLogger((String)OMIProfileStore.class.getName());
        UserContextInterface uc = this._repos.getUserContext();
        SyncEntry entry = this.getSyncObject(uc.getName());
        Object ps = null;
        try {
            SyncEntry syncEntry = entry;
            synchronized (syncEntry) {
                if (application == null) {
                    throw new ServiceException();
                }
                if (root == null) {
                    throw new ServiceException();
                }
                String role = "Profile/" + application;
                try {
                    AssociationList propertySets = root.getPropertySets(true);
                    for (PropertySet propertySet : propertySets) {
                        if (!role.equalsIgnoreCase(propertySet.getSetRole())) continue;
                        if (result != null) {
                            loggerIf.info("An extra property set named " + role + " was found and is being deleted.");
                            propertySetsToDelete.add(result);
                        }
                        result = propertySet;
                    }
                }
                catch (MdException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
                catch (RemoteException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        finally {
            this.releaseSyncEntry(entry);
        }
        if (propertySetsToDelete.size() > 0) {
            MdObjectStore store = (MdObjectStore)((Root)this._anchor.getRepositoryEntity()).getObjectStore();
            MdFactory factory = store.getFactory();
            for (PropertySet propertySet : propertySetsToDelete) {
                this.deletePropertySet(propertySet);
            }
            try {
                store.updatedMetadataAll();
            }
            catch (MdException mdException) {
                // empty catch block
            }
        }
        return result;
    }

    @SASScope
    class SyncEntry {
        private final String username;
        private int refCount;

        public SyncEntry(String username) {
            if (username == null) {
                throw new IllegalArgumentException();
            }
            this.username = username;
            this.refCount = 1;
        }

        public String getUsername() {
            return this.username;
        }

        public int getRefCount() {
            return this.refCount;
        }

        public int incrementRef() {
            ++this.refCount;
            return this.refCount;
        }

        public int decrementRef() {
            --this.refCount;
            return this.refCount;
        }

        public int hashCode() {
            int prime = 83;
            int result = 7;
            result = 83 * result + this.username.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            SyncEntry rhs = (SyncEntry)obj;
            return this.username.equals(rhs.username);
        }
    }

    @SASScope
    class PropertyComparator
    implements Comparator {
        PropertyComparator() {
        }

        public int compare(Object o1, Object o2) {
            Property p1 = (Property)o1;
            Property p2 = (Property)o2;
            try {
                String value1 = p1.getDefaultValue();
                String value2 = p2.getDefaultValue();
                return value1.compareTo(value2);
            }
            catch (RemoteException ex) {
                return 0;
            }
        }
    }

    @SASScope
    class PropertyHolder {
        public String key;
        public String value;

        public PropertyHolder(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

