/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user.dav;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.information.metadata.dav.DAVFolderInterface;
import com.sas.services.information.metadata.dav.DAVProfile;
import com.sas.services.user.Profile;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.ProfileStoreInterface;
import com.sas.services.user.dav.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class DAVProfileStore
implements ProfileStoreInterface {
    private static final String LOG_CONTEXT = "com.sas.services.user.dav.DAVProfileStore";
    MetadataInterface _anchor;
    ProfileInterface _profile;
    RepositoryInterface _repos;
    DAVFolderInterface _ps;

    public DAVProfileStore(MetadataInterface anchor, ProfileInterface profile, RepositoryInterface repos) {
        this._anchor = anchor;
        this._profile = profile;
        this._repos = repos;
        if (this._anchor == null && this._repos instanceof DAVRepositoryInterface) {
            try {
                this._anchor = ((DAVRepositoryInterface)this._repos).makePersonalAnchor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void load() throws ServiceException {
        this.load(true);
    }

    private void load(boolean recursive) throws ServiceException {
        Logger logger = null;
        Object user = null;
        logger = LogManager.getLogger((String)DAVProfileStore.class.getName());
        try {
            MetadataInterface profile;
            Object o = this._anchor.getRepositoryEntity();
            String _url = o == null ? this._repos.getUrl() : ((DAVEntityInterface)o).getURL();
            _url = _url + '/' + this._profile.getApplication();
            if (logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVProfileStore.loadprof.fmt.txt", (Object)_url));
            }
            if ((profile = this._repos.fetch(_url.substring(this._repos.getUrl().length() + 1) + "/profile")) == null) {
                return;
            }
            DAVEntityInterface prfEntity = (DAVEntityInterface)profile.getRepositoryEntity();
            if (!prfEntity.getAttribute("{http://www.sas.com/rnd/itech/WebDAV}type").equals("profile")) {
                return;
            }
            if (!prfEntity.isCollection()) {
                return;
            }
            this._ps = (DAVFolderInterface)prfEntity;
            Map propMap = prfEntity.getAttributes();
            for (Map.Entry _me : propMap.entrySet()) {
                String propName = (String)_me.getKey();
                if (propName.startsWith("{}")) {
                    propName = propName.substring(2);
                }
                String propValue = (String)_me.getValue();
                this._profile.addAttribute(null, propName, propValue);
            }
            if (recursive) {
                for (DAVEntityInterface entity : ((DAVFolderInterface)prfEntity).getEntities()) {
                    if (!(entity instanceof DAVFolderInterface)) continue;
                    String profileName = entity.getName();
                    Profile subProfile = new Profile(profileName);
                    subProfile.load(profile, null, this._repos, null);
                    this._profile.addProfile(profileName, subProfile, false);
                }
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
            throw new ServiceException(re, RB.getStringResource("DAVProfileStore.loaderror.ex.txt"));
        }
    }

    @Override
    public void refresh() throws ServiceException {
        this.load(false);
    }

    @Override
    public void create() throws ServiceException {
        Object o = null;
        try {
            o = this._anchor.getRepositoryEntity();
        }
        catch (Exception e) {
            throw new ServiceException(e, RB.getStringResource("DAVProfileStore.reposexception.ex.txt"));
        }
        if (!(o instanceof DAVEntityInterface)) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVProfileStore.wrongtype.ex.fmt", (Object)o.getClass().getName()));
        }
        try {
            DAVFolderInterface c = (DAVFolderInterface)o;
            String reposId = c.getReposId();
            reposId = reposId.substring(0, reposId.lastIndexOf("/"));
            reposId = reposId + '/' + this._profile.getApplication() + "/profile";
            DAVProfile newprofile = new DAVProfile(this._repos, reposId);
            Metadata mi = new Metadata(newprofile);
            this._repos.addEntity(mi);
            this._ps = newprofile;
        }
        catch (RemoteException re) {
            throw new ServiceException(re, RB.getStringResource("DAVProfileStore.remoteexception.ex.txt"));
        }
    }

    @Override
    public void delete() throws ServiceException {
        try {
            this._ps.delete();
        }
        catch (RemoteException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public MetadataInterface getRepositoryEntity() {
        Metadata mi = null;
        try {
            mi = new Metadata(this._ps);
        }
        catch (RemoteException e) {
            mi = null;
        }
        return mi;
    }

    @Override
    public RepositoryInterface getRepository() {
        return this._repos;
    }

    @Override
    public void persist() throws ServiceException {
        Logger logger = LogManager.getLogger((String)DAVProfileStore.class.getName());
        if (this._ps == null) {
            this.create();
            if (this._ps == null) {
                return;
            }
        }
        if (logger.isDebugEnabled()) {
            String application;
            try {
                application = this._profile.getApplication();
            }
            catch (RemoteException e) {
                throw new ServiceException(e, RB.getStringResource("DAVProfileStore.applnameerr.ex.txt"));
            }
            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVProfileStore.persistbegin.fmt.txt", (Object)application));
        }
        HashMap propAss = new HashMap(this._ps.getAttributes());
        Set keys = null;
        try {
            keys = this._profile.keySet();
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("DAVProfileStore.keyserr.ex.txt"));
        }
        for (String nextKey : keys) {
            List values = null;
            try {
                values = this._profile.getAttributes(null, nextKey);
            }
            catch (Exception ex) {
                throw new ServiceException(ex, RB.getStringResource("DAVProfileStore.valueerr.ex.txt"));
            }
            Iterator valueIter = values.iterator();
            while (valueIter.hasNext()) {
                String prfKey = nextKey;
                String value = (String)valueIter.next();
                if (!nextKey.startsWith("{")) {
                    prfKey = "{}" + nextKey;
                    if (propAss.containsKey(prfKey)) {
                        String propVal = (String)propAss.get(prfKey);
                        if (!propVal.equals(value)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVProfileStore.setprop.fmt.txt", (Object)prfKey, (Object)value));
                            }
                            this._ps.setAttribute(prfKey, value);
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVProfileStore.addprop.fmt.txt", (Object)prfKey, (Object)value));
                        }
                        this._ps.addAttribute(prfKey, value);
                    }
                }
                propAss.remove(prfKey);
            }
        }
        for (String prfKey : propAss.keySet()) {
            if (prfKey.startsWith("{")) continue;
            prfKey = "{}" + prfKey;
            if (logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVProfileStore.delprop.fmt.txt", (Object)prfKey));
            }
            this._ps.deleteAttribute(prfKey);
        }
        try {
            this._ps.update();
        }
        catch (RemoteException re) {
            throw new ServiceException(re, RB.getStringResource("DAVProfileStore.updprofile.ex.txt"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(RB.getStringResource("DAVProfileStore.persistend.fmt.txt"));
        }
    }

    @Override
    public void destroy() {
        this._anchor = null;
        this._profile = null;
        this._repos = null;
        this._ps = null;
    }

    @Override
    public ProfileInterface loadSubprofile(String application) throws ServiceException {
        return null;
    }
}

