/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.services.SyntaxException;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.user.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ProfileDomain
implements Cloneable,
ConsumedResourceInterface,
Serializable {
    private static final long serialVersionUID = -8123924039039155445L;
    private static final String TOKEN_PROTOCOL_HOST = "://";
    private static final String TOKEN_COLON = ":";
    private String _uid = GUID.newGUID();
    private String _url;
    private String _type;
    private String _filter;
    private String _base;
    private String _className;

    public ProfileDomain(String url, String type, String filter, String className) {
        this._url = url;
        this._type = type;
        this._filter = filter;
        this._className = className;
    }

    public ProfileDomain(String uid, String url, String type, String filter, String className) {
        this(url, type, filter, className);
        if (uid != null && uid.length() > 0) {
            this._uid = uid;
        }
    }

    public static void validateDomainURL(String domainURL) throws SyntaxException {
        try {
            if (domainURL != null) {
                int urlLength = domainURL.length();
                int indexProtocol = domainURL.indexOf(TOKEN_COLON);
                if (indexProtocol > 0) {
                    String protocol = domainURL.substring(0, indexProtocol);
                    ProfileDomain.validateDomainURLProtocol(protocol);
                    int indexHost = domainURL.indexOf(TOKEN_PROTOCOL_HOST) + TOKEN_PROTOCOL_HOST.length();
                    int indexPort = domainURL.indexOf(TOKEN_COLON, indexProtocol + 1);
                    if (indexPort == -1) {
                        String host = domainURL.substring(indexHost, urlLength);
                        ProfileDomain.validateDomainURLHost(host);
                    } else if (indexPort > indexProtocol) {
                        String host = domainURL.substring(indexHost, indexPort);
                        ProfileDomain.validateDomainURLHost(host);
                        String port = domainURL.substring(indexPort + 1, urlLength);
                        ProfileDomain.validateDomainURLPort(port);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SyntaxException(RB.getStringResource("ProfileDomain.invalidDomainURL.ex.txt"));
        }
    }

    private static void validateDomainURLProtocol(String protocol) throws SyntaxException {
        String msg = null;
        try {
            if (protocol == null) {
                msg = RB.getStringResource("ProfileDomain.invalidNullProtocol.ex.txt");
            } else if (!(protocol.equals("ldap") || protocol.equals("omi") || protocol.equals("dav"))) {
                String validProtocols = "dav, ldap, omi";
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"ProfileDomain.invalidProtocol.ex.fmt.txt", (Object)protocol, (Object)"dav, ldap, omi");
            }
            if (msg != null) {
                throw new SyntaxException(msg);
            }
        }
        catch (Exception e) {
            throw new SyntaxException(e, RB.getStringResource("ProfileDomain.invalidProtocol.ext.txt"));
        }
    }

    private static void validateDomainURLHost(String host) throws SyntaxException {
        String msg = null;
        try {
            if (host == null) {
                msg = RB.getStringResource("ProfileDomain.invalidNullHost.ex.txt");
            }
            if (msg != null) {
                throw new SyntaxException(msg);
            }
        }
        catch (Exception e) {
            throw new SyntaxException(e, RB.getStringResource("ProfileDomain.invalidHost.ext.txt"));
        }
    }

    private static void validateDomainURLPort(String portNumber) throws SyntaxException {
        try {
            if (portNumber != null) {
                Integer.valueOf(portNumber);
            }
        }
        catch (NumberFormatException e) {
            throw new SyntaxException(e, Message.format((ResourceBundle)RB.getResources(), (String)"ProfileDomain.invalidPort.ext.fmt.txt", (Object)portNumber));
        }
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setFilter(String filter) {
        this._filter = filter;
    }

    public void setBase(String base) {
        this._base = base;
    }

    public String getBase() {
        return this._base;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public String getClassName() {
        return this._className;
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (this == o) {
            isEqual = true;
        } else if (o != null && o.getClass() == this.getClass()) {
            ProfileDomain other = (ProfileDomain)o;
            isEqual = this.isEqual(this._base, other.getBase()) && this.isEqual(this._className, other.getClassName()) && this.isEqual(this._filter, other.getFilter()) && this.isEqual(this._type, other.getType()) && this.isEqual(this._url, other.getUrl());
        }
        return isEqual;
    }

    private boolean isEqual(String value1, String value2) {
        boolean isEqual = true;
        isEqual = value1 == null || value2 == null ? (value1 == null ? value2 == null || value2.length() == 0 : value1 == null || value1.length() == 0) : Strings.equal((String)value1, (String)value2, (boolean)false, (boolean)false);
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 5;
        int primeNumber = 31;
        hashCode = 31 * hashCode + (this._base == null || this._base.length() == 0 ? 0 : this._base.hashCode());
        hashCode = 31 * hashCode + (this._className == null || this._className.length() == 0 ? 0 : this._className.hashCode());
        hashCode = 31 * hashCode + (this._filter == null || this._filter.length() == 0 ? 0 : this._filter.hashCode());
        hashCode = 31 * hashCode + (this._type == null || this._type.length() == 0 ? 0 : this._type.hashCode());
        hashCode = 31 * hashCode + (this._url == null || this._url.length() == 0 ? 0 : this._url.hashCode());
        return hashCode;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    boolean hasConflict(ProfileDomain other) {
        boolean isEqual = false;
        if (this == other) {
            isEqual = true;
        } else {
            String otherBase = other.getBase();
            String otherClass = other.getClassName();
            String otherFilter = other.getFilter();
            String otherType = other.getType();
            String otherURL = other.getUrl();
            isEqual = !(otherBase != null && !"".equals(otherBase) && this._base != null && !Strings.equal((String)otherBase, (String)this._base, (boolean)false, (boolean)false) || otherClass != null && !"".equals(otherClass) && this._className != null && !Strings.equal((String)otherClass, (String)this._className, (boolean)false, (boolean)false) || otherFilter != null && !"".equals(otherFilter) && this._filter != null && !Strings.equal((String)otherFilter, (String)this._filter, (boolean)false, (boolean)false) || otherType != null && !"".equals(otherType) && this._type != null && !Strings.equal((String)otherType, (String)this._type, (boolean)false, (boolean)false) || otherURL != null && !"".equals(otherURL) && this._url != null && !Strings.equal((String)otherURL, (String)this._url, (boolean)false, (boolean)false));
        }
        return !isEqual;
    }

    void merge(ProfileDomain newObject) {
        if (newObject != null) {
            String value = newObject.getBase();
            if (value != null) {
                this.setBase(value);
            }
            if ((value = newObject.getClassName()) != null) {
                this.setClassName(value);
            }
            if ((value = newObject.getFilter()) != null) {
                this.setFilter(value);
            }
            if ((value = newObject.getType()) != null) {
                this.setType(value);
            }
            if ((value = newObject.getUrl()) != null) {
                this.setUrl(value);
            }
        }
    }

    void replace(ProfileDomain newObject) {
        if (newObject != null) {
            this.setBase(newObject.getBase());
            this.setClassName(newObject.getClassName());
            this.setFilter(newObject.getFilter());
            this.setType(newObject.getType());
            this.setUrl(newObject.getUrl());
        }
    }

    @Override
    public String getResourceID() {
        return this._uid;
    }

    @Override
    public String getResourceValue() {
        return this._url;
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("ProfileDomain.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTypeValue.profile.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return "Profile";
    }

    @Override
    public int getResourceTypeCode() {
        return 4;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    public String toString() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ProfileDomain.toString.fmt.txt", (Object)this._type, (Object)this._url, (Object)this._className, (Object)this._filter, (Object)this._base);
    }
}

