/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.PersonalRepositoryInterface;
import com.sas.services.user.GlobalProfileInterface;
import com.sas.services.user.GroupProfileInterface;
import com.sas.services.user.Profile;
import com.sas.services.user.ProfileDomain;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.RB;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class GlobalProfile
extends Profile
implements GlobalProfileInterface {
    private static final long serialVersionUID = 2541770591588368009L;
    public static final String LOCALE_KEY = "Locale.DefaultLocale";
    private static final int EMPTY_LIST_INIT = 1;
    private IdentityInterface _person = null;
    private UserContextInterface _user;

    public GlobalProfile(String application) throws RemoteException {
        super(application, GlobalProfile.class);
    }

    @Override
    public GroupProfileInterface getGroupProfile(String group) throws RemoteException {
        return null;
    }

    @Override
    public List getGroupProfiles() throws RemoteException {
        return new ArrayList(1);
    }

    @Override
    public String getAttribute(String application, String key) throws RemoteException, ServiceException {
        String result = super.getAttribute(application, key);
        return result;
    }

    @Override
    protected List getAttribute(String key) throws RemoteException {
        if (key.equalsIgnoreCase("name")) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(this.getName());
            return list;
        }
        if (key.equalsIgnoreCase("mail")) {
            try {
                return this.getMail();
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return super.getAttribute(key);
    }

    @Override
    protected void setAttribute(String key, String value) throws RemoteException {
        if (key.equalsIgnoreCase("name")) {
            this.setName(value);
            return;
        }
        if (key.equalsIgnoreCase("mail")) {
            try {
                this.setMail(value);
                return;
            }
            catch (ServiceException ex) {
                return;
            }
        }
        super.setAttribute(key, value);
    }

    @Override
    protected void addAttribute(String key, String value) throws RemoteException {
        if (key.equalsIgnoreCase("name")) {
            return;
        }
        if (key.equalsIgnoreCase("mail")) {
            try {
                this.addMail(value);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            return;
        }
        super.addAttribute(key, value);
    }

    @Override
    public void setLoadParameters(MetadataInterface root, UserContextInterface user, RepositoryInterface repos, ProfileDomain pd) throws RemoteException, ServiceException {
        if (root == null) {
            throw new ServiceException(RB.getStringResource("Profile.nullanchor.ex.txt"));
        }
        this._person = (IdentityInterface)root;
        this._user = user;
        super.setLoadParameters(root, user, repos, pd);
    }

    @Override
    public void load(MetadataInterface root, UserContextInterface user, RepositoryInterface repos, ProfileDomain pd) throws RemoteException, ServiceException {
        if (root == null) {
            throw new ServiceException(RB.getStringResource("Profile.nullanchor.ex.txt"));
        }
        this._person = (IdentityInterface)root;
        this._user = user;
        super.load(root, user, repos, pd);
    }

    @Override
    public void persist(String application, boolean recursive) throws RemoteException, ServiceException {
        if (application == null || application.length() == 0) {
            if (this._person != null) {
                this._person.update();
            }
            super.persist(application, recursive);
            return;
        }
        ProfileInterface p = this.getProfile(application);
        p.persist(null, recursive);
    }

    @Override
    public String getName() throws RemoteException {
        return this._person != null ? this._person.getName() : null;
    }

    @Override
    public void setName(String name) throws RemoteException {
        if (this._person != null) {
            this._person.setName(name);
        }
    }

    @Override
    public List getMail() throws ServiceException, RemoteException {
        List list = null;
        if (this._person != null && this._person instanceof PersonInterface) {
            list = ((PersonInterface)this._person).getEmailAddresses();
        }
        if (list == null) {
            list = new ArrayList(1);
        }
        return list;
    }

    @Override
    public ProfileInterface getProfile(String application) throws RemoteException, ServiceException {
        if (application.equals("SAS")) {
            return super.getProfile(application, true);
        }
        return super.getProfile(application);
    }

    @Override
    public void setMail(String address) throws ServiceException, RemoteException {
        if (this._person != null && this._person instanceof PersonInterface) {
            List list = ((PersonInterface)this._person).getEmailAddresses();
            for (String nextAddress : list) {
                ((PersonInterface)this._person).removeEmailAddress(nextAddress);
            }
            ((PersonInterface)this._person).addEmailAddress(address);
        }
    }

    @Override
    public void addMail(String address) throws ServiceException, RemoteException {
        if (this._person != null && this._person instanceof PersonInterface) {
            ((PersonInterface)this._person).addEmailAddress(address);
        }
    }

    @Override
    public void removeMail(String address) throws ServiceException, RemoteException {
        if (this._person != null && this._person instanceof PersonInterface) {
            ((PersonInterface)this._person).removeEmailAddress(address);
        }
    }

    @Override
    public Locale getLocale(String application) throws ServiceException, RemoteException {
        if (application == null || application.trim().length() == 0 || application.equals("SAS")) {
            return this.getLocale();
        }
        return super.getLocale(application);
    }

    @Override
    public void setLocale(String application, Locale locale) throws ServiceException, RemoteException {
        if (application == null || application.trim().length() == 0 || application.equals("SAS")) {
            this.setLocale(locale);
        } else {
            super.setLocale(application, locale);
        }
    }

    @Override
    public Locale getLocale() throws ServiceException, RemoteException {
        String localeString = this.getAttribute("SAS", LOCALE_KEY);
        if (localeString == null) {
            return super.getLocale(null);
        }
        return this.attribute2Locale(localeString);
    }

    @Override
    public void setLocale(Locale locale) throws ServiceException, RemoteException {
        String value = locale == null ? null : locale.toString();
        this.setAttribute("SAS", LOCALE_KEY, value);
    }

    @Override
    public PersonalRepositoryInterface getPersonalRepository() throws ServiceException, RemoteException {
        if (this._user != null && this._person != null) {
            Logger _logger = LogManager.getLogger((String)this.getClass().getName());
            String prHome = this.getAttribute("", "PersonalRepositoryHome");
            RepositoryInterface prRepos = null;
            if (prHome != null) {
                prRepos = this._user.getRepository(prHome);
                if (prRepos == null) {
                    prRepos = UserContext.getInformationService().connectByName(this._user, prHome);
                    if (_logger != null && _logger.isDebugEnabled()) {
                        _logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"GlobalProfile.connectpr.fmt.txt", (Object)prHome));
                    }
                } else if (_logger != null && _logger.isDebugEnabled()) {
                    _logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"GlobalProfile.alreadypr.fmt.txt", (Object)prHome));
                }
                if (prRepos instanceof DAVRepositoryInterface) {
                    if (_logger != null) {
                        _logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"GlobalProfile.usingpr.fmt.txt", (Object)prRepos.getUrl()));
                    }
                    return ((DAVRepositoryInterface)prRepos).getPersonalRepository();
                }
                if (_logger != null) {
                    _logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"GlobalProfile.notfoundpr2.fmt.txt", (Object)prHome));
                }
            } else {
                List servers = this._user.getRepositories();
                Iterator srvrList = servers.iterator();
                RepositoryInterface ri = null;
                while (srvrList.hasNext()) {
                    ri = (RepositoryInterface)srvrList.next();
                    if (_logger != null && _logger.isDebugEnabled()) {
                        _logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"GlobalProfile.checkpr.fmt.txt", (Object)ri.getUrl()));
                    }
                    if (!(ri instanceof DAVRepositoryInterface)) continue;
                    if (_logger != null) {
                        _logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"GlobalProfile.usingpr.fmt.txt", (Object)ri.getUrl()));
                    }
                    return ((DAVRepositoryInterface)ri).getPersonalRepository();
                }
                if (_logger != null) {
                    _logger.warn(RB.getStringResource("GlobalProfile.notfoundpr.txt"));
                }
                throw new ServiceException(RB.getStringResource("GlobalProfile.nodavservers.txt"));
            }
        }
        return null;
    }

    @Override
    public void destroy() throws RemoteException {
        this._person = null;
        this._user = null;
        super.destroy();
    }
}

