/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.session;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.DocumentServiceConfigAdapterInterface;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.session.RB;
import com.sas.services.session.SessionServiceInitObject;
import com.sas.util.UsageVersion;
import java.text.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class SessionServiceInitializer
implements DocumentServiceConfigAdapterInterface {
    private static final String XML_DOCUMENT = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!DOCTYPE SessionService><SessionService xmlns=\"urn:sas:SessionService\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:sas:SessionService com_sas_services_session_SessionService_9_2_0_0.xsd\" userContextName=\"\"/>";
    public static final String XML_ELEMENT_SESSION_SERVICE = "SessionService";
    public static final String XML_ATTRIBUTE_USER_CONTEXT = "userContextName";
    public static final String XML_ATTRIBUTE_TIMEOUT = "sessionContextTimeout";

    SessionServiceInitializer() {
    }

    @Override
    public AbstractServiceComponentConfig createConfigFromDocument(Document document) throws ServiceException {
        return SessionServiceInitializer.parse(document);
    }

    public static final SessionServiceInitObject parse(Document document) throws ServiceConfigurationException {
        SessionServiceInitObject.validate(document);
        SessionServiceInitObject serviceConfig = new SessionServiceInitObject();
        Element element = document.getDocumentElement();
        try {
            serviceConfig.setUsageVersion(UsageVersion.parseVersion((String)element.getAttribute("version")));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        serviceConfig.setUserContextName(element.getAttribute(XML_ATTRIBUTE_USER_CONTEXT));
        String s = element.getAttribute(XML_ATTRIBUTE_TIMEOUT);
        if (s != null && !s.equals("")) {
            try {
                serviceConfig.setSessionContextTimeout(Long.valueOf(s));
            }
            catch (NumberFormatException e) {
                throw new ServiceConfigurationException(e, RB.getStringResource("SessionServiceInitObject.invalidTimeout.ex.txt"));
            }
        }
        NodeList nodeList = element.getChildNodes();
        int numNodes = nodeList.getLength();
        Node node = null;
        for (int i = 0; i < numNodes; ++i) {
            node = nodeList.item(i);
            if (1 != node.getNodeType() || !"ConsumerUsage".equals((element = (Element)node).getNodeName())) continue;
            serviceConfig.parseConsumerUsage(element);
        }
        return serviceConfig;
    }

    static final String getXMLDocument() {
        return XML_DOCUMENT;
    }
}

