/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security;

import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceFactory;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.security.AuthenticationService;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.security.AuthenticationServiceProfile;
import com.sas.services.security.RB;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;

@SASScope
public class AuthenticationServiceFactory
extends AbstractServiceFactory {
    public AuthenticationServiceFactory() {
        super(new AuthenticationServiceProfile());
    }

    @Override
    public final RemoteServiceInterface getService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        AuthenticationServiceInterface service = null;
        try {
            service = AuthenticationService.defaultInstance(serviceConfiguration, discoveryService);
        }
        catch (RemoteException e) {
            String msg = RB.getStringResource("AuthenticationServiceFactory.getService.ex.txt");
            LogManager.getLogger(AuthenticationServiceFactory.class).error(msg, (Throwable)e);
            throw new ServiceException(e, msg);
        }
        catch (RuntimeException e) {
            LogManager.getLogger(AuthenticationServiceFactory.class).error(RB.getStringResource("AuthenticationServiceFactory.getService.ex.txt"), (Throwable)e);
            throw e;
        }
        return service;
    }

    public static AuthenticationServiceInterface createService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        return (AuthenticationServiceInterface)new AuthenticationServiceFactory().getService(serviceConfiguration, discoveryService);
    }
}

