/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.net.rmi.UnicastRemoteObjectExporter;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.AbstractRemoteService;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceInitializationObject;
import com.sas.services.ServiceState;
import com.sas.services.deployment.Environment;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.security.AuthenticationServiceInitObject;
import com.sas.services.security.AuthenticationServiceInitializer;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.security.AuthenticationServiceProxy;
import com.sas.services.security.Authenticator;
import com.sas.services.security.AuthenticatorInterface;
import com.sas.services.security.LoginCallbackHandler;
import com.sas.services.security.RB;
import com.sas.services.security.login.OMILoginModule;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.login.AppConfigurationEntry;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class AuthenticationService
extends AbstractRemoteService
implements AuthenticationServiceInterface {
    private static AuthenticationServiceInterface _service = null;
    private static final String TRUSTED_LOGINMODULE_CLASS = "com.sas.services.security.login.TrustedLoginModule";
    private static final Object SYNC_OBJECT = new Object();
    private static final int NUM_DOMAINS = 32;
    private final List _authenticators = new ArrayList(5);
    private Boolean _isDestroying = Boolean.FALSE;
    private String _loginConfigAppName = "PFS";

    private AuthenticationService(DiscoveryServiceInterface discoveryService) {
        super(discoveryService);
        SSLRMISocketFactories sslRMISocketFactories = SSLRMISocketFactories.getInstance();
        Class<?> theClass = this.getClass();
        this.setRemoteableExporter((RemoteObjectExporterInterface)new UnicastRemoteObjectExporter((Remote)this, sslRMISocketFactories.getPortForClass(0, theClass), sslRMISocketFactories.getRMIClientSocketFactoryForClass(theClass), sslRMISocketFactories.getRMIServerSocketFactoryForClass(theClass), true));
    }

    private AuthenticationService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        this(discoveryService);
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException(RB.getStringResource("AuthenticationService.specifyConfig.ex.txt"));
        }
        try {
            this.configure(serviceConfiguration);
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("AuthenticationService.configure.ex.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AuthenticationServiceInterface defaultInstance(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws RemoteException, ServiceException {
        Object object = SYNC_OBJECT;
        synchronized (object) {
            block8: {
                if (_service == null) {
                    AuthenticationService service = new AuthenticationService(serviceConfiguration, discoveryService);
                    _service = service;
                    try {
                        service.bindToDiscoveryService();
                    }
                    catch (ServiceException e) {
                        if (service == null) break block8;
                        try {
                            service.destroy();
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        throw e;
                    }
                }
            }
        }
        return _service;
    }

    @Override
    public void configure(ServiceConfigurationInterface serviceConfiguration) throws RemoteException, ServiceException {
        super.configure(serviceConfiguration);
        Object initObject = serviceConfiguration.getInitializationObject();
        AuthenticationServiceInitObject authServiceInitObject = null;
        try {
            authServiceInitObject = (AuthenticationServiceInitObject)initObject;
        }
        catch (ClassCastException e) {
            try {
                authServiceInitObject = (AuthenticationServiceInitObject)((ServiceInitializationObject)initObject).getConfiguration(new AuthenticationServiceInitializer());
                if (authServiceInitObject == null) {
                    authServiceInitObject = new AuthenticationServiceInitObject();
                }
            }
            catch (ClassCastException cce) {
                throw new InitializationException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.config.ex.fmt.txt", (Object)AuthenticationServiceInitObject.class.getName(), (Object)initObject));
            }
        }
        this.initialize(authServiceInitObject);
    }

    public void initialize(AuthenticationServiceInitObject authServiceConfig) throws ServiceException, RemoteException {
        AuthenticationServiceInitObject serviceConfig = authServiceConfig;
        if (authServiceConfig == null) {
            serviceConfig = new AuthenticationServiceInitObject();
        }
        GetPropertyAction action = new GetPropertyAction("com.sas.services.security.LOGIN_CONFIG_APP_NAME");
        AccessController.doPrivileged(action);
        String appName = action.getValue();
        if (appName != null) {
            this._loginConfigAppName = appName;
        } else if (serviceConfig.getLoginConfigAppName() != null) {
            this._loginConfigAppName = serviceConfig.getLoginConfigAppName();
        }
    }

    private Map makeDomainMap() throws ServiceException {
        HashMap<String, DomainEntry> domainMap = new HashMap<String, DomainEntry>(32);
        try {
            Environment environment = this.getEnvironment();
            List<AppConfigurationEntry> entries = environment.getAppConfigurationEntry(this._loginConfigAppName);
            int numEntries = entries != null ? entries.size() : 0;
            int idpEntries = 0;
            for (int i = 0; i < numEntries; ++i) {
                AppConfigurationEntry entry = entries.get(i);
                Map map = entry.getOptions();
                String domain = (String)(map = LoginCallbackHandler.getDelegateOptionMap(map)).get("domain");
                if (domain == null) continue;
                String className = entry.getLoginModuleName();
                boolean isTrusted = false;
                String idp = null;
                if (TRUSTED_LOGINMODULE_CLASS.equals(className)) {
                    isTrusted = true;
                } else if (OMILoginModule.isIDPropagation((Map)map)) {
                    String val = (String)map.get("idpropagation");
                    idp = OMILoginModule.normalizeIDPropagation((String)val);
                    if (++idpEntries > 1) {
                        String key = "AuthenticationService.multiIDPropEntries.ex.txt";
                        String msg = RB.getStringResource(key);
                        throw new InitializationException(msg);
                    }
                }
                domainMap.put(domain, new DomainEntry(domain, isTrusted, idp));
            }
        }
        catch (Throwable t) {
            System.out.println(RB.getStringResource("Authenticator.jaaserror.ex.txt"));
            t.printStackTrace(System.out);
        }
        return domainMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws ServiceException, RemoteException {
        boolean isOKToDestroy = false;
        Boolean bl = this._isDestroying;
        synchronized (bl) {
            if (Boolean.FALSE.equals(this._isDestroying)) {
                this._isDestroying = Boolean.TRUE;
                isOKToDestroy = true;
            }
        }
        if (isOKToDestroy) {
            try {
                short serviceState = this.getServiceState();
                if (!ServiceState.isStateDeactivated(serviceState)) {
                    this._authenticators.clear();
                    _service = null;
                }
            }
            finally {
                try {
                    super.destroy();
                }
                finally {
                    Boolean bl2 = this._isDestroying;
                    synchronized (bl2) {
                        this._isDestroying = Boolean.FALSE;
                    }
                }
            }
        }
    }

    @Override
    public final RemoteServiceInterface getServiceProxy() {
        AuthenticationServiceProxy proxy = null;
        try {
            proxy = new AuthenticationServiceProxy(_service);
        }
        catch (InitializationException e) {
            proxy = null;
        }
        return proxy;
    }

    @Override
    public List getDomains() throws RemoteException {
        try {
            return new ArrayList(this.makeDomainMap().keySet());
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    @Override
    public AuthenticatorInterface getAuthenticator() throws RemoteException {
        return new Authenticator();
    }

    @Override
    public final String getLoginConfigAppName() throws RemoteException {
        return this._loginConfigAppName;
    }

    @Override
    public boolean isTrusted(String domain) throws ServiceException, RemoteException {
        if (domain == null) {
            return false;
        }
        DomainEntry entry = (DomainEntry)this.makeDomainMap().get(domain);
        if (entry != null) {
            return entry.isTrusted();
        }
        throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"AuthenticationService.nosuchdomain.ex.fmt.txt", (Object)domain));
    }

    @Override
    public String getIDPropagation(String domain) throws ServiceException, RemoteException {
        if (domain == null) {
            return null;
        }
        DomainEntry entry = (DomainEntry)this.makeDomainMap().get(domain);
        if (entry != null) {
            return entry.getIDPropagation();
        }
        throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"AuthenticationService.nosuchdomain.ex.fmt.txt", (Object)domain));
    }

    @SASScope
    class DomainEntry {
        private String _name = null;
        private boolean _isTrusted = false;
        private String _idPropagation = null;

        public DomainEntry(String name, boolean isTrusted, String idPropagation) {
            this._name = name;
            this._isTrusted = isTrusted;
            this._idPropagation = idPropagation;
        }

        public final String getIDPropagation() {
            return this._idPropagation;
        }

        public final void setIDPropagation(String idPropagation) {
            this._idPropagation = idPropagation;
        }

        public final boolean isTrusted() {
            return this._isTrusted;
        }

        public final void setIsTrusted(boolean isTrusted) {
            this._isTrusted = isTrusted;
        }

        public final String getName() {
            return this._name;
        }

        public final void setName(String name) {
            this._name = name;
        }
    }
}

