/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.logging;

import com.sas.codepolicy.SASScope;
import com.sas.services.logging.LoggingService2;
import com.sas.services.logging.LoggingServiceFactory2;
import com.sas.services.logging.RB;
import com.sas.services.util.AbstractMBean;
import com.sas.text.Message;
import java.util.ResourceBundle;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanParameterInfo;

@SASScope
public class LoggingServiceMBean2
extends AbstractMBean {
    private static final String LIST_LOGGERS_METHOD_NAME = "listLoggers";
    private static final String CHANGE_LOGGER_PRIORITY_METHOD_NAME = "changeLoggerPriority";
    private static final String LOGGER_COUNT_ATTRIBUTE_NAME = "LoggerCount";
    private final String STRING_CLASS_NAME = String.class.getName();
    private final String STRING_ARRAY_CLASS_NAME = String[].class.getName();
    private final String BOOLEAN_CLASS_NAME = Boolean.class.getName();
    private static final String INT_TYPE_NAME = "int";
    private final String ATTRIBUTE_CHANGE_NOTIF_CLASS_NAME = AttributeChangeNotification.class.getName();
    private final String[] ATTRIBUTE_CHANGE_TYPE_ARRAY = new String[]{"jmx.attribute.change"};
    static final String MBEAN_DESCRIPTION = RB.getStringResource("LoggingServiceMBean.mBeanDescription.txt");
    private final String LIST_LOGGERS_DESCRIPTION = RB.getStringResource("LoggingServiceMBean.listLoggersDescription.txt");
    private final String CHANGE_LOGGER_PRIORITY_DESCRIPTION = RB.getStringResource("LoggingServiceMBean.changeLoggerPriorityDescription.txt");
    private final String LOGGER_COUNT_DESCRIPTION = RB.getStringResource("LoggingServiceMBean.loggerCountDescription.txt");
    private final String CONTEXT_PARM_NAME = RB.getStringResource("LoggingServiceMBean.contextParmName.txt");
    private final String CONTEXT_PARM_DESCRIPTION = RB.getStringResource("LoggingServiceMBean.contextParmDescription.txt");
    private final String LEVEL_PARM_NAME = RB.getStringResource("LoggingServiceMBean.levelParmName.txt");
    private final String LEVEL_PARM_DESCRIPTION = RB.getStringResource("LoggingServiceMBean.levelParmDescription.txt");
    private final String CONSTRUCTOR_NAME = RB.getStringResource("LoggingServiceMBean.constructorName.txt");
    private final String CONSTRUCTOR_DESCRIPTION = RB.getStringResource("LoggingServiceMBean.constructorDescription.txt");
    private final String NOTIFICATION_DESCRIPTION = RB.getStringResource("LoggingServiceMBean.notificationDescription.txt");
    private LoggingService2 _loggingService = null;

    @Override
    protected Object getTargetObject() {
        this.initTargetObject();
        return this;
    }

    private void initTargetObject() {
        if (this._loggingService == null) {
            try {
                this._loggingService = (LoggingService2)new LoggingServiceFactory2().getService(null);
            }
            catch (Exception e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceMBean.exceptionGetService.fmt.txt", (Object)e.toString());
                throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
            }
            catch (Error e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"LoggingServiceMBean.errorGetService.fmt.txt", (Object)e.toString());
                throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
            }
        }
    }

    public String[] listLoggers() {
        if (this._loggingService != null) {
            return this._loggingService.listLoggers();
        }
        return new String[0];
    }

    public boolean changeLoggerPriority(String loggerName, String priority) {
        if (this._loggingService != null) {
            String oldPriority = this._loggingService.getLoggerPriority(loggerName);
            boolean changeMade = this._loggingService.changeLoggerPriority(loggerName, priority);
            if (changeMade) {
                String newPriority = this._loggingService.getLoggerPriority(loggerName);
                AttributeChangeNotification notif = new AttributeChangeNotification(this, 0L, System.currentTimeMillis(), "Attribute Change", "LoggerPriority", "String", oldPriority, newPriority);
                notif.setUserData(loggerName);
                this.sendNotification(notif);
            }
            return changeMade;
        }
        return false;
    }

    public int getLoggerCount() {
        if (this._loggingService != null) {
            return this._loggingService.getLoggerCount();
        }
        return 0;
    }

    public LoggingServiceMBean2() {
        super(MBEAN_DESCRIPTION);
        this.addMBeanOperation(LIST_LOGGERS_METHOD_NAME, this.LIST_LOGGERS_DESCRIPTION, null, this.STRING_ARRAY_CLASS_NAME, 0);
        this.addMBeanOperation(CHANGE_LOGGER_PRIORITY_METHOD_NAME, this.CHANGE_LOGGER_PRIORITY_DESCRIPTION, new MBeanParameterInfo[]{new MBeanParameterInfo(this.CONTEXT_PARM_NAME, this.STRING_CLASS_NAME, this.CONTEXT_PARM_DESCRIPTION), new MBeanParameterInfo(this.LEVEL_PARM_NAME, this.STRING_CLASS_NAME, this.LEVEL_PARM_DESCRIPTION)}, this.BOOLEAN_CLASS_NAME, 1);
        this.addMBeanAttribute(LOGGER_COUNT_ATTRIBUTE_NAME, INT_TYPE_NAME, true, false, false, this.LOGGER_COUNT_DESCRIPTION);
        this.addMBeanNotification(this.ATTRIBUTE_CHANGE_TYPE_ARRAY, this.ATTRIBUTE_CHANGE_NOTIF_CLASS_NAME, this.NOTIFICATION_DESCRIPTION);
        this.addMBeanConstructor(this.CONSTRUCTOR_NAME, this.CONSTRUCTOR_DESCRIPTION, null);
    }
}

