/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.logging;

import com.sas.codepolicy.SASScope;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.net.rmi.UnicastRemoteObjectExporter;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.AbstractRemoteService;
import com.sas.services.InitializationException;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceInitializationObject;
import com.sas.services.ServiceState;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.logging.AbstractLogger2;
import com.sas.services.logging.Context;
import com.sas.services.logging.LoggingLog;
import com.sas.services.logging.LoggingServiceInitObject2;
import com.sas.services.logging.LoggingServiceInitializer2;
import com.sas.services.logging.LoggingServiceMBean2;
import com.sas.services.logging.Output;
import com.sas.services.logging.RB;
import com.sas.services.util.GetPropertyAction;
import com.sas.services.util.JMXAgent;
import com.sas.services.util.JMXRegistration;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.xml.sax.InputSource;

@SASScope
public class LoggingService2
extends AbstractRemoteService {
    public static final int FATAL = 50000;
    public static final int ERROR = 40000;
    public static final int WARN = 30000;
    public static final int INFO = 20000;
    public static final int DEBUG = 10000;
    private static LoggingService2 _loggingService = null;
    private static String _logURL = null;
    private static final Object SYNC_OBJECT = new Object();
    public static final int IMPLEMENTATION_LOG4J = 1;
    private int _implementation = 1;
    private Map<String, Logger> _logMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, Logger>> _sessionLogMap = Collections.synchronizedMap(new HashMap());
    private static final String ENVIRONMENT_VARIABLE_LOGURL = "com.sas.services.logging.configurationURL";
    private static final String ENVIRONMENT_VARIABLE_MAX_FILE_SIZE = "com.sas.services.logging.maxFileSize";
    private static final String ENVIRONMENT_VARIABLE_MAX_BACKUP_INDEX = "com.sas.services.logging.maxBackupIndex";
    private static final String ENVIRONMENT_VARIABLE_DATE_PATTERN = "com.sas.services.logging.datePattern";
    private static final String DEFAULT_MAX_FILE_SIZE_STRING = "10MB";
    private static final String DEFAULT_MAX_BACKUP_INDEX_STRING = "1";
    public static final String LOGGER_NAME_IN_SESSION_CONTEXT = "com.sas.services.logging.Logger.constructor";
    private static final String PRIORITY_DEBUG = "DEBUG";
    private static final String PRIORITY_INFO = "INFO";
    private static final String PRIORITY_WARN = "WARN";
    private static final String PRIORITY_ERROR = "ERROR";
    private static final String PRIORITY_FATAL = "FATAL";
    private boolean _destroyed = false;
    private boolean _destroyingLoggers;
    private JMXAgent _agent;
    private JMXRegistration _mbeanJMXRegistration;
    String _maxFileSize;
    String _maxBackupIndex;
    String _datePattern;

    private LoggingService2(DiscoveryServiceInterface discoveryService) throws ServiceException {
        super(discoveryService);
        SSLRMISocketFactories sslRMISocketFactories = SSLRMISocketFactories.getInstance();
        Class<?> theClass = this.getClass();
        this.setRemoteableExporter((RemoteObjectExporterInterface)new UnicastRemoteObjectExporter((Remote)this, sslRMISocketFactories.getPortForClass(0, theClass), sslRMISocketFactories.getRMIClientSocketFactoryForClass(theClass), sslRMISocketFactories.getRMIServerSocketFactoryForClass(theClass), true));
        this._maxFileSize = AccessController.doPrivileged(new GetPropertyAction(ENVIRONMENT_VARIABLE_MAX_FILE_SIZE));
        if (LoggingLog.isDebug() && this._maxFileSize != null) {
            LoggingLog.debug("Global maxFileSize set to " + this._maxFileSize);
        }
        this._maxBackupIndex = AccessController.doPrivileged(new GetPropertyAction(ENVIRONMENT_VARIABLE_MAX_BACKUP_INDEX));
        if (LoggingLog.isDebug() && this._maxBackupIndex != null) {
            LoggingLog.debug("Global maxBackupIndex set to " + this._maxBackupIndex);
        }
        this._datePattern = AccessController.doPrivileged(new GetPropertyAction(ENVIRONMENT_VARIABLE_DATE_PATTERN));
        if (LoggingLog.isDebug() && this._datePattern != null) {
            LoggingLog.debug("Global datePattern set to " + this._datePattern);
        }
    }

    private LoggingService2(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws RemoteException, InitializationException, ServiceException {
        this(discoveryService);
        try {
            this.configure(serviceConfiguration);
        }
        catch (ServiceException e) {
            this.destroy();
            throw e;
        }
        catch (RemoteException e) {
            this.destroy();
            throw e;
        }
        try {
            String mbeanObjectName;
            this._agent = JMXAgent.getInstance();
            if (this._agent != null && this._agent.isMBeanEnabled(mbeanObjectName = Names.getObjectName("LoggingService2", this))) {
                LoggingServiceMBean2 mbean = new LoggingServiceMBean2();
                this._mbeanJMXRegistration = this._agent.registerMBean(mbean, mbeanObjectName, true);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static LoggingService2 getInstance(ServiceConfigurationInterface serviceConfiguration) throws ServiceException {
        return LoggingService2.getInstance(serviceConfiguration, DiscoveryService.defaultInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggingService2 getInstance(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        Object object = SYNC_OBJECT;
        synchronized (object) {
            if (_loggingService == null) {
                try {
                    LoggingService2 loggingService;
                    _loggingService = loggingService = new LoggingService2(serviceConfiguration, discoveryService);
                    loggingService.bindToDiscoveryService();
                }
                catch (RemoteException re) {
                    LoggingLog.error(RB.getStringResource("LoggingService.exceptionGetInstanceFailed.ex.txt"));
                    LoggingLog.error(re.getMessage());
                }
            } else {
                LoggingLog.error(RB.getStringResource("LoggingService.alreadyConfigured.ex.txt"));
            }
        }
        return _loggingService;
    }

    static LoggingService2 getService() {
        return _loggingService;
    }

    public static void setConfigurationURL(String logURL) {
        _logURL = logURL;
    }

    public void initialize(Object initObject) throws InitializationException {
        if (initObject != null && initObject instanceof LoggingServiceInitObject2) {
            LoggingServiceInitObject2 loggingServiceInitObject = (LoggingServiceInitObject2)initObject;
            this.initialize(loggingServiceInitObject);
        }
    }

    public void initialize(LoggingServiceInitObject2 initializationObject) throws InitializationException {
        if (initializationObject != null) {
            this._implementation = initializationObject.getImplementation();
            if (this._implementation == 1) {
                Log4jService log4jService = new Log4jService();
                log4jService.initialize(initializationObject);
            }
        }
    }

    @Deprecated
    public Logger getLogger(String loggingContext) throws RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("LoggingService.servicedestroyed.ex.txt"));
        }
        Logger logger = this._logMap.get(loggingContext);
        if (logger == null) {
            if (this._implementation == 1) {
                logger = LogManager.getLogger((String)loggingContext);
                if (LoggingLog.isDebug()) {
                    LoggingLog.debug("Local logger: " + loggingContext, "com.sas.services.logging.loggerAllocation");
                }
            }
            if (logger != null) {
                this._logMap.put(loggingContext, logger);
            }
        }
        return logger;
    }

    @Override
    public void configure(ServiceConfigurationInterface serviceConfiguration) throws InitializationException, RemoteException, ServiceException {
        Object initObject;
        LoggingServiceInitObject2 loggingServiceInitObject = null;
        URL url = null;
        super.configure(serviceConfiguration);
        String logURL = _logURL;
        if (logURL == null) {
            logURL = AccessController.doPrivileged(new GetPropertyAction(ENVIRONMENT_VARIABLE_LOGURL));
        }
        if (logURL != null) {
            try {
                url = new URL(logURL);
            }
            catch (MalformedURLException e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"LoggingService.exceptionConfigFile.fmt.txt", (Object)logURL);
                throw new InitializationException(msg);
            }
        }
        Object object = initObject = null == serviceConfiguration ? null : serviceConfiguration.getInitializationObject();
        if (url != null) {
            ServiceInitializationObject serviceInitObject = new ServiceInitializationObject(new InputSource(url.toString()));
            loggingServiceInitObject = (LoggingServiceInitObject2)serviceInitObject.getConfiguration(new LoggingServiceInitializer2());
        } else if (null == initObject) {
            loggingServiceInitObject = new LoggingServiceInitObject2();
        } else if (initObject instanceof LoggingServiceInitObject2) {
            loggingServiceInitObject = (LoggingServiceInitObject2)initObject;
        } else if (initObject instanceof ServiceInitializationObject) {
            loggingServiceInitObject = (LoggingServiceInitObject2)((ServiceInitializationObject)initObject).getConfiguration(new LoggingServiceInitializer2());
        } else {
            throw new InitializationException(RB.getStringResource("LoggingService.exceptionInitObject.ex.txt"));
        }
        this.initialize(loggingServiceInitObject);
        if (LoggingLog.isDebug()) {
            LoggingLog.debug("Logging Service configured.  " + (this.isAccessibleToRemoteClients() ? "Remote " : "Local ") + "Loggers will be allocated.");
        }
    }

    @Override
    public synchronized void destroy() throws ServiceException, RemoteException {
        if (this._destroyed) {
            return;
        }
        this._destroyed = true;
        this._destroyingLoggers = true;
        if (LoggingLog.isDebug()) {
            LoggingLog.debug("Loggers remaining: " + this.getLoggerCount() + ", of which " + this._logMap.size() + " are non-session-based.", "com.sas.services.logging.loggerAllocation");
        }
        LoggingService2.destroyLoggers(this._logMap);
        LoggingService2.destroySessionLoggers(this._sessionLogMap);
        this._logMap = null;
        this._sessionLogMap = null;
        this._destroyingLoggers = false;
        if (this._agent != null && null != this._mbeanJMXRegistration) {
            this._agent.unregisterMBeanUsingRegistration(this._mbeanJMXRegistration);
            this._mbeanJMXRegistration = null;
        }
        if (!ServiceState.isStateDeactivated(this.getServiceState())) {
            _loggingService = null;
            super.destroy();
        }
    }

    public int getImplementation() {
        return this._implementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyLoggers(Map<String, Logger> logs) {
        if (logs == null) {
            return;
        }
        Map<String, Logger> map = logs;
        synchronized (map) {
            if (!logs.isEmpty()) {
                logs.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroySessionLoggers(Map<String, Map<String, Logger>> logs) {
        if (logs == null) {
            return;
        }
        Map<String, Map<String, Logger>> map = logs;
        synchronized (map) {
            if (!logs.isEmpty()) {
                for (Map<String, Logger> item : logs.values()) {
                    try {
                        LoggingService2.destroyLoggers(item);
                    }
                    catch (RuntimeException runtimeException) {}
                }
                logs.clear();
            }
        }
    }

    void removeLogger(String loggingContext, String sessionID) {
        Map<String, Logger> loggerMap;
        if (!this._destroyingLoggers && (loggerMap = this._sessionLogMap.get(sessionID)) != null) {
            loggerMap.remove(loggingContext);
            if (loggerMap.isEmpty()) {
                this._sessionLogMap.remove(sessionID);
            }
        }
    }

    private Collection<Logger> getAllLoggers() {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("LoggingService.servicedestroyed.ex.txt"));
        }
        ArrayList<Logger> allLoggers = new ArrayList<Logger>(this._logMap.values());
        for (Map<String, Logger> contextLoggerMap : this._sessionLogMap.values()) {
            allLoggers.addAll(contextLoggerMap.values());
        }
        return allLoggers;
    }

    public String[] listLoggers() {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("LoggingService.servicedestroyed.ex.txt"));
        }
        TreeSet<String> contextNames = new TreeSet<String>();
        for (Logger logger : this.getAllLoggers()) {
            if (!(logger instanceof AbstractLogger2)) continue;
            contextNames.add(logger.getName());
        }
        return contextNames.toArray(new String[contextNames.size()]);
    }

    public int getLoggerCount() {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("LoggingService.servicedestroyed.ex.txt"));
        }
        return this.getAllLoggers().size();
    }

    public boolean changeLoggerPriority(String loggerName, String priority) {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("LoggingService.servicedestroyed.ex.txt"));
        }
        if (priority == null || loggerName == null) {
            return false;
        }
        boolean changeMade = false;
        int priorityInt = LoggingServiceInitializer2.priorityStringToInt(priority);
        for (Logger logger : this.getAllLoggers()) {
            String name;
            if (!(logger instanceof AbstractLogger2) || (name = logger.getName()) == null || !name.equalsIgnoreCase(loggerName)) continue;
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = lc.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(name);
            loggerConfig.setLevel(LoggingService2.convertIntToLevel(priorityInt));
            lc.updateLoggers();
            changeMade = true;
        }
        if (!changeMade && LoggingLog.isDebug()) {
            LoggingLog.debug("Attempt to change priority failed for logger: " + loggerName);
        }
        return changeMade;
    }

    public String getLoggerPriority(String loggerName) {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("LoggingService.servicedestroyed.ex.txt"));
        }
        if (loggerName == null) {
            return "";
        }
        int priorityInt = -1;
        for (Logger logger : this.getAllLoggers()) {
            String name;
            if (!(logger instanceof AbstractLogger2) || (name = logger.getName()) == null || !name.equalsIgnoreCase(loggerName)) continue;
            priorityInt = logger.getLevel().intLevel();
            break;
        }
        return this.priorityIntToString(priorityInt);
    }

    private String priorityIntToString(int value) {
        if (value == -1) {
            return "";
        }
        switch (value) {
            case 10000: {
                return PRIORITY_DEBUG;
            }
            case 20000: {
                return PRIORITY_INFO;
            }
            case 30000: {
                return PRIORITY_WARN;
            }
            case 40000: {
                return PRIORITY_ERROR;
            }
            case 50000: {
                return PRIORITY_FATAL;
            }
        }
        return "";
    }

    public static Level convertIntToLevel(int level) {
        switch (level) {
            case 10000: {
                return Level.DEBUG;
            }
            case 20000: {
                return Level.INFO;
            }
            case 30000: {
                return Level.WARN;
            }
            case 40000: {
                return Level.ERROR;
            }
            case 50000: {
                return Level.FATAL;
            }
        }
        return Level.INFO;
    }

    @SASScope
    private class Log4jService {
        private Log4jService() {
        }

        public void initialize(LoggingServiceInitObject2 initObject) {
            if (initObject.isBasicLogging()) {
                try {
                    Configurator.initialize((Configuration)new DefaultConfiguration());
                    Configurator.setRootLevel((Level)LoggingService2.convertIntToLevel(initObject.getBasicLoggingPriority()));
                }
                catch (Exception e) {
                    String msg = RB.getStringResource("LoggingService.exceptionInitLog4j.ex.txt");
                    LoggingLog.error(msg);
                    LoggingLog.error(e.getMessage());
                }
            } else {
                try {
                    Configurator.initialize((Configuration)this.convertConfig(initObject));
                }
                catch (Exception e) {
                    String msg = RB.getStringResource("LoggingService.exceptionInitLog4j.ex.txt");
                    LoggingLog.error(msg);
                    LoggingLog.error(e.getMessage());
                }
            }
        }

        private BuiltConfiguration convertConfig(LoggingServiceInitObject2 initObject) {
            ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
            List<Context> contexts = initObject.getContexts();
            for (int i = 0; i < contexts.size(); ++i) {
                Context context = contexts.get(i);
                String name = context.getName();
                String priority = context.getPriority();
                String chained = context.getChained();
                boolean isRoot = name.equalsIgnoreCase("RootLoggingContext");
                if (isRoot) {
                    RootLoggerComponentBuilder rootLogger = !priority.equals("") ? builder.newRootLogger(Level.getLevel((String)priority)) : builder.newRootLogger();
                    if (chained.equals("")) continue;
                    rootLogger.addAttribute("additivity", chained);
                    rootLogger.add(builder.newAppenderRef("stdout"));
                    builder.add(rootLogger);
                    continue;
                }
                LoggerComponentBuilder logger = !priority.equals("") ? builder.newLogger(name, Level.getLevel((String)priority)) : builder.newLogger(name);
                if (chained.equals("")) continue;
                logger.addAttribute("additivity", chained);
                Vector<String> outputRefs = context.getOutputs();
                for (int m = 0; m < outputRefs.size(); ++m) {
                    String output = outputRefs.elementAt(m);
                    logger.add(builder.newAppenderRef(output));
                }
                builder.add(logger);
            }
            List<Output> outputs = initObject.getOutputs();
            AppenderComponentBuilder appender = null;
            for (int i = 0; i < outputs.size(); ++i) {
                Output output = outputs.get(i);
                String id = output.getID();
                String async = output.getAsync();
                String type = output.getType();
                String layoutPattern = output.getLayoutPattern();
                String appenderName = "";
                if (!id.equals("")) {
                    appenderName = id;
                }
                if (!async.equals("") && async.equalsIgnoreCase("true")) {
                    AppenderComponentBuilder asyncAppender = builder.newAppender(appenderName, "Async");
                    appenderName = appenderName + "__async__child";
                    AppenderRefComponentBuilder appenderRef = builder.newAppenderRef(appenderName);
                    asyncAppender.addComponent((ComponentBuilder)appenderRef);
                    builder.add(asyncAppender);
                }
                if (!type.equals("")) {
                    if (type.equalsIgnoreCase("Console")) {
                        appender = builder.newAppender(appenderName, "Console");
                    } else if (type.equalsIgnoreCase("File")) {
                        String maxBackupIndex;
                        appender = builder.newAppender(appenderName, "RollingFile");
                        String maxFileSize = LoggingService2.this._maxFileSize;
                        if (maxFileSize == null) {
                            maxFileSize = output.getMaxFileSize();
                        }
                        if ((maxBackupIndex = LoggingService2.this._maxBackupIndex) == null) {
                            maxBackupIndex = output.getMaxBackupIndex();
                        }
                        if (maxFileSize != null || maxBackupIndex != null) {
                            if (maxFileSize == null) {
                                maxFileSize = LoggingService2.DEFAULT_MAX_FILE_SIZE_STRING;
                            }
                            if (maxBackupIndex == null) {
                                maxBackupIndex = LoggingService2.DEFAULT_MAX_BACKUP_INDEX_STRING;
                            }
                            ComponentBuilder triggerPolicies = builder.newComponent("Policies").addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", maxFileSize));
                            appender.addComponent(triggerPolicies);
                            ComponentBuilder strategy = builder.newComponent("DefaultRolloverStrategy").addAttribute("max", maxBackupIndex);
                            appender.addComponent(strategy);
                        } else {
                            String datePattern = LoggingService2.this._datePattern;
                            if (datePattern == null) {
                                datePattern = output.getDatePattern();
                            }
                            if (datePattern != null) {
                                appender.addAttribute("filePattern", datePattern);
                                ComponentBuilder triggerPolicies = builder.newComponent("Policies").addComponent(builder.newComponent("TimeBasedTriggeringPolicy"));
                                appender.addComponent(triggerPolicies);
                            }
                        }
                    } else if (type.equalsIgnoreCase("ARM")) {
                        builder.addRootProperty("packages", "com.sas.arm.log4jappender");
                        appender = builder.newAppender(appenderName, "ArmAppender");
                    } else {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"LoggingService.InvalidOutputType.fmt.txt", (Object)type);
                        LoggingLog.error(msg);
                    }
                }
                if (!layoutPattern.equals("") && appender != null) {
                    LayoutComponentBuilder layout = builder.newLayout("PatternLayout");
                    layout.addAttribute("pattern", layoutPattern);
                    appender.add(layout);
                }
                if (appender == null) continue;
                for (Map.Entry<String, String> mapEntry : output.getParams().entrySet()) {
                    String key = mapEntry.getKey();
                    if (key.equalsIgnoreCase("maxFileSize") || key.equalsIgnoreCase("maxBackupIndex")) continue;
                    String value = mapEntry.getValue();
                    if (key.equalsIgnoreCase("File")) {
                        value = this.handleBackslashInFilePath(value);
                    }
                    appender.addAttribute(key, value);
                }
            }
            if (null != appender) {
                builder.add(appender);
            }
            if (LoggingLog.isDebug() && LoggingLog.isDebugContext("com.sas.services.logging.configuration")) {
                LoggingLog.debug(RB.getStringResource("LoggingService.log4j.config.start.txt"));
                LoggingLog.debug(builder.toXmlConfiguration());
                LoggingLog.debug(RB.getStringResource("LoggingService.log4j.config.end.txt"));
            }
            return (BuiltConfiguration)builder.build();
        }

        private String handleBackslashInFilePath(String s) {
            if (s == null) {
                return null;
            }
            if (s.indexOf(92) == -1) {
                return s;
            }
            int len = s.length();
            StringBuilder sbuf = new StringBuilder(len + 4);
            int i = 0;
            while (i < len) {
                char c;
                if ((c = s.charAt(i++)) == '\\') {
                    if (s.charAt(i) != '\\') {
                        sbuf.append('\\');
                    } else {
                        sbuf.append('\\');
                        if (++i == 2 && s.charAt(i) != '\\') {
                            sbuf.append('\\');
                            sbuf.append('\\');
                        }
                    }
                }
                sbuf.append(c);
            }
            return sbuf.toString();
        }
    }
}

