/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.logging;

import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.logging.MissingOutputException;
import com.sas.services.logging.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

@Deprecated
@SASScope
public final class Context
implements Cloneable,
ConsumedResourceInterface {
    public static final String ELEMENTNAME = "LoggingContext";
    public static final String ROOT_ELEMENTNAME = "RootLoggingContext";
    public static final String OUTPUTREF_ELEMENTNAME = "OutputRef";
    public static final String ATTRIBUTE_UID = "uid";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_PRIORITY = "priority";
    public static final String ATTRIBUTE_CHAINED = "chained";
    public static final String OUTPUTREF_ATTRIBUTE_ID = "outputID";
    public static final String PROPERTYNAME_NAME = "name";
    public static final String PROPERTYNAME_PRIORITY = "priority";
    public static final String PROPERTYNAME_CHAINED = "chained";
    public static final String PROPERTYNAME_OUTPUTS = "outputs";
    private static final int PRIME_NUMBER = 31;
    private String _uid = GUID.newGUID();
    private volatile String _name;
    private volatile String _priority;
    private volatile String _chained = Boolean.FALSE.toString();
    private volatile Vector<String> _outputs = new Vector(5);

    public Context() {
        this("", "DEBUG", Boolean.FALSE.toString(), new Vector<String>(5));
    }

    public Context(String name, String priority, String chained, Vector<String> outputs) {
        this.setName(name);
        this.setPriority(priority);
        this.setChained(chained);
        this._outputs.removeAllElements();
        int numOutputs = outputs.size();
        for (int i = 0; i < numOutputs; ++i) {
            this._outputs.add(outputs.get(i));
        }
    }

    public Context(String uid, String name, String priority, String chained, Vector<String> outputs) {
        this(name, priority, chained, outputs);
        if (uid != null && uid.length() > 0) {
            this._uid = uid;
        }
    }

    public final String getName() {
        return this._name;
    }

    public final void setName(String name) {
        if (name != null) {
            this._name = name.trim();
        }
    }

    public final String getChained() {
        return this._chained;
    }

    public final void setChained(String chained) {
        if (chained != null) {
            this._chained = chained.trim();
        }
    }

    public final String getPriority() {
        return this._priority;
    }

    public final void setPriority(String priority) {
        if (priority != null) {
            this._priority = priority.trim();
        }
    }

    public final Vector<String> getOutputs() {
        return this._outputs;
    }

    public final void setOutputs(Vector<String> outputs) {
        if (outputs != null) {
            this._outputs.removeAllElements();
            int numOutputs = outputs.size();
            for (int i = 0; i < numOutputs; ++i) {
                this._outputs.add(outputs.get(i).trim());
            }
        }
    }

    public final void addOutput(String output) {
        String outputID;
        if (output != null && !this._outputs.contains(outputID = output.trim())) {
            this._outputs.add(outputID);
        }
    }

    public final void removeOutput(String output) {
        if (output != null) {
            int numOutputs = this._outputs.size();
            for (int i = 0; i < numOutputs; ++i) {
                if (!this._outputs.get(i).trim().equals(output)) continue;
                this._outputs.remove(i);
                break;
            }
        }
    }

    final DocumentFragment newDocumentFragment(Document document) throws MissingOutputException {
        return Context.newDocumentFragment(document, this);
    }

    static final DocumentFragment newDocumentFragment(Document document, Context context) throws MissingOutputException {
        DocumentFragment documentFragment = null;
        if (document != null && context != null) {
            Element elementContext;
            documentFragment = document.createDocumentFragment();
            String contextName = context.getName();
            if (contextName.equalsIgnoreCase(ROOT_ELEMENTNAME)) {
                elementContext = document.createElement(ROOT_ELEMENTNAME);
            } else {
                elementContext = document.createElement(ELEMENTNAME);
                elementContext.setAttribute("name", context.getName());
                if (context.getChained() != null && !context.getChained().equals("")) {
                    elementContext.setAttribute("chained", context.getChained());
                }
            }
            elementContext.setAttribute(ATTRIBUTE_UID, context.getResourceID());
            elementContext.setAttribute("priority", context.getPriority());
            documentFragment.appendChild(elementContext);
            int numOutputs = context.getOutputs().size();
            if (numOutputs < 1) {
                throw new MissingOutputException(Message.format((ResourceBundle)RB.getResources(), (String)"LoggingFactories.MissingOutput.fmt.txt", (Object)contextName));
            }
            for (int i = 0; i < numOutputs; ++i) {
                Element elementOutputRef = document.createElement(OUTPUTREF_ELEMENTNAME);
                elementOutputRef.setAttribute(OUTPUTREF_ATTRIBUTE_ID, context.getOutputs().get(i));
                elementContext.appendChild(elementOutputRef);
            }
        }
        return documentFragment;
    }

    final boolean isEquivalent(Context context, boolean isCheckingOutputs) {
        boolean isEqual = false;
        if (this == context) {
            isEqual = true;
        } else if (context == null) {
            isEqual = false;
        } else {
            isEqual = Strings.equal((String)this.getName(), (String)context.getName(), (boolean)false, (boolean)false);
            if (isEqual) {
                isEqual = Strings.equal((String)this.getChained(), (String)context.getChained(), (boolean)false, (boolean)false);
            }
            if (isEqual) {
                isEqual = Strings.equal((String)this.getPriority(), (String)context.getPriority(), (boolean)false, (boolean)false);
            }
            if (isEqual && isCheckingOutputs) {
                isEqual = this._outputs.equals(context.getOutputs());
            }
        }
        return isEqual;
    }

    final boolean hasConflict(Context otherContext) {
        boolean isEqual = false;
        if (this == otherContext) {
            isEqual = true;
        } else {
            String otherIsChained = otherContext.getChained();
            String otherPriority = otherContext.getPriority();
            isEqual = !(!Strings.equal((String)otherContext.getName(), (String)this.getName(), (boolean)false, (boolean)false) || !"".equals(otherIsChained) && otherIsChained != null && this._chained != null && !Strings.equal((String)otherIsChained, (String)this._chained, (boolean)false, (boolean)false) || !"".equals(otherPriority) && otherPriority != null && this._priority != null && !Strings.equal((String)otherPriority, (String)this._priority, (boolean)false, (boolean)false));
        }
        return !isEqual;
    }

    void merge(Context newContext) {
        if (newContext != null) {
            this.setName(newContext.getName());
            String value = newContext.getChained();
            if (value != null) {
                this.setChained(value);
            }
            if ((value = newContext.getPriority()) != null && !"".equals(value)) {
                this.setPriority(value);
            }
            for (String outputID : new ArrayList<String>(newContext.getOutputs())) {
                this.addOutput(outputID);
            }
        }
    }

    void replace(Context newContext) {
        if (newContext != null) {
            this.setChained(newContext.getChained());
            this.setPriority(newContext.getPriority());
            for (String outputID : newContext.getOutputs()) {
                this.addOutput(outputID);
            }
        }
    }

    public final boolean equals(Object obj) {
        boolean isEqual = false;
        if (this == obj) {
            isEqual = true;
        } else if (obj == null) {
            isEqual = false;
        } else {
            try {
                isEqual = this.isEquivalent((Context)obj, true);
            }
            catch (ClassCastException e) {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public final int hashCode() {
        int hashCode = 31;
        if (this._chained != null) {
            hashCode ^= this._chained.hashCode();
        }
        if (this._name != null) {
            hashCode ^= this._name.hashCode();
        }
        if (this._priority != null) {
            hashCode ^= this._priority.hashCode();
        }
        if (this._outputs != null) {
            hashCode ^= this._outputs.hashCode();
        }
        return hashCode;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Context context = (Context)super.clone();
        context.setOutputs((Vector)this._outputs.clone());
        return context;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[name=");
        sb.append(this._name);
        sb.append("][priority=");
        sb.append(this._priority);
        sb.append("][isChained=");
        sb.append(this._chained);
        if (this._outputs.size() > 0) {
            sb.append("][outputs: ");
            sb.append(this._outputs.toString());
            sb.append(']');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getResourceID() {
        return this._uid;
    }

    @Override
    public String getResourceValue() {
        return this._name;
    }

    @Override
    public String getLocalizedResourceType() {
        return RB.getStringResource("Context.resourceType.txt");
    }

    @Override
    public String getLocalizedResourceTypeAndValue() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"Common.ResourceTypeValue.fmt.txt", (Object)this.getLocalizedResourceType(), (Object)this.getResourceValue());
    }

    @Override
    public String getResourceType() {
        return "Context";
    }

    @Override
    public int getResourceTypeCode() {
        return 0;
    }

    @Override
    public boolean isRequired() {
        return false;
    }
}

