/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.util;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceUrlResolver {
    private static final Logger logger = LogManager.getLogger(ServiceUrlResolver.class);
    private static final String TEMPLATE = "<Templates><DeployedComponent><DescriptiveComponent /><SourceConnections /></DeployedComponent><SoftwareComponent><DeployedComponents /></SoftwareComponent><TCPIPConnection CommunicationProtocol=\"\" HostName=\"\" Port=\"\" Service=\"\" /></Templates>";
    private RepositoryInterface repository;

    public ServiceUrlResolver(RepositoryInterface repository) {
        this.repository = repository;
    }

    public String getUrl(String serviceName) throws RemoteException, ServiceException {
        BrowseMetadataInterface deployedComponentService;
        List descriptiveComponentList;
        Filter f = new Filter("Name", 0, serviceName);
        f.setType("DeployedComponent");
        f.setOMRTemplate(TEMPLATE);
        f.setOMRFlags(512);
        List list = this.repository.browseSearch(f);
        if (null == list || list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            logger.warn("Found more than one match for supposedly unique service, using first...");
        }
        if (null == (descriptiveComponentList = (List)(deployedComponentService = (BrowseMetadataInterface)list.get(0)).get("DescriptiveComponent")) || descriptiveComponentList.isEmpty()) {
            return null;
        }
        BrowseMetadataInterface descriptiveComponent = (BrowseMetadataInterface)descriptiveComponentList.get(0);
        List deployedComponentsList = (List)descriptiveComponent.get("DeployedComponents");
        if (null == deployedComponentsList || deployedComponentsList.isEmpty()) {
            return null;
        }
        BrowseMetadataInterface registeredComponent = null;
        for (BrowseMetadataInterface deployedComponent : deployedComponentsList) {
            if (!"Registered SAS Application".equals(deployedComponent.getName())) continue;
            registeredComponent = deployedComponent;
            break;
        }
        if (null == registeredComponent) {
            return null;
        }
        List sourceConnectionsList = (List)registeredComponent.get("SourceConnections");
        if (null == sourceConnectionsList || sourceConnectionsList.isEmpty()) {
            return null;
        }
        BrowseMetadataInterface sourceConnection = (BrowseMetadataInterface)sourceConnectionsList.get(0);
        StringBuilder url = new StringBuilder(20);
        String protocol = (String)sourceConnection.get("CommunicationProtocol");
        String host = (String)sourceConnection.get("HostName");
        String port = (String)sourceConnection.get("Port");
        String servletContext = (String)sourceConnection.get("Service");
        String serviceEndpoint = deployedComponentService.getName();
        url.append(protocol).append("://");
        url.append(host).append(":").append(port);
        url.append(servletContext.startsWith("/") ? "" : "/").append(servletContext);
        url.append(serviceEndpoint.startsWith("/") ? "" : "/").append(serviceEndpoint);
        if (logger.isDebugEnabled()) {
            logger.debug("Returning url=" + url + " for service name=" + serviceName);
        }
        return url.toString();
    }
}

