/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.util;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.Root;
import com.sas.services.information.util.RB;
import com.sas.text.Message;
import java.io.Serializable;
import java.net.URLDecoder;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class OMRRepositoryKey
implements Serializable {
    private static final long serialVersionUID = 2753886020894660808L;
    private String _type;
    private String _id;
    private String _repository;

    public OMRRepositoryKey(Root root) {
        try {
            this._type = root.getCMetadataType();
            this._id = root.getFQID();
        }
        catch (RemoteException rex) {
            throw new IllegalArgumentException(rex.getMessage(), rex);
        }
        this._repository = null;
    }

    public OMRRepositoryKey(String keyString) {
        if (keyString == null) {
            throw new IllegalArgumentException();
        }
        try {
            keyString = URLDecoder.decode(keyString, "UTF-8");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        String type = null;
        int index = -1;
        index = keyString.indexOf(";");
        if (index > -1) {
            int index2 = keyString.lastIndexOf("/");
            if (index2 > -1) {
                int index3 = keyString.indexOf("reposname=");
                if (index3 > -1) {
                    this._repository = keyString.substring(index3 + 10, index2);
                    index = keyString.indexOf(59, index2);
                }
                type = keyString.substring(index2 + 1, index);
                keyString = keyString.substring(keyString.indexOf("=", index2) + 1);
            } else {
                type = keyString.substring(0, index);
                keyString = keyString.substring(index + 4);
            }
        } else {
            index = keyString.indexOf("/");
            if (index > 0) {
                type = keyString.substring(index + 1);
                keyString = keyString.substring(0, index);
            }
        }
        if (type == null) {
            throw new IllegalArgumentException(RB.getStringResource("OMRRepositoryKey.nulltype.ex.txt"));
        }
        this._type = type;
        if (keyString.length() != 17) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRRepositoryKey.invalidfqid.ex.fmt.txt", (Object)keyString));
        }
        this._id = keyString;
    }

    public String getId() {
        return this._id;
    }

    public String getType() {
        return this._type;
    }

    public String getRepository() {
        return this._repository;
    }

    public String toString() {
        if (this._repository != null) {
            return "reposname=" + this._repository + "/" + this._type + ";id=" + this._id;
        }
        return this._id + "/" + this._type;
    }
}

