/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.util;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ISEntityKey
implements Serializable {
    private static final int LENGTHOFREPOSNAMEPREFIX = 10;
    static final long serialVersionUID = 2227036494109834410L;
    private String _smartType;
    private String _protocol;
    private String _repository;
    private String _repositoryKey;

    public static boolean isValidEntityKey(String keyString) {
        if (keyString.indexOf("+") == -1) {
            return false;
        }
        return keyString.indexOf("://") != -1;
    }

    public ISEntityKey(String keyString) {
        int index1 = keyString.indexOf("+");
        if (index1 == -1) {
            throw new IllegalArgumentException();
        }
        this._smartType = keyString.substring(0, index1);
        if ((index1 = (keyString = keyString.substring(index1 + 1)).indexOf("://")) == -1) {
            throw new IllegalArgumentException();
        }
        this._protocol = keyString.substring(0, index1);
        keyString = keyString.substring(index1 + 3);
        index1 = keyString.indexOf("/");
        this._repository = keyString.substring(0, index1);
        if ("omi".equals(this._protocol)) {
            try {
                this._repository = URLDecoder.decode(this._repository, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        keyString = keyString.substring(index1 + 1);
        if ("dav".equalsIgnoreCase(this._protocol)) {
            try {
                URI url = new URI("http://server/" + keyString);
                keyString = url.getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if ("omi".equalsIgnoreCase(this._protocol)) {
            try {
                keyString = URLDecoder.decode(keyString, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this._repositoryKey = keyString;
    }

    public String getSmartType() {
        return this._smartType;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getRepository() {
        return this._repository;
    }

    public String getRepositoryKey() {
        if ("omi".equals(this._protocol)) {
            int index1 = this._repositoryKey.indexOf(47, 10);
            String reposName = this._repositoryKey.substring(10, index1);
            String encRepos = null;
            try {
                encRepos = URLEncoder.encode(reposName, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                encRepos = reposName;
            }
            return "reposname=" + encRepos + this._repositoryKey.substring(index1);
        }
        return this._repositoryKey;
    }

    public String toString() {
        return this._smartType + "+" + this._protocol + "://" + this._repository + "/" + this._repositoryKey;
    }
}

