/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.definitions.BooleanDefinition;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.ResponsibilitiesModel;
import com.sas.services.information.search.DateFilter;
import com.sas.services.information.search.ExtendedAttributesFilter;
import com.sas.services.information.search.KeywordFilter;
import com.sas.services.information.search.NotesFilter;
import com.sas.services.information.search.ObjectNameFilter;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.RB;
import com.sas.services.information.search.ResponsibilitiesFilter;
import com.sas.services.information.search.ResultDetails;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchCriteriaModel;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.SearchOperator;
import com.sas.services.information.search.SortOrder;
import com.sas.services.information.search.impl.SearchCriteriaModelImpl;
import com.sas.services.util.TransformerFactoryFactory;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SearchUtility {
    static final String ResultLimitTag = "ResultLimit";
    static final String SortOrderTag = "Order";
    static final String FolderTag = "Folder";
    static final String FilterTag = "Filter";
    static final String NameFilterTag = "ObjectNameFilter";
    static final String DateFilterTag = "DateFilter";
    static final String PublicTypeTag = "PublicTypeFilter";
    static final String ResponsibilitesTag = "ResponsibilitiesFilter";
    static final String KeywordTag = "KeywordFilter";
    static final String NotesTag = "NotesFilter";
    static final String ExtendedAttributesTag = "ExtendedAttributesFilter";

    public static SearchCriteriaModel createSearchCriteriaModel(Search searchObj) throws ServiceException, RemoteException {
        SearchCriteriaModelImpl scm = new SearchCriteriaModelImpl();
        scm.setResultLimit(searchObj.getResultDetails().getResultLimit());
        scm.setSortOrder(searchObj.getResultDetails().getSortOrder());
        scm.setFolderScope(searchObj.getFolderScope());
        scm.setRecursiveSearchFlag(searchObj.isFolderSearchRecursive());
        scm.setSearchFilters(searchObj.getFilters());
        return scm;
    }

    public static SearchCriteriaModel createSearchCriteriaModel(ServerInterface server, String xmlCriteria) throws ServiceException, RemoteException {
        Document detailsDoc = null;
        if (xmlCriteria != null && xmlCriteria.length() != 0) {
            try {
                detailsDoc = XMLUtil.convertStringToDocument(xmlCriteria);
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException(RB.getStringResource("SearchUtility.PopulateCriteria.Extract.Error.txt"));
            }
        }
        if (detailsDoc == null) {
            throw new ServiceException(RB.getStringResource("SearchUtility.PopulateCriteria.Extract.Error.txt"));
        }
        SearchCriteriaModelImpl scm = new SearchCriteriaModelImpl();
        ResultDetails.ResultLimit rLimit = ResultDetails.ResultLimit.UNLIMITED;
        NodeList nodelist = detailsDoc.getElementsByTagName(ResultLimitTag);
        if (nodelist.getLength() > 0) {
            Element limitElement = (Element)nodelist.item(0);
            String limitString = limitElement.getAttribute("Value");
            rLimit = ResultDetails.ResultLimit.getResultLimitforValue(Integer.parseInt(limitString));
        }
        scm.setResultLimit(rLimit);
        SortOrder[] order = null;
        NodeList nodelist2 = detailsDoc.getElementsByTagName(SortOrderTag);
        for (int i = 0; i < nodelist2.getLength(); ++i) {
            Element sortElement = (Element)nodelist2.item(i);
            String sortOrderValue = sortElement.getAttribute("Value");
            if (order == null) {
                order = new SortOrder[nodelist2.getLength()];
            }
            order[i] = sortOrderValue.equalsIgnoreCase(SortOrder.NAME.toString()) ? SortOrder.NAME : (sortOrderValue.equalsIgnoreCase(SortOrder.TYPE.toString()) ? SortOrder.TYPE : (sortOrderValue.equalsIgnoreCase(SortOrder.DESCRIPTION.toString()) ? SortOrder.DESCRIPTION : (sortOrderValue.equalsIgnoreCase(SortOrder.CREATED_DATE.toString()) ? SortOrder.CREATED_DATE : (sortOrderValue.equalsIgnoreCase(SortOrder.MODIFIED_DATE.toString()) ? SortOrder.MODIFIED_DATE : SortOrder.NAME))));
        }
        scm.setSortOrder(order);
        PathUrl folderPathURL = null;
        boolean recurse = true;
        NodeList nodelist3 = detailsDoc.getElementsByTagName(FolderTag);
        if (nodelist3.getLength() > 0) {
            Element folderElement = (Element)nodelist3.item(0);
            String pathValue = folderElement.getAttribute("Path");
            folderPathURL = PathUrl.newPathUrlFromAbsolutePath(server, pathValue);
            String recurseValue = folderElement.getAttribute("RecursiveSearch");
            int rintValue = Integer.parseInt(recurseValue);
            if (rintValue == 0) {
                recurse = false;
            }
        }
        scm.setFolderScope(folderPathURL);
        scm.setRecursiveSearchFlag(recurse);
        NodeList nList = detailsDoc.getElementsByTagName(FilterTag);
        try {
            List<SearchFilter> searchFilters = SearchUtility.buildFiltersListfromNodes(nList, scm);
            scm.setSearchFilters(searchFilters);
        }
        catch (PromptValueNotFoundException e1) {
            throw new ServiceException(e1);
        }
        catch (SAXException e1) {
            throw new ServiceException(e1);
        }
        catch (IOException e1) {
            throw new ServiceException(e1);
        }
        catch (ParserConfigurationException e1) {
            throw new ServiceException(e1);
        }
        return scm;
    }

    private static List<SearchFilter> buildFiltersListfromNodes(NodeList filterNodes, SearchCriteriaModelImpl scm) throws SAXException, IOException, ParserConfigurationException, PromptValueNotFoundException {
        if (filterNodes == null || filterNodes.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SearchFilter> filtersList = new ArrayList<SearchFilter>(8);
        for (int i = 0; i < filterNodes.getLength(); ++i) {
            Element filterElement = (Element)filterNodes.item(i);
            String filterName = filterElement.getAttribute("Name");
            NodeList promptNodeList = filterElement.getElementsByTagName("PromptValues");
            Element promptValuesElement = (Element)promptNodeList.item(0);
            String valuesXML = XMLUtil.convertNodeToString(promptValuesElement);
            PromptValues values = (PromptValues)SearchUtility.getObjectForXML(valuesXML);
            if (filterName.equalsIgnoreCase(NameFilterTag)) {
                String name = values.getPromptValueAsString(values.getPromptDefinition("Name", false));
                Boolean includeBooleanValue = (Boolean)values.getPromptValue(values.getPromptDefinition("IncludeDescription", false));
                boolean inclDescription = includeBooleanValue;
                boolean operatorPromptExist = values.isPromptValueAvailable(values.getPromptDefinition("SearchOperator", false));
                int searchOperator = -1;
                if (operatorPromptExist) {
                    searchOperator = values.getPromptValueAsInt(values.getPromptDefinition("SearchOperator", false));
                }
                filtersList.add(new ObjectNameFilter(name, inclDescription, SearchOperator.getSearchOperatorForValue(searchOperator)));
                continue;
            }
            if (filterName.equalsIgnoreCase(DateFilterTag)) {
                boolean isEndRelative;
                String dateTypeStr = values.getPromptValueAsString(values.getPromptDefinition("DateType", false));
                DateFilter.DateType dateType = Enum.valueOf(DateFilter.DateType.class, dateTypeStr);
                String range = values.getPromptValueAsString(values.getPromptDefinition("DateRangeLabel", false));
                DatePeriod beginDate = (DatePeriod)values.getPromptValueAsDate(values.getPromptDefinition("FromDate", false));
                DatePeriod endDate = (DatePeriod)values.getPromptValueAsDate(values.getPromptDefinition("ToDate", false));
                boolean isBeginRelative = beginDate.isRelativeDate();
                if (isBeginRelative) {
                    beginDate.setTimeZone(TimeZone.getDefault());
                }
                if (isEndRelative = endDate.isRelativeDate()) {
                    endDate.setTimeZone(TimeZone.getDefault());
                }
                DateFilter dateFilter = new DateFilter(dateType, (Date)beginDate, (Date)endDate);
                if (!range.equalsIgnoreCase("")) {
                    dateFilter.setDateRangeLabel(range);
                }
                filtersList.add(dateFilter);
                continue;
            }
            if (filterName.equalsIgnoreCase(PublicTypeTag)) {
                List typesList = values.getPromptValueAsList(values.getPromptDefinition("PublicTypes", false));
                filtersList.add(new PublicTypeFilter(typesList));
                continue;
            }
            if (filterName.equalsIgnoreCase(ResponsibilitesTag)) {
                String rpName = values.getPromptValueAsString(values.getPromptDefinition("ResponsiblePartyName", false));
                String rpRole = values.getPromptValueAsString(values.getPromptDefinition("ResponsiblePartyRole", false));
                filtersList.add(new ResponsibilitiesFilter(rpName, rpRole));
                continue;
            }
            if (filterName.equalsIgnoreCase(KeywordTag)) {
                List keywordsList = values.getPromptValueAsList(values.getPromptDefinition("Keywords", false));
                filtersList.add(new KeywordFilter(keywordsList));
                continue;
            }
            if (filterName.equalsIgnoreCase(NotesTag)) {
                List notesList = values.getPromptValueAsList(values.getPromptDefinition("Notes", false));
                filtersList.add(new NotesFilter(notesList));
                scm.setModelVersion(2);
                continue;
            }
            if (!filterName.equalsIgnoreCase(ExtendedAttributesTag)) continue;
            HashMap<String, String> attrs = new HashMap<String, String>(1);
            Map valueMap = values.getPromptValues();
            for (Map.Entry entry : valueMap.entrySet()) {
                PromptDefinitionInterface key = (PromptDefinitionInterface)entry.getKey();
                String extName = key.getPromptName();
                String value = (String)entry.getValue();
                attrs.put(extName, value);
            }
            filtersList.add(new ExtendedAttributesFilter(attrs));
            scm.setModelVersion(2);
        }
        return filtersList;
    }

    private static Object getObjectForXML(String xml, PromptsReadingContext readingContext) throws SAXException, IOException, ParserConfigurationException {
        StringReader bis = new StringReader(xml);
        PersistenceInterface obj = PromptUtil.newObjectFromXML((Reader)bis, null, (PromptsReadingContext)readingContext);
        return obj;
    }

    private static Object getObjectForXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        Log4JFactory2 loggerFactory = new Log4JFactory2();
        PromptsReadingContext readingContext = PersistenceFactory.newReadingContext((LoggerFactoryInterface)loggerFactory);
        return SearchUtility.getObjectForXML(xml, readingContext);
    }

    public static String getModelXML(SearchCriteriaModel scm) throws ServiceException, RemoteException {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<SearchDetails>");
        sb.append("<ResultLimit Value=\"" + scm.getResultLimit().getLimit() + "\"/>");
        sb.append("<SortOrder>");
        SortOrder[] order = scm.getSortOrder();
        if (order == null) {
            order = SortOrder.getDefaultOrder();
        }
        for (int i = 0; i < order.length; ++i) {
            sb.append("<Order Value=\"" + (Object)((Object)order[i]) + "\"/>");
        }
        sb.append("</SortOrder>");
        if (scm.getFolderScope() != null) {
            int recurse = 0;
            if (scm.getRecursiveSearchFlag()) {
                recurse = 1;
            }
            sb.append("<Folder Path=\"" + scm.getFolderScope().getAbsolutePath() + "\"");
            sb.append(" ");
            sb.append("RecursiveSearch=\"" + recurse + "\"");
            sb.append("/>");
        }
        sb.append("<SearchFilters>");
        List<SearchFilter> filtersList = scm.getSearchFilters();
        if (filtersList != null) {
            int len = filtersList.size();
            for (int index = 0; index < len; ++index) {
                SearchFilter sc = filtersList.get(index);
                sb.append("<Filter Name=\"" + sc.getClass().getSimpleName() + "\">");
                sb.append(SearchUtility.createPromptXML(sc, scm));
                sb.append("</Filter>");
            }
        }
        sb.append("</SearchFilters>");
        sb.append("</SearchDetails>");
        return sb.toString();
    }

    private static String createPromptXML(SearchFilter sc, SearchCriteriaModel scm) throws ServiceException {
        PromptGroup group = new PromptGroup();
        PromptValues values = null;
        String valuesXML = "";
        try {
            if (sc instanceof ObjectNameFilter) {
                ObjectNameFilter nameFilter = (ObjectNameFilter)sc;
                group.addPromptDefinition((PromptDefinitionInterface)new TextDefinition("Name"));
                group.addPromptDefinition((PromptDefinitionInterface)new BooleanDefinition("IncludeDescription"));
                group.addPromptDefinition((PromptDefinitionInterface)new IntegerDefinition("SearchOperator"));
                values = new PromptValues((PromptGroupInterface)group);
                values.setPromptValue(values.getPromptDefinition("Name", false), nameFilter.getName());
                values.setPromptValue(values.getPromptDefinition("IncludeDescription", false), (Object)nameFilter.isIncludingDescription());
                int operator = nameFilter.getSearchOperator().getFilterOperator();
                if (operator != -1) {
                    values.setPromptValue(values.getPromptDefinition("SearchOperator", false), operator);
                } else {
                    values.setPromptValue(values.getPromptDefinition("SearchOperator", false), 1);
                }
            } else if (sc instanceof DateFilter) {
                DateFilter dateFilter = (DateFilter)sc;
                group.addPromptDefinition((PromptDefinitionInterface)new TextDefinition("DateType"));
                group.addPromptDefinition((PromptDefinitionInterface)new DateDefinition("FromDate"));
                group.addPromptDefinition((PromptDefinitionInterface)new DateDefinition("ToDate"));
                group.addPromptDefinition((PromptDefinitionInterface)new TextDefinition("DateRangeLabel"));
                values = new PromptValues((PromptGroupInterface)group);
                values.setPromptValue(values.getPromptDefinition("DateType", false), dateFilter.getType().name());
                values.setPromptValue(values.getPromptDefinition("FromDate", false), (Date)dateFilter.getBeginDatePeriod());
                values.setPromptValue(values.getPromptDefinition("ToDate", false), (Date)dateFilter.getEndDatePeriod());
                String range = dateFilter.getDateRangeLabel();
                if (range != null) {
                    values.setPromptValue(values.getPromptDefinition("DateRangeLabel", false), range);
                } else {
                    values.setPromptValue(values.getPromptDefinition("DateRangeLabel", false), "");
                }
            } else if (sc instanceof PublicTypeFilter) {
                PublicTypeFilter typeFilter = (PublicTypeFilter)sc;
                TextDefinition textDef = new TextDefinition("PublicTypes");
                textDef.setMaximumValueCount(typeFilter.getTypes().size());
                group.addPromptDefinition((PromptDefinitionInterface)textDef);
                values = new PromptValues((PromptGroupInterface)group);
                values.setPromptValue(values.getPromptDefinition("PublicTypes", false), typeFilter.getTypes());
            } else if (sc instanceof ResponsibilitiesFilter) {
                ResponsibilitiesFilter rpFilter = (ResponsibilitiesFilter)sc;
                group.addPromptDefinition((PromptDefinitionInterface)new TextDefinition("ResponsiblePartyName"));
                group.addPromptDefinition((PromptDefinitionInterface)new TextDefinition("ResponsiblePartyRole"));
                values = new PromptValues((PromptGroupInterface)group);
                values.setPromptValue(values.getPromptDefinition("ResponsiblePartyName", false), rpFilter.getReponsiblePartyName());
                values.setPromptValue(values.getPromptDefinition("ResponsiblePartyRole", false), rpFilter.getReponsiblePartyRole());
            } else if (sc instanceof KeywordFilter) {
                KeywordFilter keywordFilter = (KeywordFilter)sc;
                TextDefinition textDef = new TextDefinition("Keywords");
                textDef.setMaximumValueCount(keywordFilter.getKeywords().size());
                group.addPromptDefinition((PromptDefinitionInterface)textDef);
                values = new PromptValues((PromptGroupInterface)group);
                values.setPromptValue(values.getPromptDefinition("Keywords", false), keywordFilter.getKeywords());
            } else if (sc instanceof NotesFilter) {
                NotesFilter notesFilter = (NotesFilter)sc;
                TextDefinition textDef = new TextDefinition("Notes");
                textDef.setMaximumValueCount(notesFilter.getNotes().size());
                group.addPromptDefinition((PromptDefinitionInterface)textDef);
                values = new PromptValues((PromptGroupInterface)group);
                values.setPromptValue(values.getPromptDefinition("Notes", false), notesFilter.getNotes());
                scm.setModelVersion(2);
            } else if (sc instanceof ExtendedAttributesFilter) {
                String name;
                ExtendedAttributesFilter extendedFilter = (ExtendedAttributesFilter)sc;
                Map<String, String> extensions = extendedFilter.getExtendedAttributes();
                if (extensions != null && extensions.size() > 0 && (name = extensions.keySet().iterator().next()) != null) {
                    group.addPromptDefinition((PromptDefinitionInterface)new TextDefinition(name));
                    values = new PromptValues((PromptGroupInterface)group);
                    values.setPromptValue(values.getPromptDefinition(name, false), extensions.get(name));
                }
                scm.setModelVersion(2);
            }
            valuesXML = SearchUtility.getXMLForObject(values, null, true);
        }
        catch (InvalidPromptValueException e) {
            throw new ServiceException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException(e);
        }
        catch (BackingStoreException e) {
            throw new ServiceException(e);
        }
        return valuesXML;
    }

    private static String getXMLForObject(AbstractPersistence obj, Map options, PromptsWritingContext writingContext, boolean prettyPrint) throws ParserConfigurationException, BackingStoreException {
        Document doc = SearchUtility.newDocument();
        if (options != null) {
            writingContext.setOptionsMap(options);
        }
        Element element = obj.write((Node)doc, (IntegratedWritingContext)writingContext);
        if (prettyPrint) {
            StringBuffer buffer = new StringBuffer();
            XmlUtil.serializeNode((Node)element, (StringBuffer)buffer, (boolean)true);
            return buffer.toString();
        }
        return XmlUtil.documentToString((Node)element);
    }

    private static String getXMLForObject(AbstractPersistence obj, Map options, boolean prettyPrint) throws ParserConfigurationException, BackingStoreException {
        PromptsWritingContext writingContext = PersistenceFactory.newWritingContext((PersistenceInterface)obj, null);
        return SearchUtility.getXMLForObject(obj, options, writingContext, prettyPrint);
    }

    private static final Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = TransformerFactoryFactory.newDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static ValidCriteriaResults validateSearchCriteria(Search searchObj, ServerInterface server) throws ServiceException, RemoteException {
        SearchCriteriaModel scm = SearchUtility.createSearchCriteriaModel(searchObj);
        return SearchUtility.validateSearchCriteria(scm, server);
    }

    public static ValidCriteriaResults validateSearchCriteria(SearchCriteriaModel scm, ServerInterface server) throws ServiceException, RemoteException {
        List<SearchFilter> filtersList;
        ValidCriteriaResults results = new ValidCriteriaResults();
        PathUrl folderPathUrl = scm.getFolderScope();
        if (folderPathUrl != null) {
            FolderInterface folder = null;
            folder = (FolderInterface)server.getObjectByPath(folderPathUrl);
            if (folder == null) {
                results.setValidflag(false);
                results.setFolderValid(false);
                results.setErrorMsg(Message.format((ResourceBundle)RB.getResources(), (String)"SearchUtility.BadFolderPath.Error.fmt", (Object)folderPathUrl.getDisplayPath()));
            }
        }
        if ((filtersList = scm.getSearchFilters()) != null) {
            int len = filtersList.size();
            for (int index = 0; index < len; ++index) {
                PublicTypeFilter typeFilter;
                List<String> types;
                SearchFilter sc = filtersList.get(index);
                if (sc instanceof ResponsibilitiesFilter) {
                    ResponsibilitiesFilter rpFilter = (ResponsibilitiesFilter)sc;
                    String rpName = rpFilter.getReponsiblePartyName();
                    if (rpName == null || rpName.length() == 0) continue;
                    List<String> names = ResponsibilitiesModel.getUserNames(server);
                    boolean found = false;
                    for (String username : names) {
                        if (!username.equalsIgnoreCase(rpName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    results.setValidflag(false);
                    results.setResponsibleUserValid(false);
                    results.setErrorMsg(Message.format((ResourceBundle)RB.getResources(), (String)"SearchUtility.ResponsiblePartyIdNotFound.fmt", (Object)rpName));
                    continue;
                }
                if (!(sc instanceof PublicTypeFilter) || (types = (typeFilter = (PublicTypeFilter)sc).getTypes()) == null) continue;
                boolean invalidTypes = false;
                ArrayList<String> badTypes = new ArrayList<String>();
                for (String type : types) {
                    if (server.getTypeDescriptor(type) != null) continue;
                    invalidTypes = true;
                    badTypes.add(type);
                }
                if (!invalidTypes) continue;
                results.setValidflag(false);
                results.setPublicTypesValid(false);
                results.setErrorMsg(Message.format((ResourceBundle)RB.getResources(), (String)"SearchUtility.PublicTypeNotFound.fmt", (Object)((Object)badTypes).toString()));
            }
        }
        return results;
    }

    public static class ValidCriteriaResults {
        boolean validCriteria = true;
        boolean folderValid = true;
        boolean typesValid = true;
        boolean userValid = true;
        List<String> errorMsgs = null;

        public boolean isValidCriteria() {
            return this.validCriteria;
        }

        private void setValidflag(boolean flag) {
            this.validCriteria = flag;
        }

        public List<String> getCriteriaErrorMsgs() {
            return this.errorMsgs;
        }

        private void setErrorMsg(String msg) {
            if (this.errorMsgs == null) {
                this.errorMsgs = new ArrayList<String>();
            }
            this.errorMsgs.add(msg);
        }

        public boolean isFolderValid() {
            return this.folderValid;
        }

        private void setFolderValid(boolean flag) {
            this.folderValid = flag;
        }

        public boolean isPublicTypesValid() {
            return this.typesValid;
        }

        private void setPublicTypesValid(boolean flag) {
            this.typesValid = flag;
        }

        public boolean isResponsibleUserValid() {
            return this.userValid;
        }

        private void setResponsibleUserValid(boolean flag) {
            this.userValid = flag;
        }
    }
}

