/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search;

import com.sas.services.information.FilterComponent;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.search.RB;
import com.sas.services.information.search.SearchFilter;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.List;
import java.util.ResourceBundle;

public class PublicTypeFilter
implements SearchFilter,
Serializable {
    private static final long serialVersionUID = 1175504641144166072L;
    protected static final String PUBLIC_TYPE = "PublicType";
    protected List<String> _supportedTypes = null;
    protected ServerInterface _server = null;
    protected boolean _includeSubTypes = false;

    public PublicTypeFilter(List<String> types) {
        this(types, false);
    }

    public PublicTypeFilter(List<String> types, boolean includeSubTypes) {
        this._supportedTypes = types;
        this._includeSubTypes = includeSubTypes;
    }

    public void setServer(ServerInterface server) {
        this._server = server;
    }

    public List<String> getTypes() {
        return this._supportedTypes;
    }

    public void setTypes(List<String> types) {
        this._supportedTypes = types;
    }

    public boolean isIncludeSubTypes() {
        return this._includeSubTypes;
    }

    @Override
    public String getFilterType() {
        return RB.getStringResource("PublicTypeFilter.FilterName.txt");
    }

    @Override
    public String getFilterDescription() {
        if (this._supportedTypes != null && this._supportedTypes.size() > 0) {
            return Message.format((ResourceBundle)RB.getResources(), (String)"PublicTypeFilter.FilterDesc.fmt.txt", (Object)this.getTypesToDisplay());
        }
        return null;
    }

    private String getTypesToDisplay() {
        String sep = RB.getStringResource("Common.Separator.txt");
        StringBuilder sb = new StringBuilder();
        if (this._supportedTypes != null) {
            try {
                for (String type : this._supportedTypes) {
                    TypeDescriptorInterface tdi;
                    if ("Folder".equalsIgnoreCase(type) || "RootFolder".equalsIgnoreCase(type)) continue;
                    if (sb.length() > 0) {
                        sb.append(sep);
                    }
                    String displayType = null;
                    displayType = this._server != null ? ((tdi = this._server.getTypeDescriptor(type)) == null ? type : tdi.getType()) : type;
                    sb.append(displayType);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sb.length() == 0) {
            sb.append(RB.getStringResource("Common.NoFilters.txt"));
        }
        return sb.toString();
    }

    @Override
    public FilterComponent getFilterComponent() {
        FilterComponent comp = new FilterComponent();
        comp.setAggregation(1);
        if (this._supportedTypes != null && this._supportedTypes.size() > 0) {
            int length = this._supportedTypes.size();
            for (int i = 0; i < length; ++i) {
                String type = this._supportedTypes.get(i);
                if (type == null) continue;
                if (this._includeSubTypes) {
                    int subtypeIndex = type.indexOf(46);
                    if (subtypeIndex > -1) {
                        comp.addComponent(new FilterComponent(PUBLIC_TYPE, 0, type));
                        continue;
                    }
                    FilterComponent fc = new FilterComponent();
                    fc.setAggregation(1);
                    fc.addComponent(new FilterComponent(PUBLIC_TYPE, 0, type));
                    fc.addComponent(new FilterComponent(PUBLIC_TYPE, 2, type + "."));
                    comp.addComponent(fc);
                    continue;
                }
                comp.addComponent(new FilterComponent(PUBLIC_TYPE, 0, type));
            }
        } else {
            comp.addComponent(new FilterComponent(PUBLIC_TYPE, 11, ""));
        }
        return comp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof PublicTypeFilter) {
            PublicTypeFilter filter = (PublicTypeFilter)obj;
            return this.typesEqual(this._supportedTypes, filter.getTypes());
        }
        return false;
    }

    private boolean typesEqual(List<String> types1, List<String> types2) {
        if (types1 == null && types2 == null) {
            return true;
        }
        if (types1 == null && types2 != null || types1 != null && types2 == null) {
            return false;
        }
        if (types1.size() != types2.size()) {
            return false;
        }
        try {
            int length = types1.size();
            for (int index = 0; index < length; ++index) {
                String t1 = types1.get(index);
                String t2 = types2.get(index);
                if (t1 == null || t2 == null || t1.equalsIgnoreCase(t2)) continue;
                return false;
            }
        }
        catch (Exception re) {
            return false;
        }
        return true;
    }
}

