/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search;

import com.sas.services.information.AssociationPathComponent;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.search.RB;
import com.sas.services.information.search.SearchFilter;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.List;
import java.util.ResourceBundle;

public class NotesFilter
implements SearchFilter,
Serializable {
    private static final long serialVersionUID = 8916085431653967866L;
    protected static final String DOCUMENTS_ASSOCIATION_NAME = "Documents";
    protected static final String DOCUMENTS_ASSOCIATION_TYPE = "Document";
    protected static final String NOTES_ASSOCIATION_NAME = "Notes";
    protected static final String NOTES_ASSOCIATION_TYPE = "TextStore";
    protected static final String ATTRIBUTE_STOREDTEXT = "StoredText";
    protected static final String ATTRIBUTE_PUBLICTYPE = "PublicType";
    protected static final String ATTRIBUTE_TEXTROLE = "TextRole";
    protected List<String> _notes = null;

    public NotesFilter(List<String> notes) {
        this._notes = notes;
    }

    @Override
    public String getFilterType() {
        return RB.getStringResource("NotesFilter.FilterName.txt");
    }

    @Override
    public String getFilterDescription() {
        if (this._notes != null && this._notes.size() > 0) {
            return Message.format((ResourceBundle)RB.getResources(), (String)"NotesFilter.FilterDesc.fmt.txt", (Object)this.getNotesToDisplay());
        }
        return null;
    }

    private String getNotesToDisplay() {
        String sep = RB.getStringResource("Common.Separator.txt");
        StringBuilder sb = new StringBuilder();
        if (this._notes != null) {
            for (String note : this._notes) {
                if (sb.length() > 0) {
                    sb.append(sep);
                }
                sb.append("\"").append(note).append("\"");
            }
        }
        if (sb.length() == 0) {
            sb.append(RB.getStringResource("Common.NoFilters.txt"));
        }
        return sb.toString();
    }

    public List<String> getNotes() {
        return this._notes;
    }

    @Override
    public FilterComponent getFilterComponent() {
        if (this._notes == null || this._notes.isEmpty()) {
            return null;
        }
        FilterComponent comp = new FilterComponent();
        AssociationPathComponent ac1 = new AssociationPathComponent();
        ac1.setAssociationPath(DOCUMENTS_ASSOCIATION_NAME, DOCUMENTS_ASSOCIATION_TYPE);
        ac1.setAttributeCriteria(new FilterComponent(ATTRIBUTE_PUBLICTYPE, 0, "Note"));
        AssociationPathComponent nextAssocComponent = new AssociationPathComponent();
        nextAssocComponent.setAssociationPath(NOTES_ASSOCIATION_NAME, NOTES_ASSOCIATION_TYPE);
        FilterComponent noteComp = new FilterComponent();
        noteComp.setAggregation(1);
        for (String note : this._notes) {
            noteComp.addComponent(new FilterComponent(ATTRIBUTE_STOREDTEXT, 1, note));
        }
        nextAssocComponent.setAttributeCriteria(noteComp);
        ac1.setNextAssociationPath(nextAssocComponent);
        comp.addAssociationPathComponent(ac1);
        AssociationPathComponent ac2 = new AssociationPathComponent();
        ac2.setAssociationPath(NOTES_ASSOCIATION_NAME, NOTES_ASSOCIATION_TYPE);
        FilterComponent privateNoteComp = new FilterComponent();
        ac2.setAttributeCriteria(privateNoteComp);
        privateNoteComp.setAggregation(0);
        privateNoteComp.addComponent(new FilterComponent(ATTRIBUTE_TEXTROLE, 0, "Note"));
        FilterComponent storedTextComp = new FilterComponent();
        privateNoteComp.addComponent(storedTextComp);
        storedTextComp.setAggregation(1);
        for (String note : this._notes) {
            storedTextComp.addComponent(new FilterComponent(ATTRIBUTE_STOREDTEXT, 1, note));
        }
        comp.addAssociationPathComponent(ac2, 1);
        return comp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof NotesFilter) {
            NotesFilter filter = (NotesFilter)obj;
            return this.notesEqual(this._notes, filter.getNotes());
        }
        return false;
    }

    private boolean notesEqual(List<String> notes1, List<String> notes2) {
        if (notes1 == null && notes2 == null) {
            return true;
        }
        if (notes1 == null && notes2 != null || notes1 != null && notes2 == null) {
            return false;
        }
        if (notes1.size() != notes2.size()) {
            return false;
        }
        try {
            int length = notes1.size();
            for (int index = 0; index < length; ++index) {
                String n1 = notes1.get(index);
                String n2 = notes2.get(index);
                if (n1 == null || n2 == null || n1.equalsIgnoreCase(n2)) continue;
                return false;
            }
        }
        catch (Exception re) {
            return false;
        }
        return true;
    }
}

