/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search;

import com.sas.services.information.FilterComponent;
import com.sas.services.information.search.RB;
import com.sas.services.information.search.SearchFilter;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class DateFilter
implements SearchFilter,
Serializable {
    private static final long serialVersionUID = -604933298580244936L;
    private static final DateFormat _dateFormat = DateFormat.getDateInstance(1);
    private static final DateFormat _dateTimeFormat = DateFormat.getDateTimeInstance(1, 1);
    private static final String MODIFIED_DATE = "MetadataUpdated";
    private static final String CREATED_DATE = "MetadataCreated";
    private static SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.ENGLISH);
    private String _rangeLabel;
    private DateType _type;
    private Date _beginDate;
    private Date _endDate;

    public DateFilter(DateType type, Date beginDate) {
        this(type, beginDate, null);
    }

    public DateFilter(DateType type, Date beginDate, Date endDate) {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(gmt);
        this._rangeLabel = null;
        this._type = type;
        this._beginDate = beginDate;
        this._endDate = endDate;
    }

    @Override
    public String getFilterType() {
        return RB.getStringResource("DateFilter.FilterName.txt");
    }

    @Override
    public String getFilterDescription() {
        if (this._beginDate != null && this._endDate == null) {
            return Message.format((ResourceBundle)RB.getResources(), (String)(this._type == DateType.CREATED_DATE ? "DateFilter.FilterDesc.Created1.fmt.txt" : "DateFilter.FilterDesc.Modified1.fmt.txt"), (Object)DateFilter.getFormattedDate(this._beginDate, false));
        }
        if (this._beginDate == null && this._endDate != null) {
            return Message.format((ResourceBundle)RB.getResources(), (String)(this._type == DateType.CREATED_DATE ? "DateFilter.FilterDesc.Created2.fmt.txt" : "DateFilter.FilterDesc.Modified2.fmt.txt"), (Object)DateFilter.getFormattedDate(this._endDate, false));
        }
        if (this._beginDate != null && this._endDate != null) {
            return Message.format((ResourceBundle)RB.getResources(), (String)(this._type == DateType.CREATED_DATE ? "DateFilter.FilterDesc.Created3.fmt.txt" : "DateFilter.FilterDesc.Modified3.fmt.txt"), (Object)DateFilter.getFormattedDate(this._beginDate, false), (Object)DateFilter.getFormattedDate(this._endDate, false));
        }
        return null;
    }

    public void setDateRangeLabel(String rangeLabel) {
        this._rangeLabel = rangeLabel;
    }

    public String getDateRangeLabel() {
        return this._rangeLabel;
    }

    public DateType getType() {
        return this._type;
    }

    public DatePeriod getBeginDatePeriod() {
        return this._beginDate instanceof DatePeriod ? (DatePeriod)this._beginDate : new DatePeriod(this._beginDate, DateTypes.DATE, TimeZone.getDefault(), Locale.getDefault());
    }

    public Date getBeginDate() {
        return this._beginDate instanceof DatePeriod ? ((DatePeriod)this._beginDate).getStartOfPeriod() : this._beginDate;
    }

    public DatePeriod getEndDatePeriod() {
        return this._endDate instanceof DatePeriod ? (DatePeriod)this._endDate : new DatePeriod(this._endDate, DateTypes.DATE, Locale.getDefault());
    }

    public Date getEndDate() {
        return this._endDate instanceof DatePeriod ? ((DatePeriod)this._endDate).getEndOfPeriod() : this._endDate;
    }

    private String formatDate(Date date) throws ParseException {
        if (date == null) {
            return null;
        }
        return sdf.format(date);
    }

    private String getDateAttribute() {
        if (this._type == DateType.CREATED_DATE) {
            return CREATED_DATE;
        }
        return MODIFIED_DATE;
    }

    @Override
    public FilterComponent getFilterComponent() {
        FilterComponent comp = new FilterComponent();
        comp.setAggregation(0);
        String date1 = null;
        String date2 = null;
        try {
            date1 = this.formatDate(this.getBeginDate());
            date2 = this.formatDate(this.getEndDate());
        }
        catch (ParseException e) {
            return comp;
        }
        if (date1 != null) {
            comp.addComponent(new FilterComponent(this.getDateAttribute(), 8, date1));
        }
        if (date2 != null) {
            comp.addComponent(new FilterComponent(this.getDateAttribute(), 6, date2));
        }
        return comp;
    }

    public boolean equals(Object obj) {
        DateFilter filter;
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof DateFilter && this._type == (filter = (DateFilter)obj).getType()) {
            Date begin1 = this.getBeginDate();
            Date end1 = this.getEndDate();
            Date begin2 = filter.getBeginDate();
            Date end2 = filter.getEndDate();
            if ((begin1 == null && begin2 == null || begin1 != null && begin1.equals(begin2)) && (end1 == null && end2 == null || end1 != null && end1.equals(end2))) {
                return true;
            }
        }
        return false;
    }

    private static String getFormattedDate(Date date, boolean includeTime) {
        return includeTime ? _dateTimeFormat.format(date) : _dateFormat.format(date);
    }

    public static enum DateType {
        CREATED_DATE,
        MODIFIED_DATE;

    }
}

