/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.sasfolders;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.PropertySetInterface;
import com.sas.services.information.metadata.VirtualFolderInterface;
import com.sas.services.information.metadata.VirtualFolderManager;
import com.sas.services.information.publicobject.BaseDetailsProcessor;
import com.sas.services.information.publicobject.BasePublicObject;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.AbstractFolderModel2;
import com.sas.services.information.sasfolders.AbstractPublicObjectNode;
import com.sas.services.information.sasfolders.ContainerNode;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderNode;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.MemberNode;
import com.sas.services.information.sasfolders.ModelConfiguration;
import com.sas.services.information.sasfolders.ModelDisplayMode;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.RB;
import com.sas.services.information.sasfolders.RootFolderNode;
import com.sas.services.information.sasfolders.SASFoldersModelInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.information.sasfolders.UserHomeFolderNotFoundException;
import com.sas.services.information.sasfolders.UsersFolderNode;
import com.sas.services.information.sasfolders.VirtualFolderNode;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.ResultDetails;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.impl.SearchImpl;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;

public class SASFoldersModel
extends AbstractFolderModel2
implements SASFoldersModelInterface {
    private static final String LOGGING_CONTEXT = "com.sas.services.information.sasfolders";
    private static final String PROPERTY_METADATA_SETTINGS = "Metadata Repository Policies";
    private static final String PROPERTY_USER_FOLDERS_PATH = "Path to Users Root Folder";
    protected FolderSearchManager _searchManager = null;
    protected List<SearchFilter> _filterList = null;
    private boolean _filtersChanged = false;
    private static String userFolderPath = null;
    private static Map<String, Boolean> _containerTypeCache = new HashMap<String, Boolean>(30);

    public SASFoldersModel(ServerInterface server) throws ServiceException, RemoteException {
        super(server);
    }

    @Override
    public List<SearchFilter> getSearchFilters() {
        return this._filterList;
    }

    @Override
    public void setSearchFilters(List<SearchFilter> filters) {
        this._filterList = filters;
        this.processFilterChange();
    }

    @Override
    public void addSearchFilter(SearchFilter filter) {
        if (this._filterList == null) {
            this._filterList = new ArrayList<SearchFilter>(3);
        }
        this._filterList.add(filter);
        this.processFilterChange();
    }

    @Override
    public void removeSearchFilter(SearchFilter filter) {
        if (this._filterList != null && this._filterList.contains(filter)) {
            this._filterList.remove(filter);
        }
        this.processFilterChange();
    }

    private void processFilterChange() {
        if (this._searchManager != null) {
            this._filtersChanged = true;
        }
    }

    @Override
    public PublicObjectNodeInterface getObjectByPath(String path) throws ServiceException, RemoteException {
        PathUrl pathUrl = PathUrl.newPathUrlFromAbsolutePath(this._server, path);
        if (pathUrl.getType() == null) {
            pathUrl.setType("Folder");
        }
        return this.getObjectByPath(pathUrl);
    }

    @Override
    public PublicObjectNodeInterface getObjectByPath(PathUrl path) throws ServiceException, RemoteException {
        PublicObjectNodeInterface node;
        ModelConfiguration config = this.getConfiguration();
        if (config != null && !config.isBypassingCache() && (node = (PublicObjectNodeInterface)SASFoldersUtil.findNodeByPath(path, this)) != null) {
            return node;
        }
        MetadataInterface meta = this._server.getObjectByPath(path);
        if (meta != null && meta.getTypeDescriptor() != null) {
            return this.getObject(meta);
        }
        return null;
    }

    @Override
    public PublicObjectNodeInterface getObject(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        if (publicObject == null) {
            throw new IllegalArgumentException(RB.getStringResource("SASFoldersModel.InvalidType.txt"));
        }
        PathUrl path = publicObject.getPathUrl();
        if (path != null) {
            return this.getObjectByPath(path);
        }
        return null;
    }

    @Override
    public PublicObjectNodeInterface getObject(String id, String publicType) throws ServiceException, RemoteException {
        FolderNodeInterface rootFolder;
        if (id == null || publicType == null) {
            return null;
        }
        if ("RootFolder".equalsIgnoreCase(publicType) && (rootFolder = this.getRootFolder()).getIdentifier().equalsIgnoreCase(id)) {
            return rootFolder;
        }
        TypeDescriptorInterface type = this._server.getTypeDescriptor(publicType);
        if (type == null) {
            throw new ServiceException(RB.getStringResource("SASFoldersModel.InvalidType.txt"));
        }
        String key = SASFoldersUtil.getISEntityKey(id, type);
        MetadataInterface meta = this._server.fetch(key, true);
        if (meta != null) {
            ModelConfiguration config = this.getConfiguration();
            if (config != null && config.isBypassingCache()) {
                return this.getObject(meta);
            }
            PathUrl path = meta.getPathUrl();
            if (path != null) {
                return this.getObjectByPath(path);
            }
        }
        return null;
    }

    private PublicObjectNodeInterface getObject(MetadataInterface smartObject) throws ServiceException, RemoteException {
        FolderNodeInterface rootFolder;
        TypeDescriptorInterface type = smartObject.getTypeDescriptor();
        if (type == null) {
            throw new ServiceException(RB.getStringResource("SASFoldersModel.InvalidType.txt"));
        }
        if ("RootFolder".equalsIgnoreCase(type.getTypeName()) && (rootFolder = this.getRootFolder()).getIdentifier().equalsIgnoreCase(smartObject.getIdentifier())) {
            return rootFolder;
        }
        if (SASFoldersUtil.isContainedByFolder(smartObject)) {
            return this.getObjectNode(smartObject.getIdentifier(), type);
        }
        return this.getObjectNode(smartObject);
    }

    protected PublicObjectNodeInterface getObjectNode(String id, TypeDescriptorInterface type) throws ServiceException, RemoteException {
        String key = SASFoldersUtil.getISEntityKey(id, type);
        BrowseMetadataInterface browse = this._server.browseFetch(key, FETCH_OBJECT_FILTER);
        PublicObjectNodeInterface node = this.createNode(browse);
        this.createParentStructure(node, browse);
        return node;
    }

    protected PublicObjectNodeInterface getObjectNode(MetadataInterface smartObject) throws ServiceException, RemoteException {
        PublicObjectNodeInterface node = this.createNode(smartObject);
        this.createParentStructure(node, smartObject);
        return node;
    }

    private void createParentStructure(PublicObjectNodeInterface node, PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        if (node.getContainer() == null) {
            PublicObjectContainerInterface[] containers = SASFoldersUtil.getContainerPath(publicObject);
            ContainerNodeInterface parentNode = this.getRootFolder();
            for (int index = 0; index < containers.length; ++index) {
                PublicObjectContainerInterface container = containers[index];
                TypeDescriptorInterface type = container.getTypeDescriptor();
                if (type == null) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SASFoldersModel.InvalidContainerPublicType.fmt.txt", (Object)container.getName(), null));
                }
                if (index == 0 && "RootFolder".equals(type.getTypeName())) continue;
                PublicObjectNodeInterface po = SASFoldersUtil.findChildNode(parentNode, container.getName(), type.getTypeName(), false);
                if (po != null && po instanceof ContainerNodeInterface) {
                    parentNode = (ContainerNodeInterface)po;
                    continue;
                }
                po = this.createNode(container);
                parentNode.addChild(po);
                if (po instanceof ContainerNodeInterface) {
                    parentNode = (ContainerNodeInterface)po;
                    continue;
                }
                return;
            }
            parentNode.addChild(node);
        }
    }

    private void createParentStructure(PublicObjectNodeInterface node, BrowseMetadataInterface browse) throws ServiceException, RemoteException {
        if (node.getContainer() == null) {
            ArrayList<BrowseMetadataInterface> parentList = new ArrayList<BrowseMetadataInterface>(6);
            List parents = browse.getParents();
            while (parents != null && !parents.isEmpty()) {
                BrowseMetadataInterface parentBrowse = (BrowseMetadataInterface)parents.get(0);
                parentList.add(parentBrowse);
                parents = parentBrowse.getParents();
            }
            Collections.reverse(parentList);
            ContainerNodeInterface parentNode = this.getRootFolder();
            for (BrowseMetadataInterface browseObj : parentList) {
                String publicType = (String)browseObj.getRawData().get("PublicType");
                TypeDescriptorInterface type = this._server.getTypeDescriptor(publicType);
                if (type == null) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SASFoldersModel.InvalidContainerPublicType.fmt.txt", (Object)browseObj.getName(), (Object)publicType));
                }
                PublicObjectNodeInterface po = SASFoldersUtil.findChildNode(parentNode, browseObj.getName(), type.getTypeName(), false);
                if (po != null && po instanceof ContainerNodeInterface) {
                    parentNode = (ContainerNodeInterface)po;
                    continue;
                }
                po = this.createNode(browseObj);
                parentNode.addChild(po);
                if (po instanceof ContainerNodeInterface) {
                    parentNode = (ContainerNodeInterface)po;
                    continue;
                }
                return;
            }
            parentNode.addChild(node);
        }
    }

    public void removeNodeFromParent(PublicObjectNodeInterface node) throws ServiceException, RemoteException {
        if (node == null || node instanceof RootFolderNode) {
            return;
        }
        ContainerNodeInterface parent = (ContainerNodeInterface)node.getContainer();
        if (parent == null) {
            return;
        }
        parent.removeChild(node);
        if (node instanceof ContainerNodeInterface) {
            this.removeChildren((ContainerNodeInterface)node);
        }
    }

    private void removeChildren(ContainerNodeInterface node) throws ServiceException, RemoteException {
        PublicObjectNodeInterface[] children;
        if (!node.isPopulated()) {
            return;
        }
        for (PublicObjectNodeInterface child : children = node.getChildren().toArray(new PublicObjectNodeInterface[0])) {
            node.removeChild(child);
            if (!(child instanceof ContainerNodeInterface)) continue;
            this.removeChildren((ContainerNodeInterface)child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateContainer(ContainerNodeInterface container) throws ServiceException, RemoteException {
        if (container instanceof FolderNodeInterface) {
            this.populateFolder((FolderNodeInterface)container);
        } else {
            TypeDescriptorInterface type = container.getTypeDescriptor();
            if (type != null) {
                ServerInterface childServer = this.createNewTransaction();
                try {
                    MetadataInterface smartObject = SASFoldersUtil.getSmartObject(childServer, container);
                    if (smartObject != null && smartObject instanceof PublicObjectContainerInterface) {
                        List childList;
                        if (this.isLoggingEnabled(Level.DEBUG, LOGGING_CONTEXT)) {
                            this.logMessage(Level.DEBUG, "Populating container \"" + container + "\"", LOGGING_CONTEXT);
                        }
                        if ((childList = ((PublicObjectContainerInterface)((Object)smartObject)).getChildren()) != null && childList.size() > 0) {
                            ArrayList<PublicObjectInterface> children = new ArrayList<PublicObjectInterface>(childList);
                            this.populateContainerNode(container, children);
                        }
                    }
                }
                finally {
                    if (childServer != null) {
                        childServer.destroy();
                    }
                }
            }
        }
    }

    private void populateVirtualFolder(VirtualFolderNodeInterface folderNode) throws ServiceException, RemoteException {
        VirtualFolderInterface folder;
        if (this.isLoggingEnabled(Level.DEBUG, LOGGING_CONTEXT)) {
            this.logMessage(Level.DEBUG, "Populating virtual folder \"" + folderNode + "\"", LOGGING_CONTEXT);
        }
        if ((folder = folderNode.getVirtualFolder()) != null) {
            folderNode.setPopulated(true);
            folder.refresh();
            List children = folder.getChildren();
            if (children != null && !children.isEmpty()) {
                for (PublicObjectInterface child : children) {
                    PublicObjectNodeInterface childNode = null;
                    childNode = child instanceof VirtualFolderInterface ? this.createVirtualFolderNode((VirtualFolderInterface)child) : this.createNode(child);
                    if (childNode == null) continue;
                    this.addChildNode(folderNode, childNode);
                }
            }
        }
    }

    private ServerInterface createNewTransaction() throws ServiceException, RemoteException {
        if (this.isLoggingEnabled(Level.DEBUG, LOGGING_CONTEXT)) {
            this.logMessage(Level.DEBUG, "Starting new detached transaction", LOGGING_CONTEXT);
        }
        ChildServerInterface childServer = this._server.newChild(true);
        return childServer;
    }

    private void initializeFolderSearch() throws ServiceException, RemoteException {
        if (this._searchManager == null) {
            this._searchManager = new FolderSearchManager(this);
            this._searchManager.getResultDetails().setResultLimit(ResultDetails.ResultLimit.UNLIMITED);
        } else if (this._filtersChanged) {
            if (VirtualFolderManager.instanceCreated(this._server)) {
                VirtualFolderManager vm = VirtualFolderManager.getInstance(this._server);
                vm.reset();
            }
            this._filtersChanged = false;
        }
    }

    @Override
    public void populateFolders() throws ServiceException, RemoteException {
        this.initializeFolderSearch();
        FolderNodeInterface root = this.getRootFolder();
        this.populateRootFolder(root, true);
    }

    private void populateRootFolder(FolderNodeInterface rootFolder, boolean recursive) throws ServiceException, RemoteException {
        block8: {
            if (this._config.isDisplayingUsersHomeFolder()) {
                try {
                    UsersFolderNode myFolder = new UsersFolderNode(UserFolderType.MYFOLDER, this._server);
                    myFolder.setFolderModel(this);
                    rootFolder.insertChild(myFolder, 0);
                }
                catch (UserHomeFolderNotFoundException e) {
                    if (this.isLoggingEnabled(Level.DEBUG, LOGGING_CONTEXT)) {
                        this.logMessage(Level.DEBUG, "Unable to retrieve user's My Folder. " + e.getMessage(), LOGGING_CONTEXT);
                    }
                }
                catch (ServiceException e) {
                    if (!this.isLoggingEnabled(Level.DEBUG, LOGGING_CONTEXT)) break block8;
                    this.logMessage(Level.DEBUG, "Unable to create My Folder shortcut for current identity. " + e.getMessage(), LOGGING_CONTEXT);
                }
            }
        }
        List<BrowseMetadataInterface> children = this._searchManager.getFolderContents(rootFolder, this._filterList);
        this.populateFolderNode(rootFolder, children, false);
        if (recursive) {
            List<PublicObjectNodeInterface> topLevelFolders = rootFolder.getChildren();
            for (PublicObjectNodeInterface folder : topLevelFolders) {
                if (!(folder instanceof FolderNodeInterface)) continue;
                this.populateFolder((FolderNodeInterface)folder, true);
            }
            if (!this._config.isDisplayingEmptyFolders()) {
                this.pruneChildNodes();
            }
        }
    }

    @Override
    public void populateFolder(FolderNodeInterface folder) throws ServiceException, RemoteException {
        this.populateFolder(folder, false);
    }

    @Override
    public void populateFolder(FolderNodeInterface folder, boolean recursive) throws ServiceException, RemoteException {
        this.initializeFolderSearch();
        if (this.isRootFolder(folder)) {
            this.populateRootFolder(folder, recursive);
        } else if (folder instanceof VirtualFolderNodeInterface) {
            this.populateVirtualFolder((VirtualFolderNodeInterface)folder);
            if (!this._config.isDisplayingEmptyFolders() && recursive) {
                this.pruneChildNodes(folder);
            }
        } else {
            List<BrowseMetadataInterface> children = null;
            if (!this._server.getUserContext().isInGroup("SASAdministrators") && folder.getDisplayPath().equals(this.getUserFoldersPath())) {
                FolderInterface homeFolder = this._server.getHomeFolder(null, UserFolderType.HOMEFOLDER, null);
                if (homeFolder != null) {
                    children = new ArrayList<BrowseMetadataInterface>();
                    String treeTemplate = "<Templates>\r\n    <Template TemplateName=\"Tree\">\r\n        <Tree Name=\"\" PublicType=\"\" UsageVersion=\"\" TreeType=\"\" Desc=\"\" MetadataCreated=\"\" MetadataUpdated=\"\" >\r\n            <Members Search=\"*\"/>\r\n            <Keywords/>\r\n            <ResponsibleParties/>\r\n        </Tree>\r\n        <Keyword Name=\"\"/>\r\n        <ResponsibleParty Name=\"\" Role=\"\">  \r\n            <Persons/>\r\n        </ResponsibleParty>\r\n        <Person Name=\"\" DisplayName=\"\" />\r\n        <Root Name=\"\" DisplayName=\"\" PublicType=\"\" UsageVersion=\"\" Desc=\"\" MetadataCreated=\"\" MetadataUpdated=\"\" >\r\n            <Keywords/>\r\n            <ResponsibleParties/>\r\n        </Root>\r\n    </Template>\r\n</Templates>";
                    Filter filter = new Filter();
                    filter.setOMRTemplate(treeTemplate);
                    children.add(this._server.browseFetch(homeFolder.getEntityKey(), filter));
                }
            } else {
                children = this._searchManager.getFolderContents(folder, this._filterList, recursive);
            }
            this.populateFolderNode(folder, children, recursive);
            if (!this._config.isDisplayingEmptyFolders() && recursive) {
                this.pruneChildNodes(folder);
            }
        }
    }

    private void populateFolderNode(FolderNodeInterface folder, List<BrowseMetadataInterface> children, boolean recursive) throws ServiceException, RemoteException {
        folder.setPopulated(true);
        if (children != null && !children.isEmpty()) {
            for (BrowseMetadataInterface child : children) {
                PublicObjectNodeInterface childNode = this.createNode(child);
                if (!this._config.isDisplayingSystemFolders() && childNode instanceof FolderNodeInterface && "System".equalsIgnoreCase(((FolderNodeInterface)childNode).getFolderType())) continue;
                this.addChildNode(folder, childNode);
                if (!recursive || !child.isAFolder()) continue;
                List subFolders = child.getSubfolders();
                List members = child.getMembers();
                ArrayList<BrowseMetadataInterface> childList = new ArrayList<BrowseMetadataInterface>(subFolders.size() + members.size());
                childList.addAll(subFolders);
                childList.addAll(members);
                this.populateFolderNode((FolderNodeInterface)childNode, childList, recursive);
            }
        }
        if (this._config.isDisplayingSystemFolders() && SASFoldersUtil.isSystemFolder(folder)) {
            this.populateSystemFolderNode(folder);
        }
    }

    private void populateSystemFolderNode(FolderNodeInterface folder) throws ServiceException, RemoteException {
        FolderInterface systemFolder;
        if (this.isLoggingEnabled(Level.DEBUG, LOGGING_CONTEXT)) {
            this.logMessage(Level.DEBUG, "Populating contents of System folder", LOGGING_CONTEXT);
        }
        if ((systemFolder = (FolderInterface)SASFoldersUtil.getSmartObject(this._server, folder)) != null) {
            List allSubFolders = systemFolder.getSubfolders();
            for (FolderInterface childFolder : allSubFolders) {
                PublicObjectNodeInterface childNode;
                if (!(childFolder instanceof VirtualFolderInterface)) continue;
                if (this.isLoggingEnabled(Level.DEBUG, LOGGING_CONTEXT)) {
                    this.logMessage(Level.DEBUG, "Creating virtual folder \"" + childFolder.getName() + "\"", LOGGING_CONTEXT);
                }
                if ((childNode = this.createVirtualFolderNode((VirtualFolderInterface)childFolder)) == null) continue;
                this.addChildNode(folder, childNode);
            }
        }
    }

    private boolean isRootFolder(FolderNodeInterface folder) throws ServiceException, RemoteException {
        return this.getRootFolder().equals(folder);
    }

    private void populateContainerNode(ContainerNodeInterface container, List<PublicObjectInterface> children) throws ServiceException, RemoteException {
        container.setPopulated(true);
        if (children != null && !children.isEmpty()) {
            for (PublicObjectInterface child : children) {
                PublicObjectNodeInterface childNode = this.createNode(child);
                this.addChildNode(container, childNode);
            }
        }
    }

    protected void addChildNode(ContainerNodeInterface parentNode, PublicObjectNodeInterface childNode) throws ServiceException, RemoteException {
        if (childNode == null) {
            return;
        }
        if (!this.isValidNode(childNode, parentNode)) {
            return;
        }
        if (childNode.getTypeDescriptor() == null && !this._config.isDisplayingUnknownObjects()) {
            return;
        }
        FolderNodeInterface rootFolder = this.getRootFolder();
        if (childNode == rootFolder && parentNode != rootFolder) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SASFoldersModel.AddingRootNode.fmt.txt", (Object)parentNode.getDisplayPath()));
        }
        int index = this.getChildPosition(parentNode, childNode);
        parentNode.insertChild(childNode, index);
    }

    protected boolean isValidNode(PublicObjectNodeInterface node, ContainerNodeInterface parentNode) throws ServiceException, RemoteException {
        if (this._nodeFilters != null) {
            int length = this._nodeFilters.length;
            for (int i = 0; i < length; ++i) {
                if (this._nodeFilters[i].accept(node, parentNode)) continue;
                return false;
            }
        }
        return true;
    }

    protected PublicObjectNodeInterface createNode(BrowseMetadataInterface meta) throws ServiceException, RemoteException {
        String publicType;
        TypeDescriptorInterface type;
        AbstractPublicObjectNode node = null;
        node = meta.isAFolder() ? new FolderNode(meta) : (this.isContainerType(type = this._server.getTypeDescriptor(publicType = (String)meta.getRawData().get("PublicType")), meta.getReposId()) ? new ContainerNode(meta) : new MemberNode(meta));
        node.setFolderModel(this);
        ModelConfiguration config = this.getConfiguration();
        if (config != null && config.isIncludingEmptyValues()) {
            Map internalData = meta.getRawData();
            if (config.getObjectDetails().isKeywordsIncluded() && !internalData.containsKey("Keywords")) {
                internalData.put("Keywords", Collections.EMPTY_LIST);
            }
            if (config.getObjectDetails().isResponsiblePartiesIncluded() && !internalData.containsKey("ResponsibleParties")) {
                internalData.put("ResponsibleParties", Collections.EMPTY_LIST);
            }
        }
        return node;
    }

    protected PublicObjectNodeInterface createNode(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        BrowseMetadataInterface browse;
        if (publicObject instanceof VirtualFolderInterface) {
            PathUrl path = ((VirtualFolderInterface)publicObject).getPathUrl();
            return (PublicObjectNodeInterface)SASFoldersUtil.findNodeByPath(path, this);
        }
        AbstractPublicObjectNode node = null;
        String id = publicObject.getIdentifier();
        TypeDescriptorInterface type = publicObject.getTypeDescriptor();
        if (type == null) {
            if (this.isLoggingEnabled(Level.DEBUG, LOGGING_CONTEXT)) {
                this.logMessage(Level.DEBUG, "A non public object (" + publicObject.getName() + ") cannot be added to its parent.", LOGGING_CONTEXT);
            }
            return null;
        }
        if (SASFoldersUtil.isRootFolder(publicObject)) {
            return this.getRootFolder();
        }
        node = SASFoldersUtil.isFolder(publicObject) ? new FolderNode(publicObject.getIdentifier(), publicObject.getName(), type) : (this.isContainerType(type, id) ? new ContainerNode(id, publicObject.getName(), type) : new MemberNode(id, publicObject.getName(), type));
        node.setFolderModel(this);
        if (publicObject instanceof MetadataInterface) {
            BaseDetailsProcessor details = new BaseDetailsProcessor(node);
            node.addProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface", details);
            MetadataInterface mi = (MetadataInterface)publicObject;
            DetailsProcessorInterface miDetails = (DetailsProcessorInterface)mi.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
            if (miDetails != null) {
                details.setDescription(miDetails.getDescription());
                details.setCreateDate(miDetails.getCreateDate());
                details.setModifyDate(miDetails.getModifyDate());
                details.setDisplayName(miDetails.getDisplayName());
            }
        } else if (publicObject instanceof BasePublicObject && (browse = ((BasePublicObject)publicObject).getBrowseObject()) != null) {
            node.setBrowseObject(browse);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isContainerType(TypeDescriptorInterface type, String objectID) throws ServiceException, RemoteException {
        if (type == null) {
            return false;
        }
        String typeName = type.getTypeName();
        if (_containerTypeCache.containsKey(typeName)) {
            return _containerTypeCache.get(typeName);
        }
        boolean returnValue = false;
        if (type.allowsChildren()) {
            ServerInterface childServer = this.createNewTransaction();
            try {
                MetadataInterface mi = SASFoldersUtil.getSmartObject(this._server, objectID, type.getMetadataType());
                if (mi instanceof PublicObjectContainerInterface) {
                    returnValue = true;
                }
            }
            finally {
                if (childServer != null) {
                    childServer.destroy();
                }
            }
        }
        _containerTypeCache.put(typeName, returnValue);
        return returnValue;
    }

    protected PublicObjectNodeInterface createVirtualFolderNode(VirtualFolderInterface virtualFolder) throws ServiceException, RemoteException {
        VirtualFolderNode node = new VirtualFolderNode(virtualFolder);
        node.setFolderModel(this);
        this.mergeVirtualFolderFilters(virtualFolder);
        return node;
    }

    private void mergeVirtualFolderFilters(VirtualFolderInterface folder) throws ServiceException, RemoteException {
        Search folderSM = folder.getSearchManager();
        if (this._filterList == null || this._filterList.isEmpty() || folderSM == null) {
            return;
        }
        List<SearchFilter> filters = folderSM.getFilters();
        ArrayList<SearchFilter> virtualFolderFilters = new ArrayList<SearchFilter>(filters);
        ArrayList<SearchFilter> mergedFilters = new ArrayList<SearchFilter>();
        for (SearchFilter defaultFilter : this._filterList) {
            boolean found = false;
            SearchFilter[] filterArray = filters.toArray(new SearchFilter[filters.size()]);
            for (int filterIndex = 0; filterIndex < filterArray.length; ++filterIndex) {
                SearchFilter virtualFolderFilter = filterArray[filterIndex];
                if (!defaultFilter.getClass().equals(virtualFolderFilter.getClass())) continue;
                found = true;
                if (virtualFolderFilter instanceof PublicTypeFilter && defaultFilter instanceof PublicTypeFilter) {
                    List<String> types = ((PublicTypeFilter)virtualFolderFilter).getTypes();
                    if (types != null) {
                        types = new ArrayList<String>(types);
                        List<String> defaultTypes = ((PublicTypeFilter)defaultFilter).getTypes();
                        Object[] typeArray = types.toArray();
                        for (int index = 0; index < typeArray.length; ++index) {
                            String type = (String)typeArray[index];
                            if (defaultTypes.contains(type)) continue;
                            types.remove(type);
                        }
                        if (types.isEmpty()) {
                            folderSM.removeFilter(virtualFolderFilter);
                            return;
                        }
                        mergedFilters.add(new PublicTypeFilter(types));
                    }
                } else {
                    mergedFilters.add(defaultFilter);
                }
                virtualFolderFilters.remove(virtualFolderFilter);
                break;
            }
            if (found) continue;
            mergedFilters.add(defaultFilter);
        }
        if (!virtualFolderFilters.isEmpty()) {
            mergedFilters.addAll(virtualFolderFilters);
        }
        for (SearchFilter sf : mergedFilters) {
            folderSM.addFilter(sf);
        }
    }

    protected int getChildPosition(ContainerNodeInterface parent, PublicObjectNodeInterface newNode) throws ServiceException, RemoteException {
        PublicObjectNodeInterface childNode;
        int position = 0;
        int index = 0;
        int childCount = parent.getChildCount();
        if (parent instanceof RootFolderNode && index < childCount) {
            childNode = parent.getChildAt(index);
            while (childNode instanceof UsersFolderNode && ++index < childCount) {
                childNode = parent.getChildAt(index);
            }
        }
        while (index < childCount) {
            position = (index + childCount) / 2;
            childNode = parent.getChildAt(position);
            int result = this._sortingComparator.compare(childNode, newNode);
            if (result > 0) {
                childCount = position;
                continue;
            }
            if (result > 0) continue;
            index = position + 1;
        }
        position = index;
        return position;
    }

    protected void pruneChildNodes() throws ServiceException, RemoteException {
        FolderNodeInterface node = this.getRootFolder();
        this.pruneChildNodes(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pruneChildNodes(FolderNodeInterface node) throws ServiceException, RemoteException {
        long refreshValue = this._config.getFolderRefreshValue();
        try {
            this._config.setFolderRefreshValue(-1L);
            ArrayList<PublicObjectNodeInterface> children = new ArrayList<PublicObjectNodeInterface>(node.getChildren());
            for (PublicObjectInterface publicObjectInterface : children) {
                if (!(publicObjectInterface instanceof FolderNodeInterface)) continue;
                FolderNodeInterface childNode = (FolderNodeInterface)publicObjectInterface;
                this.pruneChildren(childNode);
            }
        }
        finally {
            this._config.setFolderRefreshValue(refreshValue);
        }
    }

    private void pruneChildren(FolderNodeInterface folder) throws ServiceException, RemoteException {
        PublicObjectContainerInterface parent;
        ArrayList<PublicObjectNodeInterface> children = new ArrayList<PublicObjectNodeInterface>(folder.getChildren());
        for (PublicObjectInterface publicObjectInterface : children) {
            if (!(publicObjectInterface instanceof FolderNodeInterface)) continue;
            FolderNodeInterface childNode = (FolderNodeInterface)publicObjectInterface;
            this.pruneChildren(childNode);
        }
        if (!this._config.isDisplayingEmptyFolders() && folder.getChildCount() == 0 && (parent = folder.getContainer()) instanceof FolderNodeInterface) {
            ((FolderNodeInterface)parent).removeChild(folder);
        }
    }

    private boolean isValidPublicType(PublicObjectInterface object) throws ServiceException, RemoteException {
        return object.getTypeDescriptor() != null;
    }

    protected String getUserFoldersPath() throws ServiceException, RemoteException {
        if (userFolderPath != null) {
            return userFolderPath;
        }
        String result = "User Folders";
        String template = "<Templates><PropertySet Name=\"\" PropertySetName=\"\"><SetProperties/></PropertySet><Property PropertyName=\"\" DefaultValue=\"\"/></Templates>";
        Filter filter = new Filter("Name", 0, PROPERTY_METADATA_SETTINGS);
        filter.setType("PropertySet");
        filter.setOMRTemplate(template);
        List propertySets = this._server.search(filter);
        if (propertySets != null && !propertySets.isEmpty()) {
            PropertySetInterface ps = (PropertySetInterface)propertySets.get(0);
            List properties = ps.getSetProperties();
            for (PropertyInterface property : properties) {
                if (!PROPERTY_USER_FOLDERS_PATH.equals(property.getKey())) continue;
                result = property.getValue();
                break;
            }
        }
        userFolderPath = result;
        return result;
    }

    static {
        _containerTypeCache.put("Folder", Boolean.TRUE);
    }

    @SASScope
    protected class FolderSearchManager
    extends SearchImpl {
        static final String SYSTEM_FOLDER_TYPE = "System";
        private static final String METADATA_ID = "Id";
        private SASFoldersModelInterface _model;

        public FolderSearchManager(SASFoldersModelInterface model) throws ServiceException, RemoteException {
            super(model.getServer());
            this._model = model;
            this.setIncludeUnknownPublicTypes(true);
            this.setIncludeNonSearchablePublicTypes(true);
        }

        @Override
        public ResultDetails getResultDetails() {
            ModelConfiguration config = SASFoldersModel.this.getConfiguration();
            return config.getObjectDetails();
        }

        public List<BrowseMetadataInterface> getFolderContents(FolderNodeInterface folder, List<SearchFilter> criteriaList) throws ServiceException, RemoteException {
            return this.getFolderContents(folder, criteriaList, false);
        }

        public List<BrowseMetadataInterface> getFolderContents(FolderNodeInterface folder, List<SearchFilter> criteriaList, boolean recursive) throws ServiceException, RemoteException {
            if (SASFoldersModel.this.isLoggingEnabled(Level.DEBUG, SASFoldersModel.LOGGING_CONTEXT)) {
                SASFoldersModel.this.logMessage(Level.DEBUG, "Retrieving folder contents for: " + folder, SASFoldersModel.LOGGING_CONTEXT);
            }
            ArrayList<BrowseMetadataInterface> children = new ArrayList<BrowseMetadataInterface>();
            if (!SASFoldersModel.this.isValidPublicType(folder)) {
                return children;
            }
            String folderKey = SASFoldersUtil.getISEntityKey(folder);
            if (folder == SASFoldersModel.this.getRootFolder()) {
                FilterInterface filter = this.createRootFolderSearchFilter(this._model.getSearchFilters());
                BrowseMetadataInterface browseRoot = this._server.browseFolder(folderKey, filter);
                if (SASFoldersModel.this._config.isDisplayingSystemFolders()) {
                    children.addAll((List)browseRoot.get("SoftwareTrees"));
                } else {
                    List topLevelFolders = (List)browseRoot.get("SoftwareTrees");
                    for (BrowseMetadataInterface topLevelFolder : topLevelFolders) {
                        String treeType = (String)topLevelFolder.getRawData().get("TreeType");
                        if (SYSTEM_FOLDER_TYPE.equalsIgnoreCase(treeType)) continue;
                        children.add(topLevelFolder);
                    }
                }
            } else {
                FilterInterface filter = this.createFolderSearchFilter(folder.getIdentifier(), this._model.getSearchFilters(), recursive);
                BrowseMetadataInterface browseFolder = this._server.browseFolder(folderKey, filter);
                children.addAll(browseFolder.getSubfolders());
                children.addAll(browseFolder.getMembers());
            }
            return children;
        }

        @Override
        protected FilterInterface getMembersFilter(List<SearchFilter> criteriaList, String folderID) {
            if (SASFoldersModel.this._config.getModelDisplayMode() == ModelDisplayMode.FOLDERS_ONLY) {
                return null;
            }
            FilterInterface membersFilter = super.getMembersFilter(criteriaList, folderID);
            if (SASFoldersModel.this.getConfiguration().isSearchingProjectReposOnly()) {
                String reposID = folderID.substring(0, 8);
                if (membersFilter == null) {
                    membersFilter = new Filter();
                    membersFilter.setFilterComponent(new FilterComponent(METADATA_ID, 2, reposID));
                } else {
                    FilterComponent comp = membersFilter.getFilterComponent();
                    comp.addComponent(new FilterComponent(METADATA_ID, 2, reposID));
                }
            }
            return membersFilter;
        }

        @Override
        protected FilterInterface getSubFoldersFilter(List<SearchFilter> criteriaList, String folderID) {
            FilterInterface subFoldersFilter = super.getSubFoldersFilter(criteriaList, folderID);
            if (SASFoldersModel.this.getConfiguration().isSearchingProjectReposOnly()) {
                String reposID = folderID.substring(0, 8);
                if (subFoldersFilter == null) {
                    subFoldersFilter = new Filter();
                    subFoldersFilter.setFilterComponent(new FilterComponent(METADATA_ID, 2, reposID));
                } else {
                    FilterComponent comp = subFoldersFilter.getFilterComponent();
                    comp.addComponent(new FilterComponent(METADATA_ID, 2, reposID));
                }
            }
            return subFoldersFilter;
        }
    }
}

