/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.publicobject;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.AbstractProcessor;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.publicobject.ResponsibilityDetails;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@SASScope
public class DetailsProcessor
extends AbstractProcessor
implements DetailsProcessorInterface {
    private static final long serialVersionUID = 3107671947399766909L;

    public DetailsProcessor(MetadataInterface publicObject) {
        super(publicObject);
    }

    @Override
    public Date getCreateDate() throws ServiceException, RemoteException {
        MetadataInterface mi = (MetadataInterface)this._publicObject;
        return mi.getCreateDate();
    }

    @Override
    public String getCreatedBy() throws ServiceException, RemoteException {
        ResponsibilityDetails details = this.getCreatedByDetails();
        return details == null ? "" : details.getName();
    }

    @Override
    public ResponsibilityDetails getCreatedByDetails() throws ServiceException, RemoteException {
        return this.getCreatedModifiedByInfo("Created By");
    }

    @Override
    public String getDescription() throws ServiceException, RemoteException {
        MetadataInterface mi = (MetadataInterface)this._publicObject;
        return mi.getDescription();
    }

    @Override
    public String getDisplayName() throws ServiceException, RemoteException {
        return this.getName();
    }

    @Override
    public List<String> getKeywords() throws ServiceException, RemoteException {
        MetadataInterface mi = (MetadataInterface)this._publicObject;
        return mi.getKeywords();
    }

    @Override
    public Date getModifyDate() throws ServiceException, RemoteException {
        MetadataInterface mi = (MetadataInterface)this._publicObject;
        return mi.getModifyDate();
    }

    @Override
    public String getModifiedBy() throws ServiceException, RemoteException {
        ResponsibilityDetails details = this.getModifiedByDetails();
        return details == null ? "" : details.getName();
    }

    @Override
    public ResponsibilityDetails getModifiedByDetails() throws ServiceException, RemoteException {
        return this.getCreatedModifiedByInfo("Modified By");
    }

    @Override
    public String getName() throws ServiceException, RemoteException {
        return this._publicObject.getName();
    }

    @Override
    public List<ResponsibilityDetails> getResponsibilities() throws ServiceException, RemoteException {
        return this.getResponsibilities(false);
    }

    private List<ResponsibilityDetails> getResponsibilities(boolean includeCreatedModifiedByRoles) throws ServiceException, RemoteException {
        ArrayList<ResponsibilityDetails> results = new ArrayList<ResponsibilityDetails>();
        MetadataInterface mi = (MetadataInterface)this._publicObject;
        Object entity = mi.getRepositoryEntity();
        if (entity instanceof Root) {
            try {
                AssociationList responsibilities = ((Root)entity).getResponsibleParties();
                if (responsibilities.size() > 0) {
                    for (ResponsibleParty responsibility : responsibilities) {
                        String role = responsibility.getRole();
                        if (!includeCreatedModifiedByRoles && ("Created By".equalsIgnoreCase(role) || "Modified By".equalsIgnoreCase(role))) continue;
                        AssociationList identities = responsibility.getPersons();
                        for (Identity identity : identities) {
                            results.add(new ResponsibilityDetails(identity.getName(), identity.getDisplayName(), role));
                        }
                    }
                }
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return results;
    }

    @Override
    public TypeDescriptorInterface getType() throws ServiceException, RemoteException {
        return this._publicObject.getTypeDescriptor();
    }

    @Override
    public UsageVersion getUsageVersion() throws ServiceException, RemoteException {
        MetadataInterface mi = (MetadataInterface)this._publicObject;
        return mi.getUsageVersion();
    }

    private ResponsibilityDetails getCreatedModifiedByInfo(String role) throws ServiceException, RemoteException {
        List<ResponsibilityDetails> responsibilities = this.getResponsibilities(true);
        if (responsibilities != null) {
            for (ResponsibilityDetails responsibility : responsibilities) {
                if (!role.equalsIgnoreCase(responsibility.getRole())) continue;
                return responsibility;
            }
        }
        return null;
    }
}

