/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.publicobject;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.BaseDetailsProcessor;
import com.sas.services.information.publicobject.ProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import java.io.Serializable;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class BasePublicObject
implements PublicObjectInterface,
Serializable {
    private static final long serialVersionUID = -3048832109181551970L;
    private static final String PUBLIC_TYPE = "PublicType";
    protected TypeDescriptorInterface _type;
    protected String _id;
    protected String _name;
    protected PathUrl _path;
    protected ServerInterface _server;
    protected BrowseMetadataInterface _browseObject;
    protected PublicObjectContainerInterface _container;
    protected Map<String, ProcessorInterface> _processorInterfaces;

    protected BasePublicObject(BrowseMetadataInterface browse) {
        this._browseObject = browse;
        this._id = browse.getReposId();
        this._name = browse.getName();
    }

    protected BasePublicObject(String id, String name, TypeDescriptorInterface type) {
        this._id = id;
        this._name = name;
        this._type = type;
    }

    public void setBrowseObject(BrowseMetadataInterface browse) throws ServiceException, RemoteException {
        this._browseObject = browse;
        this.setName(browse.getName());
    }

    public BrowseMetadataInterface getBrowseObject() throws ServiceException, RemoteException {
        return this._browseObject;
    }

    public void setServer(ServerInterface server) throws ServiceException, RemoteException {
        this._server = server;
    }

    public ServerInterface getServer() throws ServiceException, RemoteException {
        return this._server;
    }

    @Override
    public String getIdentifier() throws ServiceException, RemoteException {
        return this._id;
    }

    @Override
    public String getName() throws RemoteException {
        return this._name;
    }

    public void setName(String name) throws ServiceException, RemoteException {
        this._name = name;
    }

    @Override
    public TypeDescriptorInterface getTypeDescriptor() throws ServiceException, RemoteException {
        String publicType;
        if (this._type == null && this._browseObject != null && this._server != null && (publicType = (String)this._browseObject.getRawData().get(PUBLIC_TYPE)) != null) {
            if (publicType.startsWith("Embedded:")) {
                publicType = publicType.substring(9);
            }
            this._type = this._server.getTypeDescriptor(publicType);
        }
        return this._type;
    }

    @Override
    public PathUrl getPathUrl() throws IllegalStateException, ServiceException, RemoteException {
        String key;
        MetadataInterface mi;
        TypeDescriptorInterface type;
        if (this._path == null && this._server != null && (type = this.getTypeDescriptor()) != null && (mi = this._server.fetch(key = this._id + "/" + type.getMetadataType(), false)) != null) {
            this._path = mi.getPathUrl();
        }
        return this._path;
    }

    protected void setPathUrl(PathUrl path) throws ServiceException, RemoteException {
        this._path = path;
    }

    @Override
    public PublicObjectContainerInterface getContainer() throws ServiceException, RemoteException {
        String key;
        MetadataInterface mi;
        TypeDescriptorInterface type;
        if (this._container == null && this._server != null && (type = this.getTypeDescriptor()) != null && (mi = this._server.fetch(key = this._id + "/" + type.getMetadataType(), false)) != null) {
            this._container = mi.getContainer();
        }
        return this._container;
    }

    @Override
    public URI getObjectURI() throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public ProcessorInterface getProcessorInterface(String interfaceClassName) throws ServiceException, RemoteException {
        this.initializeProcessors();
        ProcessorInterface returnValue = this._processorInterfaces.get(interfaceClassName);
        if (returnValue != null) {
            return returnValue;
        }
        if ("com.sas.services.information.publicobject.DetailsProcessorInterface".equals(interfaceClassName)) {
            returnValue = new BaseDetailsProcessor(this);
            this.addProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface", returnValue);
        }
        return returnValue;
    }

    @Override
    public void addProcessorInterface(String interfaceClassName, ProcessorInterface actionInterface) throws ServiceException, RemoteException {
        this.initializeProcessors();
        this._processorInterfaces.put(interfaceClassName, actionInterface);
    }

    private void initializeProcessors() {
        if (this._processorInterfaces == null) {
            this._processorInterfaces = new HashMap<String, ProcessorInterface>(3);
        }
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder(64);
            sb.append(this.getTypeDescriptor().getType());
            sb.append(" ");
            sb.append(this.getName());
            sb.append(" ");
            sb.append(this.getIdentifier());
            return sb.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

