/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.publicobject;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.browse.BrowseMetadataUtil;
import com.sas.services.information.publicobject.AbstractProcessor;
import com.sas.services.information.publicobject.BasePublicObject;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.publicobject.ResponsibilityDetails;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SASScope
public class BaseDetailsProcessor
extends AbstractProcessor
implements DetailsProcessorInterface {
    private static final long serialVersionUID = 1870158425045493787L;
    public static final String USAGE_VERSION_KEY = "UsageVersion";
    public static final String RESPONSIBLE_PARTIES_KEY = "ResponsibleParties";
    private String _description = null;
    private String _displayName = null;
    private Date _createdDate = null;
    private Date _modifiedDate = null;

    public BaseDetailsProcessor(BasePublicObject publicObject) throws RemoteException {
        super(publicObject);
    }

    @Override
    public Date getCreateDate() throws ServiceException, RemoteException {
        if (this._createdDate != null) {
            return this._createdDate;
        }
        BrowseMetadataInterface browse = this.getBrowseObject("MetadataCreated");
        return browse != null ? browse.getCreateDateAsDate() : null;
    }

    public void setCreateDate(Date date) throws ServiceException, RemoteException {
        this._createdDate = date;
    }

    @Override
    public String getCreatedBy() throws ServiceException, RemoteException {
        ResponsibilityDetails details = this.getCreatedByDetails();
        return details == null ? "" : details.getName();
    }

    @Override
    public ResponsibilityDetails getCreatedByDetails() throws ServiceException, RemoteException {
        return this.getCreatedModifiedByInfo("Created By");
    }

    @Override
    public Date getModifyDate() throws ServiceException, RemoteException {
        if (this._modifiedDate != null) {
            return this._modifiedDate;
        }
        BrowseMetadataInterface browse = this.getBrowseObject("MetadataUpdated");
        return browse != null ? browse.getModifyDateAsDate() : null;
    }

    public void setModifyDate(Date date) throws ServiceException, RemoteException {
        this._modifiedDate = date;
    }

    @Override
    public String getModifiedBy() throws ServiceException, RemoteException {
        ResponsibilityDetails details = this.getModifiedByDetails();
        return details == null ? "" : details.getName();
    }

    @Override
    public ResponsibilityDetails getModifiedByDetails() throws ServiceException, RemoteException {
        return this.getCreatedModifiedByInfo("Modified By");
    }

    @Override
    public String getDescription() throws ServiceException, RemoteException {
        if (this._description != null) {
            return this._description;
        }
        BrowseMetadataInterface browse = this.getBrowseObject("Desc");
        return browse != null ? browse.getDescription() : "";
    }

    public void setDescription(String desc) throws ServiceException, RemoteException {
        this._description = desc;
    }

    @Override
    public UsageVersion getUsageVersion() throws ServiceException, RemoteException {
        BrowseMetadataInterface browse = this.getBrowseObject(USAGE_VERSION_KEY);
        return browse != null ? BrowseMetadataUtil.getUsageVersion(browse) : null;
    }

    @Override
    public List<String> getKeywords() throws ServiceException, RemoteException {
        BrowseMetadataInterface browse = this.getBrowseObject("Keywords");
        return browse != null ? browse.getKeywords() : Collections.emptyList();
    }

    @Override
    public List<ResponsibilityDetails> getResponsibilities() throws ServiceException, RemoteException {
        BrowseMetadataInterface browse = this.getBrowseObject(RESPONSIBLE_PARTIES_KEY);
        if (browse == null) {
            return Collections.emptyList();
        }
        return BrowseMetadataUtil.getResponsibilities(browse);
    }

    @Override
    public String getName() throws ServiceException, RemoteException {
        return this._publicObject.getName();
    }

    @Override
    public String getDisplayName() throws ServiceException, RemoteException {
        if (this._displayName != null) {
            return this._displayName;
        }
        BrowseMetadataInterface browse = ((BasePublicObject)this._publicObject).getBrowseObject();
        if (browse != null) {
            return BrowseMetadataUtil.getDisplayName(browse);
        }
        return this.getName();
    }

    public void setDisplayName(String displayName) throws ServiceException, RemoteException {
        this._displayName = displayName;
    }

    @Override
    public TypeDescriptorInterface getType() throws ServiceException, RemoteException {
        return this._publicObject.getTypeDescriptor();
    }

    private BrowseMetadataInterface getBrowseObject(String key) throws ServiceException, RemoteException {
        TypeDescriptorInterface type;
        BrowseMetadataInterface browse = ((BasePublicObject)this._publicObject).getBrowseObject();
        if (browse != null && key != null && browse.get(key) != null) {
            return browse;
        }
        ServerInterface server = ((BasePublicObject)this._publicObject).getServer();
        if (server != null && (type = this._publicObject.getTypeDescriptor()) != null) {
            String id = this._publicObject.getIdentifier();
            if (id == null || id.length() == 0) {
                return null;
            }
            String objectURI = id + "/" + type.getMetadataType();
            browse = server.browseFetch(objectURI, this.createFilter());
            this.mergeData(browse, (BasePublicObject)this._publicObject);
            this.resetAttributes();
        }
        return browse;
    }

    private void mergeData(BrowseMetadataInterface browse, BasePublicObject publicObject) throws ServiceException, RemoteException {
        BrowseMetadataInterface originalBrowse = publicObject.getBrowseObject();
        if (originalBrowse == null) {
            publicObject.setBrowseObject(browse);
        } else {
            Map originalData = originalBrowse.getRawData();
            Map newData = browse.getRawData();
            originalData.putAll(newData);
        }
    }

    private void resetAttributes() {
        this._description = null;
        this._createdDate = null;
        this._modifiedDate = null;
        this._displayName = null;
    }

    private FilterInterface createFilter() throws ServiceException, RemoteException {
        Filter filter = new Filter();
        filter.setOMRFlags(-2080374764);
        TypeDescriptorInterface type = this._publicObject.getTypeDescriptor();
        if (type != null) {
            String metadataType = type.getMetadataType();
            String template = "<Templates><" + metadataType + " Name=\"\" DisplayName=\"\" PublicType=\"\" Desc=\"\" MetadataCreated=\"\" MetadataUpdated=\"\" UsageVersion=\"\"><Keywords /><ResponsibleParties /></" + metadataType + "><Keyword Name=\"\" /><ResponsibleParty Role=\"\"><Persons /></ResponsibleParty><Identity Name=\"\" DisplayName=\"\" PublicType=\"\"/></Templates>";
            filter.setOMRTemplate(template);
        }
        return filter;
    }

    private ResponsibilityDetails getCreatedModifiedByInfo(String role) throws ServiceException, RemoteException {
        BrowseMetadataInterface browse = this.getBrowseObject(RESPONSIBLE_PARTIES_KEY);
        if (browse != null) {
            if ("Created By".equalsIgnoreCase(role)) {
                return BrowseMetadataUtil.getCreatedByDetails(browse);
            }
            if ("Modified By".equalsIgnoreCase(role)) {
                return BrowseMetadataUtil.getModifiedByDetails(browse);
            }
        }
        return null;
    }
}

