/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.metadata.remote.impl.ServerComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.OMRProperty;
import com.sas.services.information.metadata.OMRSASClientConnection;
import com.sas.services.information.metadata.OMRSASLibrary;
import com.sas.services.information.metadata.OMRServerComponent;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.information.metadata.servers.LASRMultipleLibrariesException;
import com.sas.services.information.metadata.servers.LASRMultipleTablesException;
import com.sas.services.information.metadata.servers.LASRServerInterface;
import com.sas.services.information.metadata.servers.LASRUtilities;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class LASRServerImpl
extends OMRServerComponent
implements LASRServerInterface {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = LogManager.getLogger(LASRServerImpl.class);
    private static final String PROPERTY_NAME_HOST = "Connection.LASR.Property.Server.Name.xmlKey.txt";
    private static final String PROPERTY_NAME_SIGNER = "Connection.LASR.PropertyGroup.Signer.xmlKey.txt";
    private static final String PROPERTY_PROPERTYNAME_SIGNER = "SIGNER";
    private static final String ALTERNATE_PERSISTENCE_PROPERTY = "sas.publicobjects.servers.lasr.alternatepersistence";
    private OMRSASClientConnection _connection = null;
    public static final String SECURITY_KEY_NAME = "LASR Server Security Key";
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public LASRServerImpl() throws RemoteException {
    }

    public LASRServerImpl(ServerComponent o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public LASRServerImpl(ServerComponentImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public LASRServerImpl(ServerComponentImpl_Stub o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public LASRServerImpl(RepositoryInterface repository, String name) throws RemoteException {
        if (repository == null || name == null) {
            throw new IllegalArgumentException();
        }
        try {
            OMIRepositoryInterface omiRepository = (OMIRepositoryInterface)repository;
            ServerComponent sc = (ServerComponent)omiRepository.createMetadata(name, "ServerComponent");
            sc.setPublicType("Server.LASR");
            sc.setUsageVersion(CURRENT_VERSION.encode());
            sc.setClassIdentifier("SASIOLA");
            sc.setMajor(9);
            sc.setMinor(3);
            sc.setProductName("SASIOLA");
            sc.setVendor("SAS");
            sc.setSoftwareVersion("2");
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = sc;
            this._repositoryFlag = 2;
            this.setRepository(repository);
            this.createClientConnection();
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    private void createClientConnection() throws RemoteException {
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this.getRepository();
            SASClientConnection cxn = (SASClientConnection)omirepository.createMetadata("Connection: " + this.getName(), "SASClientConnection");
            cxn.setUsageVersion(OLDEST_VERSION.encode());
            cxn.setApplicationProtocol("LASRProtocol");
            cxn.setCommunicationProtocol("TCP");
            this._connection = new OMRSASClientConnection(cxn);
            this._connection.setRepository(this.getRepository());
            this.addSourceConnection(this._connection);
            this.initializeLASRServicesUrl();
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    @Override
    public String getType() {
        return "Server.LASR";
    }

    @Override
    public void setName(String name) throws RemoteException {
        super.setName(name);
        try {
            OMRSASClientConnection con = this.getClientConnection(true);
            if (con != null) {
                con.setName("Connection: " + name);
            }
        }
        catch (ServiceException ex) {
            _logger.error("Unable to set name on associated connection object.", (Throwable)((Object)ex));
        }
    }

    @Override
    public String getHost() throws ServiceException, RemoteException {
        String host = null;
        host = this.getConnectionPropertyValue("Host");
        if (host == null || host.length() == 0) {
            host = super.getHost();
        }
        return host;
    }

    @Override
    public String getShortHost() throws ServiceException, RemoteException {
        String hostname = this.getHost();
        if (hostname.contains(".")) {
            return hostname.substring(0, hostname.indexOf("."));
        }
        return hostname;
    }

    @Override
    public void setHost(String host) throws ServiceException, RemoteException {
        super.setHost(host);
        this.setConnectionProperty(PROPERTY_NAME_HOST, "Host".toUpperCase(), host);
    }

    @Override
    public void setTcpPort(int port) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        DeployedComponent server = (DeployedComponent)this._repositoryObject;
        try {
            AssociationList ass = server.getSourceConnections();
            for (Connection con : ass) {
                if (con instanceof TCPIPConnection) {
                    ((TCPIPConnection)con).setPort(port);
                    continue;
                }
                if (!(con instanceof SASClientConnection)) continue;
                ((SASClientConnection)con).setPort(port);
            }
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.servers.LASRServerImpl", ex);
        }
    }

    @Override
    public int getPort() throws ServiceException, RemoteException {
        return super.getTcpPort();
    }

    public void setPort(int port) throws ServiceException, RemoteException {
        this.setTcpPort(port);
    }

    @Override
    public String getInstallPath() throws ServiceException, RemoteException {
        String installPath = null;
        List lstProp = this.getProperties("INSTALL");
        if (lstProp != null && !lstProp.isEmpty()) {
            PropertyInterface prop = (PropertyInterface)lstProp.get(0);
            installPath = prop.getValue();
        }
        return installPath;
    }

    @Override
    public void setInstallPath(String installPath) throws ServiceException, RemoteException {
        List lstProp = this.getProperties("INSTALL");
        if (lstProp != null && !lstProp.isEmpty()) {
            PropertyInterface prop = (PropertyInterface)lstProp.get(0);
            prop.setValue(installPath);
        }
    }

    @Override
    public String getLifetime() throws ServiceException, RemoteException {
        return this.getConnectionPropertyValue("LIFETIME");
    }

    @Override
    public void setLifetime(String lifetime) throws ServiceException, RemoteException {
        this.setConnectionProperty("LIFETIME", lifetime);
    }

    @Override
    public String getSignatureFilePath() throws ServiceException, RemoteException {
        return this.getConnectionPropertyValue("PATH");
    }

    @Override
    public void setSignatureFilePath(String signatureFilePath) throws ServiceException, RemoteException {
        this.setConnectionProperty("PATH", signatureFilePath);
    }

    @Override
    public boolean isLogEnabled() throws ServiceException, RemoteException {
        return this.getConnectionProperty("LOGGING") != null;
    }

    @Override
    public void setLogEnabled(boolean logEnabled) throws ServiceException, RemoteException {
        if (logEnabled) {
            this.setConnectionProperty("LOGGING", "LOGGING");
        } else {
            this.setConnectionProperty("LOGGING", null);
        }
    }

    @Override
    public String getLogOptions() throws ServiceException, RemoteException {
        return this.getConnectionPropertyValue("ADDITIONALLOGOPTIONS");
    }

    @Override
    public void setLogOptions(String logOptions) throws ServiceException, RemoteException {
        this.setConnectionProperty("ADDITIONALLOGOPTIONS", logOptions);
    }

    @Override
    public boolean isLogVerbose() throws ServiceException, RemoteException {
        return this.getConnectionProperty("VERBOSE") != null;
    }

    @Override
    public void setLogVerbose(boolean logVerbose) throws ServiceException, RemoteException {
        if (logVerbose) {
            this.setConnectionProperty("VERBOSE", "VERBOSE");
        } else {
            this.setConnectionProperty("VERBOSE", null);
        }
    }

    @Override
    public String getSecurityKey() throws ServiceException, RemoteException {
        Login login = this.getSecurityKeyLogin();
        if (login == null) {
            _logger.warn("Security key Login object not found.");
            return null;
        }
        try {
            MdObjectStore store = (MdObjectStore)login.getObjectStore();
            store.refreshObjectFromServer((CMetadata)login, false, true, true);
            if (System.getProperty(ALTERNATE_PERSISTENCE_PROPERTY) == null) {
                String securityKey = login.getPassword();
                if ("********".equals(securityKey)) {
                    _logger.error("LASR server security keys are not accessible to this identity.");
                    throw new IllegalStateException("LASR server security keys are not accessible to this identity.");
                }
                return SasPasswordString.decode((String)securityKey);
            }
            if (!login.getUserID().startsWith("LASR:")) {
                _logger.error("Invalid LASR server security key.  Alternate persistence prefix not found.");
                throw new IllegalStateException("Invalid LASR server security key.  Alternate persistence prefix not found.");
            }
            String securityKey = login.getUserID().substring(5);
            return SasPasswordString.decode((String)securityKey);
        }
        catch (SasPasswordEncodingException e) {
            throw new ServiceException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void setSecurityKey(String securityKey) throws ServiceException, RemoteException {
        if (securityKey != null && securityKey.length() > 128) {
            throw new IllegalArgumentException("Security keys are limited to 128 characters.");
        }
        Login login = this.getSecurityKeyLogin();
        if (securityKey == null) {
            if (login != null) {
                login.delete();
            }
            return;
        }
        if (login == null) {
            _logger.debug("Security key Login object not found.  Creating new Login.");
            Identity identity = (Identity)this._repository.getIdentity().getRepositoryEntity();
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
                login = (Login)omirepository.createMetadata(SECURITY_KEY_NAME, "Login");
                login.setAssociatedIdentity(identity);
                login.setUserID("LASRSecurityKey " + this.getHost() + ":" + this.getPort() + this.getReposId());
                CustomAssociation association = (CustomAssociation)omirepository.createMetadata("SecuredLASRServer", "CustomAssociation");
                association.setOwningObject((Root)login);
                association.setisOwned(1);
                association.setPartnerName("LASRSecurityKey");
                association.getAssociatedObjects().add(this.getClientConnection().getRepositoryEntity());
            }
            catch (MdException e) {
                _logger.error("Exception occurred while attempting to create new security key Login.", (Throwable)e);
                throw new ServiceException(e);
            }
        }
        if (System.getProperty(ALTERNATE_PERSISTENCE_PROPERTY) == null) {
            login.setPassword(securityKey);
            this.update();
        } else {
            try {
                login.setUserID("LASR:" + SasPasswordString.encode((String)"sas002", (String)securityKey));
                this.update();
            }
            catch (SasPasswordEncodingException e) {
                throw new ServiceException(e);
            }
        }
    }

    private Login getSecurityKeyLogin() throws ServiceException, RemoteException {
        SASClientConnection connection = (SASClientConnection)this.getClientConnection().getRepositoryEntity();
        try {
            AssociationList associations = connection.getReferencedObjects(true);
            for (CustomAssociation association : associations) {
                if (!"LASRSecurityKey".equalsIgnoreCase(association.getPartnerName())) continue;
                _logger.debug("Associated Security Key found.");
                Root associatedObject = association.getOwningObject();
                if (!(associatedObject instanceof Login)) {
                    _logger.debug("Object was not a Login.");
                    continue;
                }
                Login login = (Login)associatedObject;
                if (!SECURITY_KEY_NAME.equals(login.getName())) {
                    _logger.debug("Login object name didn't match.");
                    continue;
                }
                Identity identity = (Identity)this._repository.getIdentity().getRepositoryEntity();
                Identity identity2 = login.getAssociatedIdentity();
                if (identity2 == null || !identity.getId().equalsIgnoreCase(identity2.getId())) {
                    _logger.debug("Security key Login identity didn't match.");
                    continue;
                }
                return login;
            }
        }
        catch (MdException e) {
            _logger.error("Exception occurred while attempting to locate Security key Login object.", (Throwable)e);
            throw new ServiceException(e);
        }
        return null;
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        SASClientConnection connection = (SASClientConnection)this.getClientConnection().getRepositoryEntity();
        try {
            AssociationList properties = connection.getProperties();
            ArrayList<Property> tempList = new ArrayList<Property>(properties.size());
            for (Property property : properties) {
                tempList.add(property);
            }
            for (Property property : tempList) {
                property.delete();
            }
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        super.delete();
    }

    @Override
    public SASLibraryInterface getLibraryByTag(String tag) throws RemoteException, ServiceException {
        List libs = this.getClientConnection().getLibraries();
        OMRSASLibrary libraryFinal = null;
        for (Object lib : libs) {
            OMRSASLibrary library = (OMRSASLibrary)lib;
            if (!tag.equalsIgnoreCase(LASRUtilities.getLibraryTag(library))) continue;
            if (libraryFinal != null) {
                throw new LASRMultipleLibrariesException(this.getHost(), tag);
            }
            libraryFinal = library;
        }
        return libraryFinal;
    }

    @Override
    public SASLibraryInterface getLibraryByLibref(String name) throws RemoteException, ServiceException {
        List libs = this.getClientConnection().getLibraries();
        OMRSASLibrary libraryFinal = null;
        for (Object lib : libs) {
            OMRSASLibrary library = (OMRSASLibrary)lib;
            if (!name.equalsIgnoreCase(library.getLibref())) continue;
            if (libraryFinal != null) {
                throw new LASRMultipleLibrariesException(this.getHost(), name);
            }
            libraryFinal = library;
        }
        return libraryFinal;
    }

    @Override
    public PhysicalTableInterface getTableByName(String name) throws RemoteException, ServiceException {
        List libs = this.getClientConnection().getLibraries();
        PhysicalTableInterface tableFinal = null;
        for (Object lib1 : libs) {
            OMRSASLibrary lib = (OMRSASLibrary)lib1;
            try {
                List tables = lib.getTables();
                for (Object table1 : tables) {
                    PhysicalTableInterface table = (PhysicalTableInterface)table1;
                    if (!LASRUtilities.getTableNameAndTag(lib, table).equalsIgnoreCase(name)) continue;
                    if (tableFinal != null) {
                        throw new LASRMultipleTablesException(this.getHost(), this.getPort(), LASRUtilities.getLibraryTag(lib), name);
                    }
                    tableFinal = table;
                }
            }
            catch (RuntimeException e) {
                _logger.error((Object)e);
            }
        }
        return tableFinal;
    }

    public String getLASRServicesUrl() throws ServiceException {
        String url = null;
        try {
            url = this.getConnectionPropertyValue(PROPERTY_PROPERTYNAME_SIGNER);
            if (url == null || url.isEmpty()) {
                url = this.initializeLASRServicesUrl();
            }
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
        }
        return url;
    }

    private String initializeLASRServicesUrl() throws ServiceException {
        try {
            MdObjectStore store = ((OMIServer)this.getRepository().getUserContext().getAuthServer()).getObjectStore();
            MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
            List comps = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "DeployedComponent", 8584, "<XMLSelect search=\"DeployedComponent[@Name='LASRAuthorizationService REST']\"/>");
            if (comps.size() == 0) {
                return "";
            }
            AssociationList cxns = ((DeployedComponent)comps.get(0)).getSourceConnections();
            if (cxns.size() > 0) {
                try {
                    TCPIPConnection cxn = (TCPIPConnection)cxns.get(0);
                    StringBuilder urlBuilder = new StringBuilder();
                    urlBuilder.append(cxn.getCommunicationProtocol());
                    urlBuilder.append("://");
                    urlBuilder.append(cxn.getHostName());
                    urlBuilder.append(":");
                    urlBuilder.append(cxn.getPort());
                    urlBuilder.append(cxn.getService().substring(0, cxn.getService().lastIndexOf(47)));
                    String existingUrl = this.getConnectionPropertyValue(PROPERTY_PROPERTYNAME_SIGNER);
                    if (!existingUrl.equals(urlBuilder.toString())) {
                        this.setConnectionProperty(PROPERTY_NAME_SIGNER, PROPERTY_PROPERTYNAME_SIGNER, urlBuilder.toString());
                    }
                    return urlBuilder.toString();
                }
                catch (Exception ex) {
                    _logger.error("Unable to determine LASR Authorization Service URL.", (Throwable)ex);
                    return "";
                }
            }
            return "";
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    private OMRSASClientConnection getClientConnection(Boolean createIfNull) throws ServiceException, RemoteException {
        if (this._connection == null) {
            List connections = this.getSourceConnections();
            if (connections.size() > 0) {
                this._connection = (OMRSASClientConnection)connections.get(0);
            } else if (createIfNull.booleanValue()) {
                this.createClientConnection();
            }
        }
        return this._connection;
    }

    private OMRSASClientConnection getClientConnection() throws ServiceException, RemoteException {
        return this.getClientConnection(false);
    }

    private OMRProperty getConnectionProperty(String name) throws ServiceException, RemoteException {
        OMRSASClientConnection connection = this.getClientConnection();
        if (connection != null) {
            List properties = connection.getObjectProperties();
            for (OMRProperty prop : properties) {
                if (!name.equalsIgnoreCase(prop.getKey())) continue;
                return prop;
            }
        }
        return null;
    }

    private String getConnectionPropertyValue(String name) throws ServiceException, RemoteException {
        OMRProperty property = this.getConnectionProperty(name);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    public void setConnectionProperty(String name, String value) throws ServiceException, RemoteException {
        this.setConnectionProperty(name, name, value);
    }

    public void setConnectionProperty(String name, String propertyName, String value) throws ServiceException, RemoteException {
        OMRProperty prop = this.getConnectionProperty(propertyName);
        if (prop != null) {
            prop.setValue(value);
        } else {
            this.getClientConnection().addObjectProperty(name, propertyName.toUpperCase(), value, "String");
        }
    }

    @Override
    public PropertyList getSubstitutionProperties() {
        PropertyList srvProperties = new PropertyList();
        try {
            if (this.getTypeDescriptor() != null) {
                String HPAENVPATH;
                int port;
                String host = this.getHost();
                if (null != host && !host.isEmpty()) {
                    srvProperties.addProperty("Host", host);
                }
                if ((port = this.getTcpPort()) != -1) {
                    srvProperties.addProperty("Port", String.valueOf(port));
                }
                if (null != (HPAENVPATH = this.getInstallPath()) && !HPAENVPATH.isEmpty()) {
                    srvProperties.addProperty("DirPath", HPAENVPATH);
                }
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        return srvProperties;
    }

    @Override
    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        try {
            if (this.getTypeDescriptor() != null) {
                String serverHost = map.getProperty("Host");
                String port = map.getProperty("Port");
                String HPAENVPATH = map.getProperty("DirPath");
                if (serverHost != null) {
                    this.setHost(serverHost);
                }
                if (port != null) {
                    this.setPort(Integer.parseInt(port));
                }
                if (HPAENVPATH != null && HPAENVPATH.length() > 0) {
                    this.setInstallPath(HPAENVPATH);
                }
            }
            this.initializeLASRServicesUrl();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

