/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.dav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.io.InputStreamAdapter;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.dav.DAVEntity;
import com.sas.services.information.metadata.dav.DAVItemInterface;
import com.sas.services.webdav.DAVResourceInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Map;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DAVItem
extends DAVEntity
implements DAVItemInterface {
    private static final int BUFFER_SIZE = 8192;
    private String _contentType = null;
    private File _contentsFile = null;
    private byte[] _contents;
    private int _contentsStatus = 0;

    public DAVItem(RepositoryInterface repos, String reposId) {
        super(repos, reposId);
        this._objectClass = "content";
    }

    public DAVItem(String url, Map properties) {
        super(url, properties);
        if (this._objectClass != null && this._objectClass.equals("unknown")) {
            this._objectClass = "content";
        }
    }

    public DAVItem(RepositoryData entity) {
        super(entity);
        if (this._objectClass != null && this._objectClass.equals("unknown")) {
            this._objectClass = "content";
        }
    }

    @Override
    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    @Override
    public String getContentType() {
        if (this._contentType == null && this._properties != null && this._properties.containsKey("{DAV:}getcontenttype")) {
            this._contentType = (String)this._properties.get("{DAV:}getcontenttype");
        }
        return this._contentType;
    }

    @Override
    public InputStream getContents() throws RemoteException {
        this.checkContents();
        if (this._contents != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(this._contents);
            return new InputStreamAdapter((InputStream)bais);
        }
        if (this._contentsFile != null) {
            try {
                return new InputStreamAdapter((InputStream)new FileInputStream(this._contentsFile));
            }
            catch (IOException ioe) {
                ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
                return new InputStreamAdapter((InputStream)bais);
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        return new InputStreamAdapter((InputStream)bais);
    }

    @Override
    public void setContents(byte[] contents) {
        if (this._contentsFile == null) {
            this._contentsFile = this.makeTempFile(this.getName());
        }
        this.buffer2File(contents, this._contentsFile);
        this._contents = null;
        this._contentsStatus = 1;
    }

    @Override
    public void setContents(InputStream contents) {
        if (this._contentsFile == null) {
            this._contentsFile = this.makeTempFile(this.getName());
        }
        this.stream2File(contents, this._contentsFile);
        this._contents = null;
        this._contentsStatus = 1;
    }

    @Override
    public void setContentsfromStore(DAVResourceInterface r) {
        if (this._contentsFile == null) {
            this._contentsFile = this.makeTempFile(this.getName());
        }
        try {
            r.getContents(this._contentsFile);
            this._contentType = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._contents = null;
        this._contentsStatus = 2;
    }

    @Override
    public int getContentLength() {
        this.checkContents();
        if (this._contents != null) {
            return this._contents.length;
        }
        if (this._contentsFile != null) {
            return (int)this._contentsFile.length();
        }
        return 0;
    }

    @Override
    public byte[] getContentsAsBytes() {
        this.checkContents();
        if (this._contents != null) {
            return this._contents;
        }
        if (this._contentsFile != null) {
            return this.file2ByteArray(this._contentsFile);
        }
        return new byte[0];
    }

    @Override
    public String toString() {
        return this._properties.toString();
    }

    @Override
    public void clearLocalLists() {
        super.clearLocalLists();
        this._contentsStatus = 2;
    }

    @Override
    public boolean hasContentsUpdates() {
        return this._contentsStatus == 1;
    }

    private void checkContents() {
        if (this._contentsStatus == 1) {
            return;
        }
        if (!this.hasBeenFetched) {
            this.fetchEntity();
        }
        if (this._contentsStatus == 0 || this._contentsStatus == 2 && this._contentsFile == null && this._contents == null) {
            DAVRepositoryInterface DAVRepos = (DAVRepositoryInterface)this._repos;
            if (this._contentsFile == null) {
                this._contentsFile = this.makeTempFile(this.getName());
            }
            try {
                DAVRepos.fetchContents(this._reposId, this._contentsFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this._contents = null;
            this._contentsStatus = 2;
        }
    }

    private File makeTempFile(String name) {
        File _file = null;
        try {
            _file = File.createTempFile("pfs", ".tmp");
            _file.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return _file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stream2File(InputStream in, File out) {
        byte[] buffer = new byte[8192];
        FileOutputStream fout = null;
        try {
            int len;
            fout = new FileOutputStream(out);
            while ((len = in.read(buffer)) != -1) {
                fout.write(buffer, 0, len);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buffer2File(byte[] buffer, File out) {
        FileOutputStream fout = null;
        try {
            int len;
            fout = new FileOutputStream(out);
            for (int index = 0; index < buffer.length; index += len) {
                len = Math.min(8192, buffer.length - index);
                fout.write(buffer, index, len);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] file2ByteArray(File _file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        FileInputStream fin = null;
        try {
            int len;
            fin = new FileInputStream(_file);
            while ((len = fin.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
        }
        catch (FileNotFoundException ioe) {
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return baos.toByteArray();
    }

    protected void finalize() throws Throwable {
        try {
            if (this._contentsFile != null) {
                this._contentsFile.delete();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void setContentsStatus(int contentsStatus) {
        this._contentsStatus = contentsStatus;
    }

    @Override
    public int getContentsStatus() {
        return this._contentsStatus;
    }

    @Override
    public boolean isUpdatePending() {
        boolean _pending = super.isUpdatePending();
        return _pending || this.hasContentsUpdates();
    }

    @Override
    public void checkout() throws RemoteException {
    }

    @Override
    public void checkin() throws RemoteException {
    }

    @Override
    public void uncheckout() throws RemoteException {
    }
}

