/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.dav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.RepositoryData;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.information.metadata.dav.DAVItemInterface;
import com.sas.services.information.metadata.dav.RB;
import com.sas.text.Message;
import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DAVFactory {
    private static final Logger _logger = LogManager.getLogger((String)"com.sas.services.information.metadata.dav.DAVFactory");

    public static DAVEntityInterface newDAVEntity(String objectType, String reposId, RepositoryInterface repos) {
        String objSubType = null;
        int p = objectType.lastIndexOf("/");
        if (p != -1) {
            objSubType = objectType.substring(0, p);
            objectType = objectType.substring(p + 1);
        }
        String javaClass = "com.sas.services.information.metadata.dav.DAV" + DAVFactory.capital(objectType);
        try {
            Class.forName(javaClass, false, repos.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            javaClass = "com.sas.services.information.metadata.dav.DAVItem";
        }
        try {
            ClassLoader cl = repos.getClass().getClassLoader();
            Class<?> objectClass = cl.loadClass(javaClass);
            Class[] ctorParms = new Class[]{cl.loadClass("com.sas.services.information.RepositoryInterface"), Class.forName("java.lang.String")};
            Object[] ctorArgs = new Object[]{repos, reposId};
            Constructor<?> ctor = null;
            ctor = objectClass.getConstructor(ctorParms);
            if (ctor != null) {
                DAVEntityInterface obj = (DAVEntityInterface)ctor.newInstance(ctorArgs);
                if (objSubType != null) {
                    obj.setAttribute("{http://www.sas.com/rnd/itech/WebDAV}type", objSubType);
                    obj.setContentClass(objSubType);
                }
                if (obj instanceof DAVItemInterface) {
                    DAVItemInterface di = (DAVItemInterface)obj;
                    di.setContents(new byte[0]);
                }
                return obj;
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        return null;
    }

    public static Object narrow(RepositoryData entity) {
        String javaClass;
        block8: {
            String objectType;
            if (_logger != null && _logger.isDebugEnabled()) {
                _logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVFactory.narrowing.msg.fmt", (Object)entity.getReposId()));
            }
            if ((objectType = (String)entity.get("{http://www.sas.com/rnd/itech/WebDAV}type")) == null || objectType.equalsIgnoreCase("unknown")) {
                objectType = "COLLECTION".equalsIgnoreCase((String)entity.get("{DAV:}resourcetype")) ? "folder" : "item";
            }
            if (_logger != null && _logger.isDebugEnabled()) {
                _logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVFactory.narrowto.msg.fmt", (Object)objectType));
            }
            javaClass = "com.sas.services.information.metadata.dav.DAV" + DAVFactory.capital(objectType);
            try {
                Class.forName(javaClass, false, entity.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                String oldJavaClass = javaClass;
                String resType = (String)entity.get("{DAV:}resourcetype");
                javaClass = "COLLECTION".equalsIgnoreCase(resType) ? "com.sas.services.information.metadata.dav.DAVFolder" : "com.sas.services.information.metadata.dav.DAVItem";
                if (_logger == null || !_logger.isDebugEnabled()) break block8;
                _logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVFactory.changetype.fmt.txt", (Object)oldJavaClass, (Object)javaClass));
            }
        }
        try {
            ClassLoader cl = entity.getClass().getClassLoader();
            Class<?> objectClass = cl.loadClass(javaClass);
            Class[] ctorParms = new Class[]{cl.loadClass("com.sas.services.information.RepositoryData")};
            Object[] ctorArgs = new Object[]{entity};
            Constructor<?> ctor = null;
            ctor = objectClass.getConstructor(ctorParms);
            if (ctor != null) {
                Object obj = ctor.newInstance(ctorArgs);
                return obj;
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            return null;
        }
        return null;
    }

    private static String capital(String string) {
        String left = string.substring(0, 1).toUpperCase();
        String right = string.substring(1).toLowerCase();
        return left + right;
    }
}

