/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.datalocalization;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.metadata.ColumnAttributes;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.ExtensionInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.RelationalSchemaInterface;
import com.sas.services.information.metadata.datalocalization.InvalidModelOperationException;
import com.sas.services.information.metadata.datalocalization.RB;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

public class DataLocalizationModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LOCALE_TYPE = "XV_T_LOCALE";
    public static final String LOCALE_COLUMN_EXTENSION_NAME = "LocaleColumn";
    private static final String LOCALE_COLUMN_EXTENSION_DESC = "Locale Column";
    public static final String DETAIL_TABLE_EXTENSION_NAME = "LocalizationDetailTable";
    private static final String DETAIL_TABLE_EXTENSION_DESC = "Localization Detail Table";
    public static final String DETAIL_TABLE_KEY_COLUMN_EXTENSION_NAME = "LocalizationDetailKeyColumn";
    private static final String DETAIL_TABLE_KEY_COLUMN_EXTENSION_DESC = "Localization Detail Key Column";
    private static final String DETAIL_TABLE_ASSOCIATION_NAME = "LocalizedColumns";
    private static final String DETAIL_TABLE_ASSOCIATION_PARTNER_NAME = "LocalizationDetailTable";

    public Type getModelType(DataTableInterface table) throws ServiceException, RemoteException {
        return Type.getTypeByKey(this.getExtension(table, "DataLocalizationModel"));
    }

    public DataTableInterface getDetailTable(ColumnInterface column) throws InvalidModelOperationException, ServiceException, RemoteException {
        if (this.getModelType(column.getTable()) != Type.DETAIL_TABLES) {
            throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.NotDetailTablesModel.fmt.log", (Object)column.getTable().getPathUrl().getAbsolutePath()));
        }
        Column omrColumn = (Column)column.getRepositoryEntity();
        try {
            AssociationList omrCustomAssociations = omrColumn.getReferencedObjects();
            for (CustomAssociation omrAssoc : omrCustomAssociations) {
                if (!omrAssoc.getPartnerName().equals("LocalizationDetailTable")) continue;
                DataTable omrDetailTable = (DataTable)omrAssoc.getOwningObject();
                DataTableInterface detailTable = (DataTableInterface)column.getRepository().factoryProcess(omrDetailTable);
                return detailTable;
            }
        }
        catch (ClassCastException e) {
            throw new ServiceException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        return null;
    }

    public List<ColumnInterface> getLocalizedColumns(DataTableInterface detailTable) throws InvalidModelOperationException, ServiceException, RemoteException {
        if (!this.isLocalizationDetailTable(detailTable)) {
            throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.NotADetailTable.fmt.log", (Object)detailTable.getPathUrl().getAbsolutePath()));
        }
        ArrayList<ColumnInterface> columns = new ArrayList<ColumnInterface>();
        DataTable omrTable = (DataTable)detailTable.getRepositoryEntity();
        try {
            for (CustomAssociation omrAssoc : omrTable.getCustomAssociations()) {
                if (!omrAssoc.getPartnerName().equals("LocalizationDetailTable")) continue;
                for (CMetadata omrColumn : omrAssoc.getAssociatedObjects()) {
                    if (!(omrColumn instanceof Column)) continue;
                    columns.add((ColumnInterface)detailTable.getRepository().factoryProcess(omrColumn));
                }
            }
        }
        catch (ClassCastException e) {
            throw new ServiceException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        return columns;
    }

    public ColumnInterface getKeyColumn(DataTableInterface detailTable) throws ServiceException, RemoteException {
        if (!this.isLocalizationDetailTable(detailTable)) {
            throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.NotADetailTable.fmt.log", (Object)detailTable.getPathUrl().getAbsolutePath()));
        }
        for (ColumnInterface column : detailTable.getColumns()) {
            if (this.getExtension(column, DETAIL_TABLE_KEY_COLUMN_EXTENSION_NAME) == null) continue;
            return column;
        }
        throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.NoKeyColumn.fmt.log", (Object)detailTable.getPathUrl().getAbsolutePath()));
    }

    public ColumnInterface getLocaleColumn(DataTableInterface table) throws ServiceException, RemoteException {
        ColumnInterface alternateLocaleColumn = null;
        for (ColumnInterface column : table.getColumns()) {
            String localeAttribute = this.getExtension(column, LOCALE_COLUMN_EXTENSION_NAME);
            if (localeAttribute != null && localeAttribute.equalsIgnoreCase("true")) {
                return column;
            }
            if (alternateLocaleColumn != null || !column.getColumnAttributes().getSasExtendedColumnType().equalsIgnoreCase(LOCALE_TYPE) && !column.getColumnAttributes().getSasColumnName().equalsIgnoreCase("LOCALE") && !column.getName().equalsIgnoreCase("LOCALE")) continue;
            alternateLocaleColumn = column;
        }
        if (alternateLocaleColumn != null) {
            return alternateLocaleColumn;
        }
        if (this.getModelType(table).equals((Object)Type.ROW_PER_LOCALE)) {
            throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.NoLocaleForRowModel.fmt.log", (Object)table.getPathUrl().getAbsolutePath()));
        }
        if (this.isLocalizationDetailTable(table)) {
            throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.NoLocaleColumnInDetailTable.fmt.log", (Object)table.getPathUrl().getAbsolutePath()));
        }
        return null;
    }

    public List<ColumnInterface> getValueColumns(DataTableInterface detailTable) throws ServiceException, RemoteException {
        if (!this.isLocalizationDetailTable(detailTable)) {
            throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.NotADetailTable.fmt.log", (Object)detailTable.getPathUrl().getAbsolutePath()));
        }
        ArrayList<ColumnInterface> valueColumns = new ArrayList<ColumnInterface>(detailTable.getColumns());
        valueColumns.remove(this.getKeyColumn(detailTable));
        valueColumns.remove(this.getLocaleColumn(detailTable));
        return valueColumns;
    }

    public DataTableInterface getLocalizedTable(DataTableInterface baseTable, Locale locale) throws ServiceException, RemoteException, InvalidModelOperationException {
        if (this.getModelType(baseTable) != Type.TABLE_PER_LOCALE) {
            throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.NotTableModel.fmt.log", (Object)baseTable.getPathUrl().getAbsolutePath()));
        }
        RelationalSchemaInterface schema = baseTable.getSchema();
        if (schema == null) {
            LogManager.getLogger(this.getClass()).warn(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.NotInLibrary.fmt.log", (Object)baseTable.getPathUrl().getAbsolutePath()));
            return baseTable;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        List schemaTables = schema.getTables();
        String localizedTableName = baseTable.getTableName() + "_" + locale.toString();
        for (DataTableInterface table : schemaTables) {
            if (!table.getTableName().equalsIgnoreCase(localizedTableName)) continue;
            return table;
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (variant != null && variant.length() > 0) {
            Locale newLocale = new Locale(language, country);
            localizedTableName = baseTable.getTableName() + "_" + newLocale.toString();
            for (DataTableInterface table : schemaTables) {
                if (!table.getTableName().equalsIgnoreCase(localizedTableName)) continue;
                return table;
            }
        }
        if (country != null && country.length() > 0 && language != null && language.length() > 0) {
            localizedTableName = baseTable.getTableName() + "_" + language;
            for (DataTableInterface table : schemaTables) {
                if (!table.getTableName().equalsIgnoreCase(localizedTableName)) continue;
                return table;
            }
        }
        return baseTable;
    }

    public boolean isLocalizationDetailTable(DataTableInterface table) throws ServiceException, RemoteException {
        return this.getExtension(table, "LocalizationDetailTable") != null;
    }

    public void markLocaleColumn(ColumnInterface column) throws ServiceException, RemoteException {
        ColumnAttributes attr = column.getColumnAttributes();
        attr.setSasExtendedColumnType(LOCALE_TYPE);
        column.setColumnAttributes(attr);
        this.setExtension(column, LOCALE_COLUMN_EXTENSION_NAME, "true", LOCALE_COLUMN_EXTENSION_DESC);
    }

    public void unmarkLocaleColumn(ColumnInterface column) throws ServiceException, RemoteException {
        ColumnAttributes attr = column.getColumnAttributes();
        if (attr.getSasExtendedColumnType().equals(LOCALE_TYPE)) {
            attr.setSasExtendedColumnType("");
            column.setColumnAttributes(attr);
        }
        this.deleteExtension(column, LOCALE_COLUMN_EXTENSION_NAME);
    }

    public void markLocalizationDetailTable(DataTableInterface table, ColumnInterface keyColumn, ColumnInterface localeColumn) throws ServiceException, RemoteException, InvalidModelOperationException {
        if (table.getColumns().size() < 3) {
            throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.NotValidDetailTable.fmt.log", (Object)table.getPathUrl().getAbsolutePath()));
        }
        if (localeColumn != null) {
            if (localeColumn.getTable() != table) {
                throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.LocaleColumnInWrongTable.fmt.log", (Object)localeColumn.getName(), (Object)table.getPathUrl().getAbsolutePath()));
            }
            this.markLocaleColumn(localeColumn);
        } else {
            localeColumn = this.getLocaleColumn(table);
            if (localeColumn == null) {
                throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.NoLocaleColumnInDetailTable.fmt.log", (Object)table.getPathUrl().getAbsolutePath()));
            }
        }
        if (keyColumn != null) {
            if (keyColumn.getTable() != table) {
                throw new InvalidModelOperationException(Message.format((ResourceBundle)RB.getResources(), (String)"DataLocalizationModel.KeyColumnInWrongTable.fmt.log", (Object)keyColumn.getName(), (Object)table.getPathUrl().getAbsolutePath()));
            }
            this.setExtension(keyColumn, DETAIL_TABLE_KEY_COLUMN_EXTENSION_NAME, "true", DETAIL_TABLE_KEY_COLUMN_EXTENSION_DESC);
        } else {
            keyColumn = this.getKeyColumn(table);
            if (keyColumn == null) {
                throw new InvalidModelOperationException("No key column found in detail table.");
            }
        }
        this.setExtension(table, "LocalizationDetailTable", "true", DETAIL_TABLE_EXTENSION_DESC);
        for (ColumnInterface column : table.getColumns()) {
            if (column != keyColumn) {
                this.deleteExtension(column, DETAIL_TABLE_KEY_COLUMN_EXTENSION_NAME);
            }
            if (column == localeColumn) continue;
            this.deleteExtension(column, LOCALE_COLUMN_EXTENSION_NAME);
        }
    }

    public void unmarkLocalizationDetailTable(DataTableInterface table) throws ServiceException, RemoteException {
        for (ColumnInterface column : this.getLocalizedColumns(table)) {
            this.setDetailTable(column, null);
        }
        this.deleteExtension(table, "LocalizationDetailTable");
        for (ColumnInterface column : table.getColumns()) {
            this.deleteExtension(column, DETAIL_TABLE_KEY_COLUMN_EXTENSION_NAME);
            this.deleteExtension(column, LOCALE_COLUMN_EXTENSION_NAME);
        }
    }

    public void setModelType(DataTableInterface table, Type type) throws ServiceException, RemoteException {
        this.setModelTypeKey(table, type);
        if (!type.equals((Object)Type.DETAIL_TABLES)) {
            for (ColumnInterface column : table.getColumns()) {
                this.setDetailTable(column, null);
            }
        }
    }

    public void setDetailTable(ColumnInterface column, DataTableInterface detailTable) throws ServiceException, RemoteException {
        if (detailTable != null) {
            if (this.getModelType(column.getTable()) != Type.DETAIL_TABLES) {
                throw new InvalidModelOperationException("Detail tables may be set only for the DETAIL_TABLES model.");
            }
            if (!this.isLocalizationDetailTable(detailTable)) {
                throw new InvalidModelOperationException("Table is not a localization detail table.");
            }
        }
        Column omrColumn = (Column)column.getRepositoryEntity();
        try {
            DataTableInterface oldDetailTable = null;
            AssociationList omrReferencedObjects = omrColumn.getReferencedObjects();
            ArrayList<CustomAssociation> associationsToDelete = new ArrayList<CustomAssociation>();
            for (CustomAssociation omrAssoc : omrReferencedObjects) {
                if (!"LocalizationDetailTable".equals(omrAssoc.getPartnerName())) continue;
                DataTable omrDetailTable = (DataTable)omrAssoc.getOwningObject();
                oldDetailTable = (DataTableInterface)column.getRepository().factoryProcess(omrDetailTable);
                if (oldDetailTable == detailTable) continue;
                associationsToDelete.add(omrAssoc);
            }
            omrReferencedObjects.removeAll(associationsToDelete);
            if (detailTable != null && detailTable != oldDetailTable) {
                DataTable omrDetailTable = (DataTable)detailTable.getRepositoryEntity();
                CustomAssociation omrLocalizationAssociation = null;
                AssociationList omrCustomAssociations = omrDetailTable.getCustomAssociations();
                for (CustomAssociation omrAssoc : omrCustomAssociations) {
                    if (!DETAIL_TABLE_ASSOCIATION_NAME.equals(omrAssoc.getName())) continue;
                    omrLocalizationAssociation = omrAssoc;
                    break;
                }
                if (omrLocalizationAssociation == null) {
                    omrLocalizationAssociation = (CustomAssociation)((OMIRepositoryInterface)detailTable.getRepository()).createMetadata(DETAIL_TABLE_ASSOCIATION_NAME, "CustomAssociation");
                    omrLocalizationAssociation.setPartnerName("LocalizationDetailTable");
                    omrLocalizationAssociation.setOwningObject((Root)omrDetailTable);
                    omrLocalizationAssociation.setisOwned(0);
                }
                omrLocalizationAssociation.getAssociatedObjects().add((Object)omrColumn);
            }
        }
        catch (ClassCastException e) {
            throw new ServiceException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    private void setModelTypeKey(DataTableInterface table, Type type) throws ServiceException, RemoteException {
        if (type == null || type.equals((Object)Type.NONE)) {
            this.deleteExtension(table, "DataLocalizationModel");
        } else {
            this.setExtension(table, "DataLocalizationModel", type.getKey(), "Data Localization Model Type");
        }
    }

    private String getExtension(MetadataInterface object, String extensionName) throws ServiceException, RemoteException {
        List extensions = object.getExtensions();
        for (ExtensionInterface extension : extensions) {
            if (!extension.getName().equals(extensionName)) continue;
            return extension.getValue();
        }
        return null;
    }

    private void deleteExtension(MetadataInterface object, String extensionName) throws ServiceException, RemoteException {
        List extensions = object.getExtensions();
        for (ExtensionInterface extension : extensions) {
            if (!extension.getName().equals(extensionName)) continue;
            extension.delete();
            return;
        }
    }

    private void setExtension(MetadataInterface object, String extensionName, String extensionValue, String extensionDesc) throws ServiceException, RemoteException {
        List extensions = object.getExtensions();
        for (ExtensionInterface extension : extensions) {
            if (!extension.getName().equals(extensionName)) continue;
            extension.setValue(extensionValue);
            return;
        }
        Extension extension = (Extension)((OMIRepositoryInterface)object.getRepository()).createMetadata(extensionName, "Extension");
        extension.setValue(extensionValue);
        if (extensionDesc != null) {
            extension.setDesc(extensionDesc);
        }
        extension.setOwningObject((Root)object.getRepositoryEntity());
    }

    public static enum Type {
        NONE("NONE"),
        ROW_PER_LOCALE("ROW_PER_LOCALE"),
        TABLE_PER_LOCALE("TABLE_PER_LOCALE"),
        DETAIL_TABLES("DETAIL_TABLES"),
        CUSTOM("CUSTOM");

        public static final String KEY_NAME = "DataLocalizationModel";
        static final String KEY_DESC = "Data Localization Model Type";
        private String key;

        private Type(String key) {
            this.key = key;
        }

        public static void sample() throws ServiceException, RemoteException {
            DataLocalizationModel model = new DataLocalizationModel();
            Locale locale = null;
            DataTableInterface table = null;
            if (model.getModelType(table).equals((Object)TABLE_PER_LOCALE)) {
                table = model.getLocalizedTable(table, locale);
            }
        }

        public String getKey() {
            return this.key;
        }

        public static Type getTypeByKey(String key) {
            if (key == null) {
                return NONE;
            }
            for (Type type : Type.values()) {
                if (!key.equals(type.getKey())) continue;
                return type;
            }
            return CUSTOM;
        }
    }
}

