/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.ContentInfo;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.VirtualFolderInterface;
import com.sas.services.information.metadata.VirtualMetadata;
import com.sas.services.information.publicobject.DetailsProcessor;
import com.sas.services.information.publicobject.ProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.util.TypeMapper;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class VirtualFolder
extends VirtualMetadata
implements VirtualFolderInterface,
Serializable {
    private static final long serialVersionUID = 6042243829317209820L;
    private static final String FOLDER_TYPE = "VirtualFolder";
    protected FolderInterface _parentFolder;
    protected RepositoryInterface _repository;
    protected Search _searchManager;
    protected Map<String, ProcessorInterface> _actionInterfaces = new HashMap<String, ProcessorInterface>(1);
    protected List<PublicObjectInterface> _members = null;
    protected List<VirtualFolderInterface> _subFolders = null;
    protected String _name = null;
    protected String _id = null;
    protected List<SearchFilter> _origSearchFilters = null;

    VirtualFolder(String id, String name, FolderInterface parentFolder) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._id = id;
        this._name = name;
        this._parentFolder = parentFolder;
    }

    @Override
    public String getIdentifier() throws ServiceException, RemoteException {
        return this.getReposId();
    }

    @Override
    public String getReposId() throws RemoteException {
        return this._id;
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        if (this._members != null) {
            this._members = null;
        }
    }

    @Override
    public String getName() throws RemoteException {
        return this._name;
    }

    @Override
    public Search getSearchManager() throws ServiceException, RemoteException {
        return this._searchManager;
    }

    public void setSearchManager(Search search) throws ServiceException, RemoteException {
        this._searchManager = search;
        this._origSearchFilters = new ArrayList<SearchFilter>(search.getFilters());
    }

    protected List<SearchFilter> getOriginalFilters() {
        return this._origSearchFilters;
    }

    @Override
    public RepositoryInterface getRepository() throws RemoteException {
        return this._repository;
    }

    @Override
    public void setRepository(RepositoryInterface repository) throws IllegalStateException, RemoteException {
        this._repository = repository;
    }

    @Override
    public PublicObjectContainerInterface getContainer() throws ServiceException, RemoteException {
        return this._parentFolder;
    }

    @Override
    public FolderInterface getParent() throws ServiceException, RemoteException {
        return this._parentFolder;
    }

    @Override
    public String getPath() throws RemoteException {
        String parentPath = this._parentFolder.getPath();
        return parentPath + "/" + this.getName();
    }

    @Override
    public PathUrl getPathUrl() throws IllegalStateException, ServiceException, RemoteException {
        if (this._repository != null) {
            ServerInterface server = this._repository.getServer();
            PathUrl path = PathUrl.newPathUrlFromAbsolutePath(server, this.getPath());
            if (path.getType() == null) {
                path.setType("Folder");
            }
            return path;
        }
        return null;
    }

    @Override
    public String getType() throws RemoteException {
        return "Folder.Virtual";
    }

    @Override
    public TypeDescriptorInterface getTypeDescriptor() throws ServiceException, RemoteException {
        if (this._repository == null) {
            return null;
        }
        TypeDescriptorInterface tdi = this._repository.getServer().getTypeDescriptor(this.getType());
        return tdi;
    }

    @Override
    public String getFolderType() throws ServiceException, RemoteException {
        return FOLDER_TYPE;
    }

    @Override
    public ProcessorInterface getProcessorInterface(String interfaceClassName) throws ServiceException, RemoteException {
        ProcessorInterface returnValue = null;
        if ("com.sas.services.information.publicobject.DetailsProcessorInterface".equals(interfaceClassName)) {
            ProcessorInterface action = this._actionInterfaces.get(interfaceClassName);
            if (action != null && action instanceof ProcessorInterface) {
                returnValue = action;
            } else {
                returnValue = new VirtualFolderDetailsProcessor(this);
                this.addProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface", returnValue);
            }
        }
        return returnValue;
    }

    @Override
    public MetadataInterface getItem(String name) throws ServiceException, RemoteException {
        return this.getItemByType(name, null);
    }

    @Override
    public MetadataInterface getPublicTypeItem(String name, String type) throws ServiceException, RemoteException {
        if (name == null) {
            return null;
        }
        name = name.trim();
        TypeDescriptorInterface tdi = this._repository.getServer().getTypeDescriptor(type);
        if (tdi == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.notpublictype.ex.txt.fmt", (Object)type));
        }
        List<PublicObjectInterface> children = this.getChildren();
        for (PublicObjectInterface child : children) {
            if (!name.equalsIgnoreCase(child.getName()) || !tdi.getTypeName().equals(child.getTypeDescriptor().getTypeName())) continue;
            return this.getSmartObject(child);
        }
        return null;
    }

    @Override
    public MetadataInterface getItemByClass(String name, Class itemClass) throws ServiceException, RemoteException {
        if (name == null) {
            return null;
        }
        name = name.trim();
        List<PublicObjectInterface> children = this.getChildren();
        for (PublicObjectInterface child : children) {
            if (!name.equalsIgnoreCase(child.getName())) continue;
            MetadataInterface meta = this.getSmartObject(child);
            if (itemClass != null && !itemClass.isInstance(meta)) continue;
            return meta;
        }
        return null;
    }

    @Override
    public MetadataInterface getItemByType(String name, String publicType) throws ServiceException, RemoteException {
        if (name == null) {
            return null;
        }
        name = name.trim();
        List<PublicObjectInterface> children = this.getChildren();
        for (PublicObjectInterface child : children) {
            if (!name.equalsIgnoreCase(child.getName())) continue;
            if (publicType == null) {
                return this.getSmartObject(child);
            }
            TypeDescriptorInterface type = child.getTypeDescriptor();
            if (type == null || !TypeMapper.isMapped(publicType, type.getTypeName())) continue;
            return this.getSmartObject(child);
        }
        return null;
    }

    @Override
    public List<MetadataInterface> getItems() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>();
        List<PublicObjectInterface> children = this.getChildren();
        for (PublicObjectInterface child : children) {
            MetadataInterface meta = this.getSmartObject(child);
            if (meta == null) continue;
            results.add(meta);
        }
        return results;
    }

    @Override
    public List<MetadataInterface> getItemsByClass(Class itemClass) throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>();
        List<PublicObjectInterface> children = this.getChildren();
        for (PublicObjectInterface child : children) {
            MetadataInterface meta = this.getSmartObject(child);
            if (itemClass != null && !itemClass.isInstance(meta)) continue;
            results.add(meta);
        }
        return results;
    }

    @Override
    public List<MetadataInterface> getItemsByType(String metadataType) throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>();
        List<PublicObjectInterface> children = this.getChildren();
        for (PublicObjectInterface child : children) {
            MetadataInterface meta;
            TypeDescriptorInterface type = child.getTypeDescriptor();
            if (type == null || !TypeMapper.isMapped(metadataType, type.getTypeName()) || (meta = this.getSmartObject(child)) == null) continue;
            results.add(meta);
        }
        return results;
    }

    private MetadataInterface getSmartObject(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        if (this._searchManager != null) {
            ServerInterface server = this._searchManager.getServer();
            TypeDescriptorInterface type = publicObject.getTypeDescriptor();
            if (type != null) {
                String key = publicObject.getIdentifier() + "/" + type.getMetadataType();
                return server.fetch(key, true);
            }
        }
        return null;
    }

    @Override
    public void addSubfolder(VirtualFolderInterface folder) throws ServiceException, RemoteException {
        if (this._subFolders == null) {
            this._subFolders = new ArrayList<VirtualFolderInterface>(4);
        }
        if (!this._subFolders.contains(folder)) {
            this._subFolders.add(folder);
        }
    }

    @Override
    public FolderInterface getSubfolder(String name) throws ServiceException, RemoteException {
        if (this._subFolders != null) {
            for (VirtualFolderInterface folder : this._subFolders) {
                if (!name.equalsIgnoreCase(folder.getName())) continue;
                return folder;
            }
        }
        return null;
    }

    @Override
    public List getSubfolders() throws ServiceException, RemoteException {
        return this._subFolders == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this._subFolders);
    }

    @Override
    public int getTotalNumberOfItems() throws RemoteException, ServiceException {
        return this.getChildCount();
    }

    @Override
    public boolean hasDuplicate(String name, String type) throws ServiceException, RemoteException {
        if (name == null || type == null) {
            return false;
        }
        List<PublicObjectInterface> children = this.getChildren();
        for (PublicObjectInterface child : children) {
            TypeDescriptorInterface typeDesc;
            if (!name.equalsIgnoreCase(child.getName()) || (typeDesc = child.getTypeDescriptor()) == null || !TypeMapper.isMapped(type, typeDesc.getTypeName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasDuplicateSubfolder(String name) throws ServiceException, RemoteException {
        if (this._subFolders != null) {
            for (VirtualFolderInterface folder : this._subFolders) {
                if (!name.equalsIgnoreCase(folder.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() throws ServiceException, RemoteException {
        return this.getChildCount() == 0;
    }

    @Override
    public boolean isItemNameUnique(MetadataInterface member) throws ServiceException, RemoteException {
        return true;
    }

    @Override
    public void addChild(PublicObjectInterface newChild) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<PublicObjectInterface> getChildren() throws ServiceException, RemoteException {
        List<SearchFilter> filters;
        ArrayList<PublicObjectInterface> children = new ArrayList<PublicObjectInterface>();
        if (this._subFolders != null) {
            children.addAll(this._subFolders);
        }
        if (this._searchManager != null && (filters = this._searchManager.getFilters()) != null && !filters.isEmpty()) {
            if (this._members == null) {
                this._members = this._searchManager.search();
            }
            children.addAll(this._members);
        }
        return children;
    }

    @Override
    public int getChildCount() throws ServiceException, RemoteException {
        int size = 0;
        if (this._subFolders != null) {
            size += this._subFolders.size();
        }
        if (this._members != null) {
            size += this._members.size();
        }
        return size;
    }

    public String toString() {
        try {
            return this.getFolderType() + ": " + this.getName();
        }
        catch (Exception e) {
            return "RemoteException";
        }
    }

    @Override
    public void removeChild(PublicObjectInterface child) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertChild(PublicObjectInterface child, int index) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PublicObjectInterface getChildAt(int index) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getChildren(String type) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PublicObjectInterface newChild(String type, String name) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getItemSublist(int start, int end) throws RemoteException, ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getItemSublist(int start, int end, String sort) throws RemoteException, ServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FolderInterface makeSubfolder(String name, String type) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FolderInterface makeSubfolder(String name) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addItem(MetadataInterface item) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MetadataInterface addNewItem(String name, String type) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSubfolder(FolderInterface folder) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteItem(MetadataInterface item) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteSubfolder(String name) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getContentCreateDate() throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContentInfo getContentInfo() throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getContentModifyDate() throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean moveMembersOnOverflow() throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeItem(MetadataInterface item) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSubfolder(String name) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContentCreateDate(Date date) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContentModifyDate(Date date) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFolderType(String type) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @SASScope
    protected class VirtualFolderDetailsProcessor
    extends DetailsProcessor {
        public VirtualFolderDetailsProcessor(VirtualFolderInterface publicObject) {
            super(publicObject);
        }
    }
}

