/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.metadata.PersonInterface;
import java.rmi.RemoteException;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class SubscriberFilter
extends Filter {
    private static final long serialVersionUID = 1171286300641063085L;
    private PersonInterface _person;

    public SubscriberFilter() {
    }

    public SubscriberFilter(String key, int relation, String value) {
        super(key, relation, value);
        this.setType("Subscriber");
    }

    public void setPerson(PersonInterface person) {
        this._person = person;
    }

    @Override
    public String getOMRType() {
        return "Subscriber";
    }

    public String getLDAPType() {
        return "sassubscriber";
    }

    @Override
    public String getXMLSelectString() {
        FilterComponent compy = this._component;
        String personId = null;
        if (this._person != null) {
            try {
                personId = this._person.getReposId();
            }
            catch (RemoteException rex) {
                personId = "RemoteException";
            }
            FilterComponent personComp = new FilterComponent("Id", 0, personId);
            if (compy != null) {
                personComp.addComponent(compy);
                personComp.setAggregation(0);
            }
            this.setFilterComponent(personComp);
        }
        String result = super.getXMLSelectString();
        this.setFilterComponent(compy);
        return result;
    }

    @Override
    public String getDAVBasicSearchString() {
        return "UNSUPPORTED";
    }

    @Override
    public String getDAVSQLString() {
        return "UNSUPPORTED";
    }
}

