/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.IndexInterface;
import com.sas.services.information.metadata.KeyAssociationInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RelationalKeyInterface;
import com.sas.services.information.metadata.RelationalTableInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@SASScope
class SmartUtils {
    public static final String PREFIX_INDEX = "Index";

    SmartUtils() {
    }

    static void validateDuplicates(List listMetadata) throws RemoteException, ServiceException {
        try {
            if ((listMetadata == null || listMetadata.size() == 0) && listMetadata.get(0) instanceof ColumnInterface) {
                throw new MdException(RB.getStringResource("SmartUtils.validateDuplicates.emptyColumn.txt"));
            }
            HashSet<String> mdNames = new HashSet<String>(listMetadata.size());
            for (Object mi : listMetadata) {
                mdNames.add(((MetadataInterface)mi).getName());
            }
            if (listMetadata.size() > mdNames.size() && listMetadata.get(0) instanceof ColumnInterface) {
                throw new MdException(RB.getStringResource("SmartUtils.validateDuplicates.column.txt"));
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    static void validateDuplicates(String name, List listMetadata) throws RemoteException, ServiceException {
        HashSet<String> mdNames = new HashSet<String>(listMetadata.size());
        try {
            for (Object mi : listMetadata) {
                mdNames.add(((MetadataInterface)mi).getName());
            }
            if (mdNames.contains(name)) {
                if (listMetadata.get(0) instanceof ColumnInterface) {
                    throw new MdException(RB.getStringResource("SmartUtils.validateDuplicates.addColumn.txt"));
                }
                if (listMetadata.get(0) instanceof KeyAssociationInterface) {
                    throw new MdException(RB.getStringResource("SmartUtils.validateDuplicates.addKeyAssoc.txt"));
                }
                if (listMetadata.get(0) instanceof IndexInterface) {
                    throw new MdException(RB.getStringResource("SmartUtils.validateDuplicates.createIndex.txt"));
                }
                throw new MdException(RB.getStringResource("SmartUtils.validateDuplicates.createObject.txt"));
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    static void validateRemoveObject(List listMetadata) throws RemoteException, ServiceException {
        try {
            if (listMetadata.size() <= 1) {
                if (listMetadata.get(0) instanceof ColumnInterface) {
                    throw new MdException(RB.getStringResource("SmartUtils.validateRemoveObject.column.txt"));
                }
                if (listMetadata.get(0) instanceof KeyAssociationInterface) {
                    throw new MdException(RB.getStringResource("SmartUtils.validateRemoveObject.keyAssoc.txt"));
                }
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    static void validateRemoveObject(List listMetadata, List listDeleteMetadata) throws RemoteException, ServiceException {
        try {
            if (listDeleteMetadata.size() >= listMetadata.size() && listMetadata.get(0) instanceof ColumnInterface) {
                throw new MdException(RB.getStringResource("SmartUtils.validateRemoveObject.listColumn.txt"));
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    static void validatePrimaryKeyColumns(List<ColumnInterface> listColumns) throws RemoteException, ServiceException {
        try {
            for (ColumnInterface ci : listColumns) {
                if (!ci.getColumnAttributes().isNullable()) continue;
                throw new MdException(RB.getStringResource("SmartUtils.validatePrimaryKeyColumns.txt"));
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    static void validatePrimaryKeyExist(RelationalTableInterface relationalTable) throws RemoteException, ServiceException {
        try {
            if (null != relationalTable.getPrimaryKey()) {
                throw new MdException(RB.getStringResource("SmartUtils.validatePrimaryKeyExist.txt"));
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    static void validateMatchingPrimaryKeyExist(RelationalTableInterface relationalTable, List<ColumnInterface> listColumns) throws RemoteException, ServiceException {
        try {
            List<ColumnInterface> listPKColumns;
            RelationalKeyInterface primaryKey = relationalTable.getPrimaryKey();
            if (null != primaryKey && (listPKColumns = primaryKey.getColumns()).size() == listColumns.size()) {
                boolean matchingPKExist = true;
                for (int i = 0; i < listPKColumns.size(); ++i) {
                    if (listPKColumns.get(i).getIdentifier().equalsIgnoreCase(listColumns.get(i).getIdentifier())) continue;
                    matchingPKExist = false;
                    break;
                }
                if (matchingPKExist) {
                    throw new MdException(RB.getStringResource("SmartUtils.validateMatchingPrimaryKeyExist.txt"));
                }
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    static void validateMatchingUniqueKeyExist(RelationalTableInterface relationalTable, List<ColumnInterface> listColumns) throws RemoteException, ServiceException {
        try {
            List<RelationalKeyInterface> listUniqueKeys = relationalTable.getUniqueKeys();
            for (RelationalKeyInterface uniqueKey : listUniqueKeys) {
                List<ColumnInterface> listUKColumns = uniqueKey.getColumns();
                if (listUKColumns.size() != listColumns.size()) continue;
                boolean matchingUKExist = true;
                for (int i = 0; i < listUKColumns.size(); ++i) {
                    if (listUKColumns.get(i).getIdentifier().equalsIgnoreCase(listColumns.get(i).getIdentifier())) continue;
                    matchingUKExist = false;
                    break;
                }
                if (!matchingUKExist) continue;
                throw new MdException(RB.getStringResource("SmartUtils.validateMatchingUniqueKeyExist.txt"));
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    static void validateAddColumnToSimpleIndex(IndexInterface index) throws RemoteException, ServiceException {
        try {
            if (index.getColumns().size() == 1) {
                throw new MdException(Message.format((String)RB.getStringResource("SmartUtils.validateAddColumnToSimpleIndex.txt"), (Object)index.getName()));
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    static void validateRemoveColumnsFromIndex(IndexInterface index, int noOfColumnToDelete) throws RemoteException, ServiceException {
        try {
            int noOfIndexColumns = index.getColumns().size();
            if (noOfIndexColumns - noOfColumnToDelete == 1) {
                throw new MdException(Message.format((String)RB.getStringResource("SmartUtils.validateRemoveColumnsFromIndex.simpleIndex.txt"), (Object)index.getName()));
            }
            if (noOfIndexColumns - noOfColumnToDelete <= 0) {
                throw new MdException(Message.format((String)RB.getStringResource("SmartUtils.validateRemoveColumnsFromIndex.emptyIndex.txt"), (Object)index.getName()));
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    static IndexInterface searchIndex(PhysicalTableInterface table, List<ColumnInterface> columns) throws RemoteException, ServiceException {
        List<IndexInterface> listIndexes = table.getIndexes();
        List<ColumnInterface> listIndexColumns = null;
        boolean indexExist = false;
        for (IndexInterface index : listIndexes) {
            listIndexColumns = index.getColumns();
            if (listIndexColumns.size() != columns.size()) continue;
            indexExist = true;
            for (int i = 0; i < listIndexColumns.size(); ++i) {
                if (listIndexColumns.get(i).getIdentifier().equalsIgnoreCase(columns.get(i).getIdentifier())) continue;
                indexExist = false;
                break;
            }
            if (!indexExist) continue;
            return index;
        }
        return null;
    }

    static String generateIndexName(PhysicalTableInterface table) throws RemoteException, ServiceException {
        List<IndexInterface> listIndex = table.getIndexes();
        HashSet<String> names = new HashSet<String>(listIndex.size());
        for (IndexInterface i : listIndex) {
            names.add(i.getName());
        }
        int cnt = 1;
        while (SmartUtils.isNameExist(names, PREFIX_INDEX + cnt++)) {
        }
        return PREFIX_INDEX + cnt;
    }

    static boolean isNameExist(Set<String> names, String indexName) {
        for (String name : names) {
            if (!name.equalsIgnoreCase(indexName)) continue;
            return true;
        }
        return false;
    }
}

