/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.services.ServiceException;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ServerSubPropsHandler {
    private ServerContextInterface applicationServer;
    private PropertyList properties;
    static final String PROPERTY_SUFFIX_COMMAND = "Command";
    static final String PROPERTY_SUFFIX_CONNECTIONSTR = "ConnectionString";
    static final String PROPERTY_SUFFIX_PATH = "DirPath";
    static final String PROPERTY_SUFFIX_HTTPADDRESS = "HttpAddress";
    static final String PROPERTY_SUFFIX_CONFIGURATIONPROPERTY = "ConfigurationXML";
    private static final String PROPERTY_CONTEXT_NAME = "Server";
    private Map<String, List<SubstitutionProperty>> subProps;
    private HandlerType handlerType;
    private static Map<String, String> commandPropNames = new HashMap<String, String>(2);
    private static Map<String, String> connectioStrPropNames = new HashMap<String, String>(2);
    private static Map<String, String> hostServerPropNames = new HashMap<String, String>(1);
    private static Map<String, String> portPropNames = new HashMap<String, String>(2);
    private static Map<String, List<String>> httpAddressPropNames;
    private static Map<String, String> pathPropNames;
    private static List<String> multiHostDeploymentServers;
    private static List<String> associatedMachineServers;
    private static List<String> databaseServers;
    private static List<String> schedulingServers;
    private static List<String> contentServers;
    private static List<String> sasServers;
    private static List<String> easServers;
    private static List<String> monitoringServers;
    private static List<String> cloudServer;
    private static List<String> noportsubServers;
    private List<ServerComponentInterface> servers;

    private ServerSubPropsHandler(ServerContextInterface server, HandlerType type) {
        this.applicationServer = server;
        this.subProps = new HashMap<String, List<SubstitutionProperty>>();
        this.properties = new PropertyList();
        this.handlerType = type;
    }

    static ServerSubPropsHandler getInstanceForFetching(ServerContextInterface serverContext) {
        return new ServerSubPropsHandler(serverContext, HandlerType.EXPORT);
    }

    static ServerSubPropsHandler getInstanceToStore(ServerContextInterface serverContext) {
        return new ServerSubPropsHandler(serverContext, HandlerType.IMPORT);
    }

    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        if (!this.handlerType.equals((Object)HandlerType.EXPORT)) {
            throw new IllegalStateException("");
        }
        try {
            this.populateSubPropsList();
        }
        catch (RemoteException exception) {
            throw new UnexpectedSubstitutionException((Throwable)exception);
        }
        catch (ServiceException exception) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)exception));
        }
        return this.properties;
    }

    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        try {
            this.addHostProperties(map, null, 0);
            this.addCommandProperties(map, null, 0);
            this.addConnectionStrProperties(map, null, 0);
            this.addPortProperties(map, null, 0);
            this.addPathProperties(map, null, 0);
            this.assignProperties();
        }
        catch (RemoteException exception) {
            throw new UnexpectedSubstitutionException((Throwable)exception);
        }
        catch (ServiceException exception) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)exception));
        }
    }

    private void assignProperties() throws RemoteException, ServiceException {
        if (this.subProps != null) {
            String serverName = null;
            Iterator<String> serverNames = this.subProps.keySet().iterator();
            List<SubstitutionProperty> subProperties = null;
            PropertyList propList = null;
            ServerComponentInterface server = null;
            while (serverNames.hasNext()) {
                serverName = serverNames.next();
                propList = new PropertyList();
                subProperties = this.subProps.get(serverName);
                this.populatePropertyList(propList, subProperties);
                server = this.searchServer(serverName);
                if (server == null || !(server instanceof SubstitutionProperties)) continue;
                ((SubstitutionProperties)server).setSubstitutionProperties(propList.getMap());
            }
        }
    }

    private void populatePropertyList(PropertyList subValues, List<SubstitutionProperty> subProperties) {
        for (SubstitutionProperty subProp : subProperties) {
            subValues.addProperty(subProp.getName(), subProp.getIndex(), subProp.getValue());
        }
    }

    private ServerComponentInterface searchServer(String serverName) throws RemoteException, ServiceException {
        if (this.servers == null) {
            this.servers = this.getServerComponents();
        }
        for (ServerComponentInterface server : this.servers) {
            if (!server.getName().equalsIgnoreCase(serverName)) continue;
            return server;
        }
        return null;
    }

    private void populateSubPropsList() throws RemoteException, ServiceException {
        List<ServerComponentInterface> servers = null;
        PropertyMap propertyMap = null;
        int hostIndex = 0;
        int commandIndex = 0;
        int constrIndex = 0;
        int pathIndex = 0;
        int portIndex = 0;
        servers = this.getServerComponents();
        if (servers != null) {
            for (ServerComponentInterface server : servers) {
                if (!(server instanceof SubstitutionProperties)) continue;
                propertyMap = ((SubstitutionProperties)server).getSubstitutionProperties().getMap();
                hostIndex = this.addHostProperties(propertyMap, server, hostIndex);
                commandIndex = this.addCommandProperties(propertyMap, server, commandIndex);
                constrIndex = this.addConnectionStrProperties(propertyMap, server, constrIndex);
                pathIndex = this.addPathProperties(propertyMap, server, pathIndex);
                portIndex = this.addPortProperties(propertyMap, server, portIndex);
            }
            this.createAllSubPropList();
        }
    }

    private void createAllSubPropList() {
        if (this.subProps != null) {
            for (String propName : this.subProps.keySet()) {
                this.properties.addBlankLine();
                boolean added = this.createSubstitutionList(propName);
                if (!added) continue;
                this.createContextSubstitutionList(propName);
            }
        }
    }

    private int addHostProperties(PropertyMap map, ServerComponentInterface server, int index) throws RemoteException, ServiceException {
        return this.addProperties(map, "Host", server, index);
    }

    private int addCommandProperties(PropertyMap map, ServerComponentInterface server, int index) throws RemoteException, ServiceException {
        return this.addProperties(map, PROPERTY_SUFFIX_COMMAND, server, index);
    }

    private int addConnectionStrProperties(PropertyMap map, ServerComponentInterface server, int index) throws RemoteException, ServiceException {
        return this.addProperties(map, PROPERTY_SUFFIX_CONNECTIONSTR, server, index);
    }

    private int addPathProperties(PropertyMap map, ServerComponentInterface server, int index) throws RemoteException, ServiceException {
        return this.addProperties(map, PROPERTY_SUFFIX_PATH, server, index);
    }

    private int addPortProperties(PropertyMap map, ServerComponentInterface server, int index) throws RemoteException, ServiceException {
        return this.addProperties(map, "Port", server, index);
    }

    private int addProperties(PropertyMap map, String propertyName, ServerComponentInterface server, int index) throws RemoteException, ServiceException {
        String[] propNames = map.getPropertiesBySuffix(propertyName);
        String propValue = null;
        String typeName = null;
        String contextName = null;
        List<String> contextNames = null;
        SubstitutionProperty subProp = null;
        if (propNames != null) {
            for (String propName : propNames) {
                propValue = map.getProperty(propName);
                if (this.handlerType.equals((Object)HandlerType.EXPORT)) {
                    typeName = this.getServerYype(server);
                    contextName = server.getName();
                    subProp = new SubstitutionProperty(propertyName, propValue, typeName + " " + PROPERTY_CONTEXT_NAME);
                    subProp.setIndex(++index);
                    subProp.addServerName(contextName);
                    boolean added = this.addSubProperty(subProp, propertyName, server.getName());
                    if (added) continue;
                    --index;
                    continue;
                }
                contextNames = this.getServerNames(map, propName);
                if (contextNames == null) continue;
                for (String context : contextNames) {
                    subProp = new SubstitutionProperty(propertyName, propValue, typeName);
                    subProp.addServerName(context);
                    subProp.setIndex(this.getImportSideIndex(subProp));
                    this.addSubProperty(subProp, context, null);
                }
            }
        }
        return index;
    }

    private int getImportSideIndex(SubstitutionProperty property) {
        int index = 1;
        String contextName = property.getContexts().get(0);
        if (this.subProps.containsKey(contextName)) {
            List<SubstitutionProperty> props = this.subProps.get(contextName);
            for (SubstitutionProperty prop : props) {
                if (!prop.equalsByName(property)) continue;
                ++index;
            }
        }
        return index;
    }

    private List<String> getServerNames(PropertyMap map, String propName) {
        String contextPropNamePrefix = propName + "." + PROPERTY_CONTEXT_NAME;
        String[] contextPropNames = map.getPropertiesBySuffix(contextPropNamePrefix);
        String contextName = null;
        ArrayList<String> serverNames = null;
        if (contextPropNames != null) {
            serverNames = new ArrayList<String>(contextPropNames.length);
            for (String contextPropName : contextPropNames) {
                contextName = map.getProperty(contextPropName);
                if (map.containsProperty(contextName)) {
                    contextName = map.getProperty(contextName);
                }
                serverNames.add(contextName);
            }
        }
        return serverNames;
    }

    private boolean createSubstitutionList(String typeName) {
        List<SubstitutionProperty> subProps = this.subProps.get(typeName);
        boolean added = false;
        String propName = null;
        if (subProps != null) {
            for (SubstitutionProperty subProp : subProps) {
                propName = subProp.getType() + "." + subProp.getName();
                if (typeName.equalsIgnoreCase(PROPERTY_SUFFIX_COMMAND)) {
                    this.properties.addProperty(propName, subProp.getValue());
                } else {
                    this.properties.addProperty(propName, subProp.getIndex(), subProp.getValue());
                }
                added = true;
            }
        }
        return added;
    }

    private void createContextSubstitutionList(String typeName) {
        List<SubstitutionProperty> subProps = this.subProps.get(typeName);
        String propName = null;
        int contextIndex = 0;
        if (subProps != null) {
            this.properties.addBlankLine();
            this.properties.addComment(RB.getStringResource("OMRServerComponent.appServerPropertiesWarning1.txt"));
            this.properties.addComment(RB.getStringResource("OMRServerComponent.appServerPropertiesWarning2.txt"));
            this.properties.addBlankLine();
            for (SubstitutionProperty subProp : subProps) {
                propName = typeName.equalsIgnoreCase(PROPERTY_SUFFIX_COMMAND) ? subProp.getType() + "." + subProp.getName() : subProp.getType() + "." + subProp.getName() + "[" + subProp.getIndex() + "]";
                List<String> contexts = subProp.getContexts();
                if (contexts == null) continue;
                propName = propName + "." + PROPERTY_CONTEXT_NAME;
                if (contexts.size() == 1) {
                    this.properties.addProperty(propName, contexts.get(0));
                    continue;
                }
                for (String context : contexts) {
                    this.properties.addProperty(propName, ++contextIndex, context);
                }
            }
        }
    }

    private boolean addSubProperty(SubstitutionProperty property, String keyName, String contextName) {
        boolean added = true;
        if (this.subProps.containsKey(keyName)) {
            List<SubstitutionProperty> props = this.subProps.get(keyName);
            SubstitutionProperty subProp = null;
            if (props == null) {
                props = new ArrayList<SubstitutionProperty>();
                props.add(property);
            } else if (this.handlerType.equals((Object)HandlerType.EXPORT) && props.contains(property) && keyName != PROPERTY_SUFFIX_COMMAND) {
                subProp = props.get(props.indexOf(property));
                subProp.addServerName(contextName);
                added = false;
            } else {
                props.add(property);
            }
        } else {
            ArrayList<SubstitutionProperty> subPropsList = new ArrayList<SubstitutionProperty>();
            subPropsList.add(property);
            this.subProps.put(keyName, subPropsList);
        }
        return added;
    }

    private String getServerYype(ServerComponentInterface server) throws RemoteException, ServiceException {
        String serverType = server.getType();
        return serverType.indexOf(".") != -1 ? serverType.substring(serverType.indexOf(".") + 1) : serverType;
    }

    private List<ServerComponentInterface> getServerComponents() throws RemoteException, ServiceException {
        List servers = this.applicationServer.getServers();
        ArrayList<ServerComponentInterface> serverCmpts = new ArrayList<ServerComponentInterface>();
        List lgServers = null;
        for (ServerInterface server : servers) {
            if (server instanceof LogicalServerInterface) {
                lgServers = server.getServers();
                if (lgServers == null) continue;
                serverCmpts.addAll(lgServers);
                continue;
            }
            if (!(server instanceof ServerComponentInterface)) continue;
            serverCmpts.add((ServerComponentInterface)server);
        }
        return serverCmpts.size() > 0 ? serverCmpts : null;
    }

    static List<String> getHttpAddressPropertyList(String serverType) {
        return httpAddressPropNames.containsKey(serverType) ? httpAddressPropNames.get(serverType) : httpAddressPropNames.get(serverType);
    }

    static String getConnectionStrPropertyName(String serverType) {
        return connectioStrPropNames.containsKey(serverType) ? connectioStrPropNames.get(serverType) : connectioStrPropNames.get(serverType);
    }

    static String getHostServerPropertyName(String serverType) {
        return hostServerPropNames.containsKey(serverType) ? hostServerPropNames.get(serverType) : hostServerPropNames.get(serverType);
    }

    static String getPortPropertyName(String serverType) {
        return portPropNames.containsKey(serverType) ? portPropNames.get(serverType) : portPropNames.get(serverType);
    }

    static String getCcommandPropertyName(String serverType) {
        return commandPropNames.containsKey(serverType) ? commandPropNames.get(serverType) : PROPERTY_SUFFIX_COMMAND;
    }

    static String getPathPropertyName(String serverType) {
        return pathPropNames.containsKey(serverType) ? pathPropNames.get(serverType) : pathPropNames.get(serverType);
    }

    static boolean isMultiHostDeployment(String serverType) {
        return multiHostDeploymentServers.contains(serverType);
    }

    static boolean isAssociatedMachineExists(String serverType) {
        return associatedMachineServers.contains(serverType);
    }

    static boolean checkTypeName(String serverType) {
        return databaseServers.contains(serverType) || contentServers.contains(serverType) || schedulingServers.contains(serverType) || sasServers.contains(serverType) || easServers.contains(serverType) || monitoringServers.contains(serverType) || cloudServer.contains(serverType);
    }

    static boolean isPortSubstitutionApplicable(String typeName) {
        return !noportsubServers.contains(typeName);
    }

    static {
        pathPropNames = new HashMap<String, String>(5);
        httpAddressPropNames = new HashMap<String, List<String>>(1);
        multiHostDeploymentServers = new ArrayList<String>(4);
        associatedMachineServers = new ArrayList<String>(5);
        databaseServers = new ArrayList<String>(16);
        schedulingServers = new ArrayList<String>(4);
        contentServers = new ArrayList<String>(3);
        sasServers = new ArrayList<String>(3);
        easServers = new ArrayList<String>(1);
        monitoringServers = new ArrayList<String>(1);
        cloudServer = new ArrayList<String>(1);
        noportsubServers = new ArrayList<String>(23);
        commandPropNames.put("Server.DataStepBatch", "CmdLine");
        commandPropNames.put("Server.OSScheduler", PROPERTY_SUFFIX_COMMAND);
        commandPropNames.put("Server.Grid", "SASCMD");
        connectioStrPropNames.put("Server.Aster", "NOPROMPT");
        connectioStrPropNames.put("Server.ODBC", "NOPROMPT");
        connectioStrPropNames.put("Server.HANA", "NOPROMPT");
        hostServerPropNames.put("Server.SPDS", "HOST");
        portPropNames.put("Server.SPDS", "Serv");
        portPropNames.put("Server.Postgres", "PORT");
        ArrayList<String> lstProperty = new ArrayList<String>(3);
        lstProperty.add(PROPERTY_SUFFIX_CONFIGURATIONPROPERTY);
        lstProperty.add("DFSHttpAddress");
        lstProperty.add("DFSSecondaryHttpAddress");
        lstProperty.add("JobTrackerHttpAddress");
        httpAddressPropNames.put("Server.Hadoop", lstProperty);
        pathPropNames.put("Server.Oracle", "PATH");
        pathPropNames.put("Server.MsExcel", "PATH");
        pathPropNames.put("Server.OSScheduler", "OutDir");
        pathPropNames.put("Server.SASDistributedInProcess", "OutDir");
        pathPropNames.put("Server.Oozie", "HadoopConfig");
        pathPropNames.put("Server.Http", "Base Path");
        multiHostDeploymentServers.add("Server.Workspace");
        multiHostDeploymentServers.add("Server.PooledWorkspace");
        multiHostDeploymentServers.add("Server.StoredProcess");
        multiHostDeploymentServers.add("Spawner.IOM");
        multiHostDeploymentServers.add("Server.MQPolling");
        associatedMachineServers.add("Server.DataStepBatch");
        associatedMachineServers.add("Server.GenericBatch");
        associatedMachineServers.add("Server.JavaBatch");
        associatedMachineServers.add("Spawner.Connect");
        associatedMachineServers.add("Server.Postgres");
        databaseServers.add("Server.Aster");
        databaseServers.add("Server.DB2UNXPC");
        databaseServers.add("Server.DB2zOS");
        databaseServers.add("Server.Greenplum");
        databaseServers.add("Server.Informix");
        databaseServers.add("Server.MsExcel");
        databaseServers.add("Server.MsSQLUnix");
        databaseServers.add("Server.MySQL");
        databaseServers.add("Server.Neoview");
        databaseServers.add("Server.Netezza");
        databaseServers.add("Server.ODBC");
        databaseServers.add("Server.OLEDB");
        databaseServers.add("Server.Oracle");
        databaseServers.add("Server.Redshift");
        databaseServers.add("Server.SybaseIQ");
        databaseServers.add("Server.Sybase");
        databaseServers.add("Server.Teradata");
        databaseServers.add("Server.Vertica");
        databaseServers.add("Server.HANA");
        databaseServers.add("Server.JDBC");
        databaseServers.add("Server.Salesforce");
        databaseServers.add("Server.Mongo");
        databaseServers.add("Server.BigQuery");
        databaseServers.add("Server.Snowflake");
        databaseServers.add("Server.Yellowbrick");
        databaseServers.add("Server.Spark");
        contentServers.add("Server.ESRIMap");
        contentServers.add("Server.Ftp");
        contentServers.add("Server.Http");
        schedulingServers.add("Server.OSScheduler");
        schedulingServers.add("Server.PlatformProcessManager");
        schedulingServers.add("Server.SASJFS");
        schedulingServers.add("Server.SASDistributedInProcess");
        schedulingServers.add("Server.SASInProcess");
        easServers.add("Server.SAP");
        monitoringServers.add("Server.GridMonitor");
        cloudServer.add("Server.Hadoop");
        sasServers.add("Server.SPDS");
        sasServers.add("Server.Share");
        sasServers.add("LogicalServer.Federation");
        sasServers.add("Server.MQPolling");
        sasServers.add("Server.SASInfrastructureData");
        sasServers.add("Server.CAS");
        sasServers.add("Server.Launcher");
        noportsubServers.addAll(databaseServers);
        noportsubServers.addAll(easServers);
        noportsubServers.add("Server.ESRIMap");
        noportsubServers.add("Server.SASDistributedInProcess");
        noportsubServers.add("Server.SASInProcess");
        noportsubServers.add("Server.Share");
        noportsubServers.add("Server.SASInfrastructureData");
    }

    private class SubstitutionProperty {
        String propertyName;
        String type;
        String value;
        int index;
        List<String> contexts;

        private SubstitutionProperty(String name, String value, String type) {
            this.propertyName = name;
            this.value = value;
            this.type = type;
        }

        void setIndex(int index) {
            this.index = index;
        }

        int getIndex() {
            return this.index;
        }

        void addServerName(String serverName) {
            if (this.contexts == null) {
                this.contexts = new ArrayList<String>();
            }
            this.contexts.add(serverName);
        }

        void addAllServerNames(List<String> servers) {
            if (this.contexts == null) {
                this.contexts = new ArrayList<String>();
            }
            this.contexts.addAll(servers);
        }

        List<String> getContexts() {
            return this.contexts;
        }

        String getType() {
            return this.type;
        }

        String getName() {
            return this.propertyName;
        }

        String getValue() {
            return this.value;
        }

        public boolean equals(Object another) {
            if (another == null && !(another instanceof SubstitutionProperty)) {
                return false;
            }
            SubstitutionProperty otherSub = (SubstitutionProperty)another;
            return this.propertyName.equals(otherSub.getName()) && this.value.equals(otherSub.getValue());
        }

        public int hashCode() {
            return this.propertyName.hashCode();
        }

        public String toString() {
            return this.type + " " + this.propertyName + " = " + this.value + "(" + this.contexts + ")";
        }

        public boolean equalsByName(SubstitutionProperty property) {
            return property != null && this.getName().equals(property.getName());
        }
    }

    private static enum HandlerType {
        EXPORT,
        IMPORT;

    }
}

