/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.impl.SoftwareComponentImpl;
import com.sas.metadata.remote.impl.SoftwareComponentImpl_Stub;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GroupInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PropertyGroupInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.information.metadata.SoftwareComponentAttributes;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRSoftwareComponent
extends Metadata
implements SoftwareComponentInterface {
    private static final long serialVersionUID = 7555921592995027455L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private Map<String, String> _publicConfigurableProperties;
    private Map<String, String> _privateConfigurableProperties;

    public OMRSoftwareComponent() throws RemoteException {
        this._publicConfigurableProperties = null;
        this._privateConfigurableProperties = null;
    }

    protected OMRSoftwareComponent(Class theClass) throws RemoteException {
        super(theClass);
        this._publicConfigurableProperties = null;
        this._privateConfigurableProperties = null;
    }

    protected OMRSoftwareComponent(Object o, Class theClass) throws RemoteException {
        super(o, theClass);
        this._publicConfigurableProperties = null;
        this._privateConfigurableProperties = null;
    }

    public OMRSoftwareComponent(SoftwareComponent o) throws RemoteException {
        super(o, OMRSoftwareComponent.class);
        this._publicConfigurableProperties = null;
        this._privateConfigurableProperties = null;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSoftwareComponent(SoftwareComponentImpl o) throws RemoteException {
        super(o, OMRSoftwareComponent.class);
        this._publicConfigurableProperties = null;
        this._privateConfigurableProperties = null;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSoftwareComponent(SoftwareComponentImpl_Stub o) throws RemoteException {
        super(o, OMRSoftwareComponent.class);
        this._publicConfigurableProperties = null;
        this._privateConfigurableProperties = null;
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSoftwareComponent(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRSoftwareComponent.class);
            this._publicConfigurableProperties = null;
            this._privateConfigurableProperties = null;
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                SoftwareComponent socom = (SoftwareComponent)omirepository.createMetadata(name, "SoftwareComponent");
                socom.setPublicType("Application");
                socom.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = socom;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    socom.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRColumn", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "SoftwareComponent";
    }

    @Override
    public String getSoftwareVersion() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return softcom.getSoftwareVersion();
    }

    @Override
    public void setSoftwareVersion(String version) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        softcom.setSoftwareVersion(version);
    }

    @Override
    public int getMajor() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return softcom.getMajor();
    }

    @Override
    public void setMajor(int major) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        softcom.setMajor(major);
    }

    @Override
    public int getMinor() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return softcom.getMinor();
    }

    @Override
    public void setMinor(int minor) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        softcom.setMinor(minor);
    }

    @Override
    public String getVendor() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return softcom.getVendor();
    }

    @Override
    public void setVendor(String vendor) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        softcom.setVendor(vendor);
    }

    @Override
    public String getSpecVersion() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return softcom.getSpecVersion();
    }

    @Override
    public void setSpecVersion(String specVersion) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        softcom.setSpecVersion(specVersion);
    }

    @Override
    public String getSpecVendor() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return softcom.getSpecVendor();
    }

    @Override
    public void setSpecVendor(String specVendor) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        softcom.setSpecVendor(specVendor);
    }

    @Override
    public String getVendorIdentifier() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return softcom.getVendorIdentifier();
    }

    @Override
    public void setVendorIdentifier(String vendorIdentifier) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        softcom.setVendorIdentifier(vendorIdentifier);
    }

    @Override
    public String getClassIdentifier() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return softcom.getClassIdentifier();
    }

    @Override
    public void setClassIdentifier(String classIdentifier) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        softcom.setClassIdentifier(classIdentifier);
    }

    @Override
    public String getProductName() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return softcom.getProductName();
    }

    @Override
    public void setProductName(String productName) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        softcom.setProductName(productName);
    }

    @Override
    public String getPlatform() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return softcom.getPlatform();
    }

    @Override
    public void setPlatform(String platform) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        softcom.setPlatform(platform);
    }

    @Override
    public String getProductIdentifier() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return softcom.getProductIdentifier();
    }

    @Override
    public void setProductIdentifier(String productIdentifier) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        softcom.setProductIdentifier(productIdentifier);
    }

    @Override
    public SoftwareComponentAttributes getSoftwareComponentAttributes() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        return new SoftwareComponentAttributes(softcom.getSoftwareVersion(), softcom.getMajor(), softcom.getMinor(), softcom.getVendor(), softcom.getSpecVersion(), softcom.getSpecVendor(), softcom.getVendorIdentifier(), softcom.getClassIdentifier(), softcom.getProductName(), softcom.getPlatform(), softcom.getProductIdentifier());
    }

    @Override
    public void setSoftwareComponentAttributes(SoftwareComponentAttributes attributes) throws ServiceException, RemoteException {
        String oldProductIdentifier;
        String newProductIdentifier;
        String oldPlatform;
        String newPlatform;
        String oldProductName;
        String newProductName;
        String oldClassIdentifier;
        String newClassIdentifier;
        String oldVendorIdentifier;
        String newVendorIdentifier;
        String oldSpecVendor;
        String newSpecVendor;
        String oldSpecVersion;
        String newSpecVersion;
        String oldVendor;
        String newVendor;
        int oldMinor;
        int newMinor;
        int oldMajor;
        int newMajor;
        String oldVersion;
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        String newVersion = attributes.getSoftwareVersion();
        if (newVersion != null && !newVersion.equals(oldVersion = softcom.getSoftwareVersion())) {
            softcom.setSoftwareVersion(newVersion);
        }
        if ((newMajor = attributes.getMajor()) > 0 && newMajor != (oldMajor = softcom.getMajor())) {
            softcom.setMajor(newMajor);
        }
        if ((newMinor = attributes.getMinor()) > 0 && newMinor != (oldMinor = softcom.getMinor())) {
            softcom.setMinor(newMinor);
        }
        if ((newVendor = attributes.getVendor()) != null && !newVendor.equals(oldVendor = softcom.getVendor())) {
            softcom.setVendor(newVendor);
        }
        if ((newSpecVersion = attributes.getSpecVersion()) != null && !newSpecVersion.equals(oldSpecVersion = softcom.getSpecVersion())) {
            softcom.setSpecVersion(newSpecVersion);
        }
        if ((newSpecVendor = attributes.getSpecVendor()) != null && !newSpecVendor.equals(oldSpecVendor = softcom.getSpecVendor())) {
            softcom.setSpecVendor(newSpecVendor);
        }
        if ((newVendorIdentifier = attributes.getVendorIdentifier()) != null && !newVendorIdentifier.equals(oldVendorIdentifier = softcom.getVendorIdentifier())) {
            softcom.setVendorIdentifier(newVendorIdentifier);
        }
        if ((newClassIdentifier = attributes.getClassIdentifier()) != null && !newClassIdentifier.equals(oldClassIdentifier = softcom.getClassIdentifier())) {
            softcom.setClassIdentifier(newClassIdentifier);
        }
        if ((newProductName = attributes.getProductName()) != null && !newProductName.equals(oldProductName = softcom.getProductName())) {
            softcom.setProductName(newProductName);
        }
        if ((newPlatform = attributes.getPlatform()) != null && !newPlatform.equals(oldPlatform = softcom.getPlatform())) {
            softcom.setPlatform(newPlatform);
        }
        if ((newProductIdentifier = attributes.getProductIdentifier()) != null && !newProductIdentifier.equals(oldProductIdentifier = softcom.getProductIdentifier())) {
            softcom.setProductIdentifier(newProductIdentifier);
        }
    }

    @Override
    public List getSoftwareGroups() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList sgroupList = softcom.getSoftwareGroups();
            if (sgroupList.size() > 0) {
                results = new ArrayList<MetadataInterface>(sgroupList.size());
                for (Group nextGroup : sgroupList) {
                    MetadataInterface mi = this._repository.factoryProcess(nextGroup);
                    results.add(mi);
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addSoftwareGroup(GroupInterface group) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList sgroupList = softcom.getSoftwareGroups();
            sgroupList.add(group.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeSoftwareGroup(GroupInterface group) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList sgroupList = softcom.getSoftwareGroups();
            sgroupList.remove(group.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setSoftwareGroups(List groups) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList sgroupList = softcom.getSoftwareGroups();
            sgroupList.clear();
            for (GroupInterface group : groups) {
                sgroupList.add(group.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getSoftwareTrees() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> results = null;
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList streeList = softcom.getSoftwareTrees();
            if (streeList.size() > 0) {
                results = new ArrayList<MetadataInterface>(streeList.size());
                for (Tree nextTree : streeList) {
                    MetadataInterface mi = this._repository.factoryProcess(nextTree);
                    results.add(mi);
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addSoftwareTree(FolderInterface folder) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList sTreeList = softcom.getSoftwareTrees();
            sTreeList.add(folder.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeSoftwareTree(FolderInterface folder) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList sTreeList = softcom.getSoftwareTrees();
            sTreeList.remove(folder.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setSoftwareTrees(List folders) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList streeList = softcom.getSoftwareTrees();
            streeList.clear();
            for (FolderInterface folder : folders) {
                streeList.add(folder.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getDeployedComponents() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> results = null;
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList dcList = softcom.getDeployedComponents();
            if (dcList.size() > 0) {
                results = new ArrayList<MetadataInterface>(dcList.size());
                for (DeployedComponent nextdc : dcList) {
                    MetadataInterface mi = this._repository.factoryProcess(nextdc);
                    results.add(mi);
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addDeployedComponent(ServerInterface server) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList dcList = softcom.getDeployedComponents();
            dcList.add(server.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeDeployedComponent(ServerInterface server) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList dcList = softcom.getDeployedComponents();
            dcList.remove(server.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setDeployedComponents(List servers) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList dcList = softcom.getDeployedComponents();
            dcList.clear();
            for (ServerInterface server : servers) {
                dcList.add(server.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getPropertyGroups() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> results = null;
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList dcList = softcom.getPropertyGroups();
            if (dcList.size() > 0) {
                results = new ArrayList<MetadataInterface>(dcList.size());
                for (PropertyGroup nextdc : dcList) {
                    MetadataInterface mi = this._repository.factoryProcess(nextdc);
                    results.add(mi);
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addPropertyGroup(PropertyGroupInterface group) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList dcList = softcom.getPropertyGroups();
            dcList.add(group.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removePropertyGroup(PropertyGroupInterface group) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList dcList = softcom.getPropertyGroups();
            dcList.remove(group.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setPropertyGroups(List groups) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList dcList = softcom.getPropertyGroups();
            dcList.clear();
            for (ServerInterface server : groups) {
                dcList.add(server.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getDependentComponents() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList list = softcom.getDependentComponents();
            if (list == null || list.size() == 0) {
                results = Collections.EMPTY_LIST;
            } else {
                results = new ArrayList<MetadataInterface>(list.size());
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    results.add(this._repository.factoryProcess(it.next()));
                }
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public List getDependsOnComponents() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList list = softcom.getDependsOnComponents();
            if (list == null || list.size() == 0) {
                results = Collections.EMPTY_LIST;
            } else {
                results = new ArrayList<MetadataInterface>(list.size());
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    results.add(this._repository.factoryProcess(it.next()));
                }
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public Map<String, String> getPrivateConfigurableProperties() throws ServiceException, RemoteException {
        if (this._privateConfigurableProperties == null) {
            this.loadConfigurableProperties();
        }
        return this._privateConfigurableProperties;
    }

    @Override
    public Map<String, String> getPublicConfigurableProperties() throws ServiceException, RemoteException {
        if (this._publicConfigurableProperties == null) {
            this.loadConfigurableProperties();
        }
        return this._publicConfigurableProperties;
    }

    private void loadConfigurableProperties() throws RemoteException, ServiceException {
        this._publicConfigurableProperties = new HashMap<String, String>();
        this._privateConfigurableProperties = new HashMap<String, String>();
        try {
            ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)((SoftwareComponent)this._repositoryObject), this._publicConfigurableProperties, this._privateConfigurableProperties);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        this._publicConfigurableProperties = Collections.unmodifiableMap(this._publicConfigurableProperties);
        this._privateConfigurableProperties = Collections.unmodifiableMap(this._privateConfigurableProperties);
    }

    @Override
    public List<MetadataInterface> getImplementedObjects() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        try {
            AssociationList implementedList = softcom.getImplementedObjects();
            for (Root nextRoot : implementedList) {
                result.add(this._repository.factoryProcess(nextRoot));
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    @Override
    public void setImplementedObjects(List<MetadataInterface> objects) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SoftwareComponent softcom = (SoftwareComponent)this._repositoryObject;
        try {
            AssociationList implementedList = softcom.getImplementedObjects();
            implementedList.clear();
            for (MetadataInterface mi : objects) {
                implementedList.add((Root)mi.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }
}

