/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.metadata.remote.impl.ServerContextImpl;
import com.sas.metadata.remote.impl.ServerContextImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRServer;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.information.metadata.ServerSubPropsHandler;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

@SASScope
public class OMRServerContext
extends OMRServer
implements ServerContextInterface,
PublicObjectContainerInterface,
SubstitutionProperties {
    private static final long serialVersionUID = 5590787541198015813L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static final String SERVER_CONTEXT_PROPERTIES = "ServerContextProperties";

    public OMRServerContext() throws RemoteException {
        super(OMRServerContext.class);
    }

    public OMRServerContext(ServerContext o) throws RemoteException {
        super((DeployedComponent)o, OMRServerContext.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServerContext(ServerContextImpl o) throws RemoteException {
        super((ServerComponentImpl)o, OMRServerContext.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServerContext(ServerContextImpl_Stub o) throws RemoteException {
        super((DeployedComponent)o, OMRServerContext.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServerContext(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRServerContext.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        ServerContext sc = null;
        try {
            sc = (ServerContext)((OMIRepositoryInterface)repos).createMetadata(name, "ServerContext");
            sc.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
        }
        this._repositoryObject = sc;
        this._repositoryFlag = 2;
        this.setRepository(repos);
        if (parent != null) {
            try {
                parent.addItem(this);
            }
            catch (Exception ex) {
                sc.delete();
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "ApplicationServer";
    }

    @Override
    public PublicObjectInterface getChildAt(int index) throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public int getChildCount() throws ServiceException, RemoteException {
        return 0;
    }

    @Override
    public List getChildren() throws ServiceException, RemoteException {
        List logicalServers = this.getServers();
        ServerInterface server = null;
        Object serverName = null;
        ArrayList<ServerInterface> children = new ArrayList<ServerInterface>(logicalServers.size());
        for (Object logicalServer : logicalServers) {
            server = (ServerInterface)logicalServer;
            children.add(server);
        }
        return children;
    }

    @Override
    public List getChildren(String type) throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public PublicObjectInterface newChild(String type, String name) throws ServiceException, RemoteException {
        return null;
    }

    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        ServerSubPropsHandler handler = ServerSubPropsHandler.getInstanceForFetching(this);
        return handler.getSubstitutionProperties();
    }

    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        ServerSubPropsHandler subPropHandler = ServerSubPropsHandler.getInstanceToStore(this);
        subPropHandler.setSubstitutionProperties(map);
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(false);
        ServerContext sc = (ServerContext)this._repositoryObject;
        List<MetadataInterface> implementors = this.getImplementedObjects();
        if (implementors != null && !implementors.isEmpty()) {
            for (MetadataInterface cm : implementors) {
                if (!"PropertySet".equalsIgnoreCase(cm.getType()) || !SERVER_CONTEXT_PROPERTIES.equalsIgnoreCase(cm.getName())) continue;
                cm.delete();
            }
        }
        super.delete();
    }
}

