/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.metadata.remote.impl.ServerComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.ConnectionInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.HostInterface;
import com.sas.services.information.metadata.MultiHostDeployment;
import com.sas.services.information.metadata.OMRHost;
import com.sas.services.information.metadata.OMRMultiHostDeployedObject;
import com.sas.services.information.metadata.OMRServer;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.ServerSubPropsHandler;
import com.sas.services.information.metadata.TCPIPConnectionInterface;
import com.sas.services.information.metadata.TransformationInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SASScope
public class OMRServerComponent
extends OMRServer
implements ServerComponentInterface,
SubstitutionProperties {
    private static final long serialVersionUID = -4391386931082513041L;
    private static final int EMPTY_LIST_INIT = 1;
    private static final String SERVERCOMPONENTEMPLATE = "<Templates>\n  <ServerComponent>\n    <AssociatedMachine/>\n    <SourceConnections/>\n    <UsedByComponents/>\n  </ServerComponent>\n  <TCPIPConnection Name=\"\" ApplicationProtocol=\"\"        AuthenticationType=\"\" CommunicationProtocol=\"\"        Desc=\"\" HostName=\"\" Port=\"\" Service=\"\">\n    <Domain/>\n  </TCPIPConnection>\n  <AuthenticationDomain Name=\"\"/>\n  <LogicalServer Name=\"\" ClassIdentifier=\"\" Desc=\"\"     InstallationLocation=\"\" IsLicensed=\"\" Major=\"\"     Minor=\"\" Platform=\"\" ProductIdentifier=\"\"     ProductName=\"\" SoftwareVersion=\"\">\n    <InitProcesses/>\n  </LogicalServer>\n  <Transformation Name=\"\" IsActive=\"\" IsUserDefined=\"\"     TransformRole=\"\">\n    <TransformSources/>\n  </Transformation>\n  <Group Name=\"\">\n    <Members/>\n    <Properties/>\n  </Group>\n  <Person Name=\"\" Title=\"\" />\n  <IdentityGroup Name=\"\" >\n    <MemberIdentities/>\n  </IdentityGroup>\n  <Properties Name=\"\" PropertyName=\"\" DefaultValue=\"\"/>\n</Templates>\n";
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRServerComponent() throws RemoteException {
        this(OMRServerComponent.class);
    }

    public OMRServerComponent(ServerComponent o) throws RemoteException {
        this(o, OMRServerComponent.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServerComponent(ServerComponentImpl o) throws RemoteException {
        this(o, OMRServerComponent.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServerComponent(ServerComponentImpl_Stub o) throws RemoteException {
        this(o, OMRServerComponent.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRServerComponent(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, OMRServerComponent.class);
    }

    protected OMRServerComponent(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected OMRServerComponent(ServerComponent o, Class theClass) throws RemoteException {
        super((DeployedComponent)o, theClass);
    }

    protected OMRServerComponent(ServerComponentImpl o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRServerComponent(ServerComponentImpl_Stub o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRServerComponent(RepositoryInterface repos, String name, FolderInterface parent, Class theClass) throws RemoteException {
        block5: {
            super(theClass);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                ServerComponent sc = (ServerComponent)omirepository.createMetadata(name, "ServerComponent");
                sc.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = sc;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    sc.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public void setRepository(RepositoryInterface repos) throws IllegalStateException, RemoteException {
        super.setRepository(repos);
        try {
            Root root = (Root)this._repositoryObject;
            MdObjectStore store = (MdObjectStore)root.getObjectStore();
            MdFactory factory = store.getFactory();
            String template = SERVERCOMPONENTEMPLATE;
            factory.getOMIUtil().getMetadataAllDepths((CMetadata)root, new ArrayList(1), new ArrayList(1), template, 269);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getType() throws RemoteException {
        String type = null;
        ServerComponent sc = (ServerComponent)this._repositoryObject;
        if (sc != null) {
            type = sc.getPublicType();
        }
        if (type == null || type.trim().length() == 0) {
            type = "ServerComponent";
        }
        return type;
    }

    @Override
    public List<TransformationInterface> getInitProcesses() throws ServiceException, RemoteException {
        ArrayList<TransformationInterface> results = new ArrayList<TransformationInterface>();
        try {
            ServerComponent sc = (ServerComponent)this._repositoryObject;
            AssociationList initProcesses = sc.getInitProcesses();
            if (initProcesses != null && initProcesses.size() > 0) {
                for (Transformation transformation : initProcesses) {
                    results.add((TransformationInterface)this._repository.factoryProcess(transformation));
                }
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, RB.getStringResource("Metadata.accessexcept.msg.txt"));
        }
        return results;
    }

    private void addHostSubstitutionProperties(PropertyList properties, boolean flag) throws RemoteException, ServiceException {
        List<HostInterface> hosts;
        MultiHostDeployment dep = null;
        dep = OMRMultiHostDeployedObject.getInstance(this);
        HostInterface assMachine = null;
        String hostPropNamePerfix = "";
        String hostPropName = null;
        int index = 0;
        String hostName = null;
        boolean added = false;
        if (dep != null && (hosts = dep.getHosts()) != null && hosts.size() > 0) {
            added = true;
            for (HostInterface host : hosts) {
                hostName = host.getName();
                if (hostName == null || hostName.equals("")) continue;
                hostPropName = hostPropNamePerfix + "Host";
                properties.addProperty(hostPropName, ++index, host.getName());
            }
            if (flag) {
                properties.addProperty("Host.Server", this.getName());
            }
        }
        if (!added) {
            hostName = this.getHost();
            if ((hostName == null || hostName.equals("")) && (assMachine = dep.getAssociatedHost()) != null) {
                hostName = assMachine.getHostName();
            }
            String propName = hostPropNamePerfix + "Host";
            if (hostName != null && !hostName.equals("") && !properties.getMap().containsProperty(propName)) {
                properties.addProperty(propName, hostName);
                if (flag) {
                    properties.addProperty("Host.Server", this.getName());
                }
            }
        }
    }

    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        try {
            PropertyList srvProperties = new PropertyList();
            TypeDescriptorInterface tdi = this.getTypeDescriptor();
            if (tdi != null) {
                String command;
                boolean contextFlag = true;
                if (ServerSubPropsHandler.checkTypeName(tdi.getTypeName())) {
                    contextFlag = false;
                }
                this.addHostSubstitutionProperties(srvProperties, contextFlag);
                if (ServerSubPropsHandler.isPortSubstitutionApplicable(tdi.getTypeName())) {
                    List lstConnections = this.getSourceConnections();
                    String serverName = this.getName();
                    if (lstConnections != null && lstConnections.size() > 0) {
                        for (int i = 0; i < lstConnections.size(); ++i) {
                            SubstitutionProperties con;
                            PropertyList lst;
                            ConnectionInterface conn = (ConnectionInterface)lstConnections.get(i);
                            if (!(conn instanceof SubstitutionProperties) || (lst = (con = (SubstitutionProperties)conn).getSubstitutionProperties()) == null) continue;
                            Iterator propNames = lst.getMap().getPropertyIterator();
                            String propName = null;
                            String srvPropName = null;
                            while (propNames.hasNext()) {
                                propName = (String)propNames.next();
                                srvPropName = conn.getName() + ":" + serverName;
                                if (contextFlag) {
                                    srvProperties.addProperty("Port", i + 1, lst.getMap().getProperty(propName));
                                    srvProperties.addProperty("Port[" + (i + 1) + "].Server", serverName);
                                    continue;
                                }
                                if (lstConnections.size() > 1 && !contextFlag) {
                                    srvProperties.addProperty("Port", i + 1, lst.getMap().getProperty(propName));
                                    srvProperties.addProperty("Port." + conn.getType() + "[" + (i + 1) + "]", srvPropName);
                                    continue;
                                }
                                if (lstConnections.size() != 1 || contextFlag) continue;
                                srvProperties.addProperty("Port", lst.getMap().getProperty(propName));
                            }
                        }
                        if (contextFlag) {
                            srvProperties.addProperty("Port.Server", this.getName());
                        }
                    }
                }
                if ((command = this.getCommand()) != null) {
                    String ServerName = this.getName();
                    srvProperties.addProperty(ServerName + "." + "Command", command);
                    if (contextFlag) {
                        srvProperties.addProperty(this.getName() + ".command.Server", this.getName());
                    }
                }
            }
            return srvProperties;
        }
        catch (ServiceException e) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
    }

    private String getCommand() throws RemoteException, ServiceException {
        String commandPropName = ServerSubPropsHandler.getCcommandPropertyName(this.getType());
        List command = this.getProperties(commandPropName);
        String commandVal = null;
        if (command != null && command.size() > 0) {
            commandVal = ((PropertyInterface)command.get(0)).getValue();
        }
        return commandVal;
    }

    private void setHostSubstitutionProperties(PropertyMap map) throws ServiceException, RemoteException {
        String[] hostProperties = map.getPropertiesBySuffix("Host");
        String newHost = null;
        HostInterface newHostObject = null;
        String type = this.getType();
        boolean setHost = true;
        if (hostProperties != null) {
            MultiHostDeployment dep = null;
            dep = OMRMultiHostDeployedObject.getInstance(this);
            if (ServerSubPropsHandler.isMultiHostDeployment(type)) {
                dep.removeAll();
            }
            for (String hostProperty : hostProperties) {
                newHost = map.getProperty(hostProperty);
                newHostObject = this.browseHost(newHost, true);
                if (dep != null && !dep.isDeployedOnHost(newHostObject)) {
                    dep.addHost(newHostObject);
                }
                if (setHost) {
                    this.setHost(newHost);
                    dep.setAssociatedMachine(newHostObject);
                }
                setHost = false;
            }
        }
    }

    private HostInterface browseHost(String hostName, boolean create) throws ServiceException, RemoteException {
        Filter filter = new Filter("Name", 0, hostName);
        filter.setType("Machine");
        List objects = this._repository.search(filter);
        HostInterface host = null;
        if (objects != null && objects.size() > 0) {
            host = (HostInterface)objects.get(0);
        } else if (create) {
            host = new OMRHost(this._repository, hostName);
            host.update();
        }
        return host;
    }

    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        try {
            String[] commandPropName;
            List connections;
            this.setHostSubstitutionProperties(map);
            String type = this.getType();
            boolean contextFlag = true;
            if (ServerSubPropsHandler.checkTypeName(type)) {
                contextFlag = false;
            }
            if (ServerSubPropsHandler.isPortSubstitutionApplicable(type) && (connections = this.getSourceConnections()) != null) {
                int metaPortValue = -1;
                int iPort = -1;
                int portValue = -1;
                SASClientConnectionInterface clientConnection = null;
                for (int i = 0; i < connections.size(); ++i) {
                    Object objCon = connections.get(i);
                    String port = null;
                    port = contextFlag ? map.getProperty("Port", i + 1) : (connections.size() == 1 ? map.getProperty("Port") : map.getProperty("Port", i + 1));
                    if (port != null) {
                        iPort = Integer.parseInt(port);
                        if (this.isMetadataServer()) {
                            metaPortValue = iPort;
                        }
                    }
                    if (objCon instanceof TCPIPConnectionInterface) {
                        TCPIPConnectionInterface con = (TCPIPConnectionInterface)objCon;
                        con.setPort(iPort);
                        continue;
                    }
                    if (!(objCon instanceof SASClientConnectionInterface)) continue;
                    clientConnection = (SASClientConnectionInterface)objCon;
                    if (this.isMetadataServer() && metaPortValue != -1) {
                        clientConnection.setPort(metaPortValue);
                        continue;
                    }
                    clientConnection.setPort(iPort);
                }
            }
            if ((commandPropName = map.getPropertiesBySuffix("Command")) != null && commandPropName.length > 0) {
                this.setCommandproperty(map.getProperty(commandPropName[0]));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isMetadataServer() throws RemoteException {
        return "Server.Metadata".equals(this.getType());
    }

    private void setCommandproperty(String value) throws RemoteException, ServiceException {
        String commandPropName = ServerSubPropsHandler.getCcommandPropertyName(this.getType());
        List command = this.getProperties(commandPropName);
        PropertyInterface commandVal = null;
        if (command != null && command.size() > 0) {
            commandVal = (PropertyInterface)command.get(0);
            commandVal.setValue(value);
        }
    }
}

