/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.impl.ConnectionImpl;
import com.sas.metadata.remote.impl.SASClientConnectionImpl;
import com.sas.metadata.remote.impl.SASClientConnectionImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FileInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRConnection;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRSASClientConnection
extends OMRConnection
implements SASClientConnectionInterface,
SubstitutionProperties {
    private static final long serialVersionUID = -9096928839935684153L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRSASClientConnection() throws RemoteException {
    }

    public OMRSASClientConnection(SASClientConnection o) throws RemoteException {
        super((Connection)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSASClientConnection(SASClientConnectionImpl o) throws RemoteException {
        super((ConnectionImpl)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSASClientConnection(SASClientConnectionImpl_Stub o) throws RemoteException {
        super((Connection)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSASClientConnection(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                SASClientConnection connection = (SASClientConnection)omirepository.createMetadata(name, "SASClientConnection");
                connection.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = connection;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    connection.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRColumn", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "SASClientConnection";
    }

    @Override
    public String getServerShortName() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        return conn.getServerShortName();
    }

    @Override
    public void setServerShortName(String serverName) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        conn.setServerShortName(serverName);
    }

    @Override
    public String getRemoteAddress() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        return conn.getRemoteAddress();
    }

    @Override
    public void setRemoteAddress(String remoteAddress) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        conn.setRemoteAddress(remoteAddress);
    }

    @Override
    public String getService() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        return conn.getService();
    }

    @Override
    public void setService(String service) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        conn.setService(service);
    }

    @Override
    public int getPort() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        return conn.getPort();
    }

    @Override
    public void setPort(int port) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        conn.setPort(port);
    }

    @Override
    public List getLibraries() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList libraryList = conn.getLibraries();
            if (libraryList.size() > 0) {
                results = new ArrayList<MetadataInterface>(libraryList.size());
                Iterator it = libraryList.iterator();
                while (it.hasNext()) {
                    MetadataInterface mi = this._repository.factoryProcess(it.next());
                    results.add(mi);
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addLibrary(SASLibraryInterface library) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        try {
            AssociationList libraryList = conn.getLibraries();
            libraryList.add((SASLibrary)library.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeLibrary(SASLibraryInterface library) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        try {
            AssociationList libraryList = conn.getLibraries();
            libraryList.remove((SASLibrary)library.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setLibraries(List libraries) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        try {
            AssociationList libraryList = conn.getLibraries();
            libraryList.clear();
            for (SASLibraryInterface sli : libraries) {
                libraryList.add(sli.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getScriptFiles() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        ArrayList<MetadataInterface> results = null;
        try {
            AssociationList scriptList = conn.getScriptFiles();
            if (scriptList.size() > 0) {
                results = new ArrayList<MetadataInterface>(scriptList.size());
                Iterator it = scriptList.iterator();
                while (it.hasNext()) {
                    MetadataInterface mi = this._repository.factoryProcess(it.next());
                    results.add(mi);
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public void addScriptFile(FileInterface file) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        try {
            AssociationList fileList = conn.getScriptFiles();
            fileList.add(file.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeScriptFile(FileInterface file) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        try {
            AssociationList fileList = conn.getScriptFiles();
            fileList.remove(file.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setScriptFiles(List files) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASClientConnection conn = (SASClientConnection)this._repositoryObject;
        try {
            AssociationList fileList = conn.getScriptFiles();
            fileList.clear();
            for (FileInterface file : files) {
                fileList.add(file.getRepositoryEntity());
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        int port = -1;
        PropertyList connList = null;
        try {
            port = this.getPort();
            PropertyList portList = new PropertyList();
            portList.addProperty("port", String.valueOf(port));
            connList = new PropertyList();
            connList.addProperty(this.getName(), portList);
        }
        catch (RemoteException exception) {
            throw new UnexpectedSubstitutionException((Throwable)exception);
        }
        catch (ServiceException exception) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)exception));
        }
        return connList;
    }

    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        if (map != null) {
            String port = null;
            int iPort = -1;
            try {
                PropertyMap connMap = map.getNestedProperties(this.getName());
                if (connMap != null && (port = connMap.getProperty("port")) != null) {
                    iPort = Integer.parseInt(port);
                    this.setPort(iPort);
                }
            }
            catch (RemoteException exception) {
                throw new UnexpectedSubstitutionException((Throwable)exception);
            }
            catch (ServiceException exception) {
                throw new UnexpectedSubstitutionException((Throwable)((Object)exception));
            }
        }
    }
}

