/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.impl.IdentityGroupImpl;
import com.sas.metadata.remote.impl.IdentityGroupImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.OMRIdentityGroup;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RoleInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRRole
extends OMRIdentityGroup
implements RoleInterface {
    private static final long serialVersionUID = -1509603655647269757L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRRole() throws RemoteException {
        super(OMRRole.class);
    }

    public OMRRole(IdentityGroup o) throws RemoteException {
        super(o, OMRRole.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRRole(IdentityGroupImpl o) throws RemoteException {
        super(o, OMRRole.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRRole(IdentityGroupImpl_Stub o) throws RemoteException {
        super(o, OMRRole.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRRole(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRRole.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            IdentityGroup idGroup = (IdentityGroup)omirepository.createMetadata(name, "IdentityGroup");
            idGroup.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            idGroup.setGroupType("role");
            idGroup.setPublicType("Role");
            this._repositoryObject = idGroup;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            try {
                if (parent != null) {
                    parent.addItem(this);
                }
            }
            catch (Exception ex) {
                idGroup.delete();
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRPerson", (Throwable)((Object)ex));
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Role";
    }
}

