/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AbstractProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.impl.AbstractPropertyImpl;
import com.sas.metadata.remote.impl.PropertyImpl;
import com.sas.metadata.remote.impl.PropertyImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRAbstractProperty;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.TextStoreInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRProperty
extends OMRAbstractProperty
implements PropertyInterface {
    private static final long serialVersionUID = -687148534718778872L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRProperty() throws RemoteException {
        super(OMRProperty.class);
    }

    public OMRProperty(Property o) throws RemoteException {
        super((AbstractProperty)o, OMRProperty.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRProperty(PropertyImpl o) throws RemoteException {
        super((AbstractPropertyImpl)o, OMRProperty.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRProperty(PropertyImpl_Stub o) throws RemoteException {
        super((AbstractProperty)o, OMRProperty.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRProperty(RepositoryInterface repos, String name, String propertyName, String value, String type) throws RemoteException {
        super(OMRProperty.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        int sqltype = -1;
        sqltype = "Boolean".equals(type) ? 16 : ("Integer".equals(type) ? 4 : ("String".equals(type) ? 12 : ("Multi-line Text".equals(type) ? -1 : ("Float".equals(type) ? 6 : ("Date".equals(type) ? 91 : ("Color".equals(type) ? 2 : ("File Name".equals(type) ? 12 : ("GenericString".equals(type) ? 12 : 12))))))));
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        try {
            Property property = (Property)omirepository.createMetadata(name, "Property");
            property.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            property.setPropertyName(propertyName);
            property.setDefaultValue(value);
            property.setSQLType(sqltype);
            this._repositoryObject = property;
            this._repositoryFlag = 2;
        }
        catch (ServiceException e) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", (Throwable)((Object)e));
        }
    }

    public OMRProperty(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, null);
    }

    public OMRProperty(RepositoryInterface repos, String name, FolderInterface parent, PropertyType owningType) throws RemoteException {
        block7: {
            super(OMRProperty.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            try {
                Property property = (Property)omirepository.createMetadata(name, "Property");
                property.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = property;
                this._repositoryFlag = 2;
                if (owningType == null) {
                    PropertyType propertyType = (PropertyType)omirepository.createMetadata("String", "PropertyType");
                    propertyType.setSQLType(12);
                    property.setOwningType(propertyType);
                } else {
                    property.setOwningType(owningType);
                }
                this.setRepository(repos);
                if (parent == null) break block7;
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    property.delete();
                    throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
                }
            }
            catch (ServiceException e) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Property";
    }

    @Override
    public String getKey() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Property prop = (Property)this._repositoryObject;
        return prop.getPropertyName() == null || prop.getPropertyName().trim().length() == 0 ? prop.getName() : prop.getPropertyName();
    }

    @Override
    public void setKey(String key) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Property prop = (Property)this._repositoryObject;
        prop.setPropertyName(key);
    }

    @Override
    public String getValue() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Property prop = (Property)this._repositoryObject;
        return prop.getDefaultValue();
    }

    @Override
    public void setValue(String value) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Property prop = (Property)this._repositoryObject;
        prop.setDefaultValue(value);
    }

    @Override
    public int getSQLType() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            Property prop = (Property)this._repositoryObject;
            PropertyType ptype = prop.getOwningType();
            if (ptype != null) {
                return ptype.getSQLType();
            }
            return prop.getSQLType();
        }
        catch (MdException ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), this.getClass().getName(), ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public void setSQLType(int type) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Property prop = (Property)this._repositoryObject;
        String typeString = String.valueOf(type);
        Filter filter = new Filter("SQLType", 0, typeString);
        filter.setType("PropertyType");
        PropertyType ptype = null;
        List typeList = this._repository.search(filter);
        if (typeList != null && typeList.size() > 0) {
            ptype = (PropertyType)((MetadataInterface)typeList.get(0)).getRepositoryEntity();
        } else {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
            ptype = (PropertyType)omirepository.createMetadata("SQL Type " + ptype, "PropertyType");
            ptype.setSQLType(type);
        }
        prop.setOwningType(ptype);
    }

    @Override
    public TextStoreInterface getConfigurationText() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            Property prop = (Property)this._repositoryObject;
            Text o = prop.getStoredConfiguration();
            if (!(o instanceof TextStore)) {
                return null;
            }
            TextStore ts = (TextStore)o;
            TextStoreInterface tsi = (TextStoreInterface)this._repository.factoryProcess(ts);
            return tsi;
        }
        catch (MdException ex) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
            throw new ServiceException(ex, RB.getStringResource("Metadata.accessexcept.msg.txt"));
        }
    }

    @Override
    public void setConfigurationText(TextStoreInterface textStore) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Property prop = (Property)this._repositoryObject;
        TextStore ts = (TextStore)textStore.getRepositoryEntity();
        prop.setStoredConfiguration((Text)ts);
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        this.checkPulse(false);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        try {
            PropertyType ptype;
            Property prop = (Property)this._repositoryObject;
            Text root = prop.getStoredConfiguration();
            if (root != null) {
                root.delete();
            }
            if ((ptype = prop.getOwningType()) != null) {
                AssociationList owners = ptype.getTypedProperties();
                AssociationList groups = ptype.getGroups();
                if (owners.size() == 0 && groups.size() == 0) {
                    ptype.delete();
                }
            }
            super.delete();
        }
        catch (MdException ex) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRProperty", ex);
            throw new ServiceException(ex, RB.getStringResource("Metadata.accessexcept.msg.txt"));
        }
    }

    @Override
    public void setDelimiter(String delimiter) throws ServiceException, RemoteException {
        this.checkPulse(false);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Property prop = (Property)this._repositoryObject;
        prop.setDelimiter(delimiter);
    }

    @Override
    public String getDelimiter() throws ServiceException, RemoteException {
        Property prop = (Property)this._repositoryObject;
        return prop.getDelimiter();
    }

    @Override
    public MetadataInterface getAssociatedObject() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        MetadataInterface result = null;
        Property prop = (Property)this._repositoryObject;
        try {
            Root o = prop.getAssociatedObject();
            if (o != null) {
                result = this._repository.factoryProcess(o);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    @Override
    public boolean isUpdateable() throws ServiceException, RemoteException {
        Property prop = (Property)this._repositoryObject;
        return prop.getIsUpdateable() != 0;
    }

    @Override
    public void setUpdateable(boolean isUpdateable) throws ServiceException, RemoteException {
        Property prop = (Property)this._repositoryObject;
        prop.setIsUpdateable(isUpdateable ? 1 : 0);
    }
}

