/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.impl.LoginImpl;
import com.sas.metadata.remote.impl.LoginImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRPerson;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRLogin
extends Metadata
implements LoginInterface,
Serializable {
    static final long serialVersionUID = -415282394763077730L;
    static final int USER_LIST_INIT = 8;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRLogin() throws RemoteException {
        super(OMRLogin.class);
    }

    public OMRLogin(Login o) throws RemoteException {
        super(o, OMRLogin.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRLogin(LoginImpl o) throws RemoteException {
        super(o, OMRLogin.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRLogin(LoginImpl_Stub o) throws RemoteException {
        super(o, OMRLogin.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRLogin(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRLogin.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Login login = (Login)omirepository.createMetadata(name, "Login");
                login.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = login;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    login.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRLogin", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "Login";
    }

    @Override
    public String getUserId() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Login login = (Login)this._repositoryObject;
        return login.getUserID();
    }

    @Override
    public void setUserId(String uid) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Login login = (Login)this._repositoryObject;
        try {
            login.setUserID(uid);
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRLogin", ex);
        }
    }

    @Override
    public String getPassword() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Login login = (Login)this._repositoryObject;
        return login.getPassword();
    }

    @Override
    public void setPassword(String password) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Login login = (Login)this._repositoryObject;
        try {
            login.setPassword(password);
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRLogin", ex);
        }
    }

    @Override
    public String getDomain() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Login login = (Login)this._repositoryObject;
        try {
            AuthenticationDomain domain = login.getDomain();
            if (domain != null) {
                return domain.getName();
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRLogin", ex);
        }
        return null;
    }

    @Override
    public void setDomain(String domain) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Login login = (Login)this._repositoryObject;
        Filter filter = new Filter("Name", 0, domain);
        filter.setType("AuthenticationDomain");
        RepositoryInterface ri = this._repository;
        List domainList = ri.search(filter);
        if (domainList.size() > 0) {
            MetadataInterface mi = (MetadataInterface)domainList.get(0);
            AuthenticationDomain adomain = (AuthenticationDomain)mi.getRepositoryEntity();
            login.setDomain(adomain);
        } else {
            AuthenticationDomain adomain = (AuthenticationDomain)((OMIRepositoryInterface)this._repository).createMetadata(domain, "AuthenticationDomain");
            login.setDomain(adomain);
        }
    }

    @Override
    public IdentityInterface getIdentity() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        IdentityInterface result = null;
        Login login = (Login)this._repositoryObject;
        try {
            Identity identity = login.getAssociatedIdentity();
            if (identity == null) {
                return result;
            }
            result = (IdentityInterface)this._repository.factoryProcess(identity);
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRLogin", ex);
        }
        return result;
    }

    @Override
    public List getUsers() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<OMRPerson> result = new ArrayList<OMRPerson>(8);
        Login login = (Login)this._repositoryObject;
        try {
            Identity identity = login.getAssociatedIdentity();
            if (identity == null) {
                return result;
            }
            if (identity instanceof IdentityGroup) {
                IdentityGroup ig = (IdentityGroup)identity;
                AssociationList ass = ig.getMemberIdentities();
                for (Identity id : ass) {
                    if (!(id instanceof Person)) continue;
                    OMRPerson op = (OMRPerson)this._repository.factoryProcess(id);
                    result.add(op);
                }
            } else if (identity instanceof Person) {
                OMRPerson op = (OMRPerson)this._repository.factoryProcess(identity);
                result.add(op);
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRLogin", ex);
        }
        return result;
    }

    @Override
    public void addUser(PersonInterface user) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Login login = (Login)this._repositoryObject;
        try {
            Identity identity = login.getAssociatedIdentity();
            if (identity == null) {
                login.setAssociatedIdentity((Identity)user.getRepositoryEntity());
            }
            if (identity instanceof IdentityGroup) {
                IdentityGroup ig = (IdentityGroup)identity;
                AssociationList ass = ig.getMemberIdentities();
                ass.add(user.getRepositoryEntity());
            }
        }
        catch (Exception ex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRLogin", ex);
        }
    }

    @Override
    public void removeUser(PersonInterface user) throws ServiceException, RemoteException {
        this.checkPulse(true);
    }

    @Override
    public int getMinAvail() throws RemoteException {
        this.checkPulse(true);
        return 0;
    }

    @Override
    public void setMinAvail(int min) throws RemoteException {
        this.checkPulse(true);
    }

    @Override
    public int getMinSize() throws RemoteException {
        this.checkPulse(true);
        return 0;
    }

    @Override
    public void setMinSize(int size) throws RemoteException {
        this.checkPulse(true);
    }
}

