/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.metadata.remote.impl.ServerComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.JMSQueueManagerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.MetadataNameConstraint;
import com.sas.services.information.metadata.OMRServerComponent;
import com.sas.services.util.Names;
import com.sas.services.util.UpgradeInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@SASScope
public class OMRJMSQueueManager
extends OMRServerComponent
implements JMSQueueManagerInterface,
UpgradeInterface {
    private TCPIPConnection m_conn;
    private List m_connProps;
    private List m_props;
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRJMSQueueManager() throws RemoteException {
        this(OMRJMSQueueManager.class);
    }

    public OMRJMSQueueManager(ServerComponent o) throws RemoteException {
        this(o, OMRJMSQueueManager.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRJMSQueueManager(ServerComponentImpl o) throws RemoteException {
        this(o, OMRJMSQueueManager.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRJMSQueueManager(ServerComponentImpl_Stub o) throws RemoteException {
        this(o, OMRJMSQueueManager.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRJMSQueueManager(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, OMRJMSQueueManager.class);
    }

    public OMRJMSQueueManager(Class theClass) throws RemoteException {
        super(theClass);
    }

    public OMRJMSQueueManager(ServerComponent o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public OMRJMSQueueManager(ServerComponentImpl o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public OMRJMSQueueManager(ServerComponentImpl_Stub o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public OMRJMSQueueManager(RepositoryInterface repos, String name, FolderInterface parent, Class theClass) throws RemoteException {
        block5: {
            super(theClass);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                ServerComponent sc = (ServerComponent)omirepository.createMetadata(name, "ServerComponent");
                sc.setUsageVersion(CURRENT_VERSION.encode());
                sc.setPublicType("MQM.JMS");
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = sc;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    sc.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                throw new RuntimeException((Throwable)((Object)ex));
            }
        }
    }

    @Override
    public List getJMSDestinations() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = null;
        ServerComponent sc = (ServerComponent)this._repositoryObject;
        try {
            AssociationList processes = sc.getInitProcesses();
            if (processes.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            results = new ArrayList<MetadataInterface>(processes.size());
            Iterator it = processes.iterator();
            while (it.hasNext()) {
                results.add(this._repository.factoryProcess(it.next()));
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return results;
    }

    @Override
    public String getJNDIConnectionOptions() throws ServiceException, RemoteException {
        Property prop = this.getJMSConnectionProperty("connectionOpts");
        if (prop != null) {
            return prop.getDefaultValue();
        }
        return null;
    }

    @Override
    public String getJNDIInitialContextFactory() throws ServiceException, RemoteException {
        Property prop = this.getJMSConnectionProperty("jndiICtxtFactory");
        if (prop != null) {
            return prop.getDefaultValue();
        }
        return null;
    }

    @Override
    public String getJNDIProviderURL() throws ServiceException, RemoteException {
        Property prop = this.getJMSConnectionProperty("jndiProvURL");
        if (prop != null) {
            return prop.getDefaultValue();
        }
        return null;
    }

    @Override
    public String getJNDIConnectionFactory() throws ServiceException, RemoteException {
        Property prop = this.getJMSQueueManagerProperty("jmsConnFac");
        if (prop != null) {
            return prop.getDefaultValue();
        }
        return null;
    }

    @Override
    public void setJMSDestinations(List destList) throws ServiceException, RemoteException {
        ServerComponent sc = (ServerComponent)this._repositoryObject;
        try {
            AssociationList processes = sc.getInitProcesses();
            processes.clear();
            for (MetadataInterface mi : destList) {
                Root queue = (Root)mi.getRepositoryEntity();
                processes.add((Object)queue);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setJNDIConnectionOptions(String options) throws ServiceException, RemoteException {
        this.setJMSConnectionProperty("connectionOpts", "QueueManager.Connection.Property.ConnOpts.Name.xmlKey.txt", options);
    }

    @Override
    public void setJNDIInitialContextFactory(String factory) throws ServiceException, RemoteException {
        this.setJMSConnectionProperty("jndiICtxtFactory", "QueueManager.Connection.Property.JNDIICtxFac.Name.xmlKey.txt", factory);
    }

    @Override
    public void setJNDIProviderURL(String url) throws ServiceException, RemoteException {
        this.setJMSConnectionProperty("jndiProvURL", "QueueManager.Connection.Property.JNDIProvURL.Name.xmlKey.txt", url);
    }

    @Override
    public void setJNDIConnectionFactory(String factory) throws ServiceException, RemoteException {
        this.setJMSQueueManagerProperty("jmsConnFac", "QueueManager.Property.JMSConnFac.Name.xmlKey.txt", factory);
    }

    @Override
    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (this._repositoryObject != null && this._repositoryObject instanceof ServerComponent) {
            FolderInterface fi;
            if (!this.getUsageVersion().isCompatible(new UsageVersion(0, 0), CURRENT_VERSION)) {
                throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
            }
            ServerComponent qMan = (ServerComponent)this._repositoryObject;
            while (!Names.validateOMRObjectName(qMan.getName(), false)) {
                String name = null;
                if (qMan.getName().length() > 60) {
                    name = qMan.getName().substring(0, 60);
                } else if (Character.isSpaceChar(qMan.getName().charAt(0)) || Character.isSpaceChar(qMan.getName().charAt(qMan.getName().length() - 1))) {
                    name = qMan.getName().trim();
                } else if (qMan.getName().contains("\\")) {
                    name = qMan.getName().substring(qMan.getName().indexOf("\\") + 1);
                } else if (qMan.getName().contains("/")) {
                    name = qMan.getName().substring(qMan.getName().indexOf("/"));
                }
                if (name == null) continue;
                qMan.setName(name);
            }
            if (qMan.getUsageVersion() < CURRENT_VERSION.encode()) {
                qMan.setUsageVersion(CURRENT_VERSION.encode());
            }
            Filter filter = new Filter();
            filter.setType("ServerComponent");
            String qManName = this.getName();
            int count = 1;
            boolean again = true;
            while (again) {
                again = false;
                filter.setFilterComponent(new FilterComponent("Name", 0, qManName));
                filter.setOMRFlags(8192);
                List qManList = this._repository.search(filter);
                for (int i = 0; i < qManList.size(); ++i) {
                    if (((MetadataInterface)qManList.get(i)).getIdentifier().equals(this.getIdentifier())) continue;
                    qManName = this.getName() + "(" + count++ + ")";
                    again = true;
                }
            }
            if (count > 1) {
                this.setName(qManName);
            }
            if ((fi = this.getParent()) == null) {
                fi = this.GetMessageQueueFolder();
                FolderInterface temp = fi.getSubfolder(this.getName());
                if (null == temp) {
                    temp = fi.makeSubfolder(this.getName());
                }
                fi = temp;
            }
            this.validateNameAndFolder(fi, new JMSQueueManagerNameConstraint(this));
        }
        this.update();
    }

    private TCPIPConnection getJMSConnection(boolean toServer) throws RemoteException, MdException {
        if (this.m_conn == null || toServer) {
            AssociationList conns = ((ServerComponent)this._repositoryObject).getSourceConnections();
            this.m_conn = (TCPIPConnection)conns.get(0);
        }
        return this.m_conn;
    }

    private List getJMSConnectionProperties(boolean toServer) throws RemoteException, MdException {
        if (this.m_connProps == null || toServer) {
            this.m_connProps = this.getJMSConnection(toServer).getProperties();
        }
        return this.m_connProps;
    }

    private List getJMSQueueManagerProperties(boolean toServer) throws RemoteException, MdException {
        if (this.m_props == null || toServer) {
            this.m_props = ((ServerComponent)this._repositoryObject).getProperties();
        }
        return this.m_props;
    }

    private Property getJMSConnectionProperty(String name) throws RemoteException, ServiceException {
        try {
            List props = this.getJMSConnectionProperties(false);
            for (int i = 0; i < props.size(); ++i) {
                Property prop = (Property)props.get(i);
                if (!prop.getPropertyName().equalsIgnoreCase(name)) continue;
                return prop;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return null;
    }

    private void setJMSConnectionProperty(String name, String newPropName, String value) throws RemoteException, ServiceException {
        try {
            Property prop = this.getJMSConnectionProperty(name);
            if (prop == null) {
                TCPIPConnection conn = this.getJMSConnection(false);
                prop = (Property)((OMIRepositoryInterface)this._repository).createMetadata(newPropName, "Property");
                prop.setPropertyName(name);
                conn.getProperties().add((Object)prop);
            }
            prop.setDefaultValue(value);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    private FolderInterface getRootFolder() throws RemoteException, ServiceException {
        boolean isFoundation = this._repository.getServer().getFoundationRepository().getUniqueId().equals(this._repository.getUniqueId());
        FolderInterface fi = isFoundation ? this._repository.getServer().getRootFolder() : (FolderInterface)this._repository.getRootFolders().get(0);
        return fi;
    }

    private FolderInterface GetMessageQueueFolder() throws ServiceException, RemoteException {
        FolderInterface folder;
        FolderInterface root = this.getRootFolder();
        FolderInterface parent = root.getSubfolder("Shared Data");
        if (null == parent) {
            parent = root.makeSubfolder("Shared Data");
            parent.update();
        }
        if (null == (folder = parent.getSubfolder("Message Queues"))) {
            folder = root.makeSubfolder("Message Queues");
            folder.update();
        }
        return folder;
    }

    private Property getJMSQueueManagerProperty(String name) throws RemoteException, ServiceException {
        try {
            List props = this.getJMSQueueManagerProperties(false);
            for (int i = 0; i < props.size(); ++i) {
                Property prop = (Property)props.get(i);
                if (!prop.getPropertyName().equalsIgnoreCase(name)) continue;
                return prop;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return null;
    }

    private void setJMSQueueManagerProperty(String name, String newPropName, String value) throws RemoteException, ServiceException {
        try {
            Property prop = this.getJMSQueueManagerProperty(name);
            if (prop == null) {
                ServerComponent qMan = (ServerComponent)this._repositoryObject;
                prop = (Property)((OMIRepositoryInterface)this._repository).createMetadata(newPropName, "Property");
                prop.setPropertyName(name);
                qMan.getProperties().add((Object)prop);
            }
            prop.setDefaultValue(value);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @SASScope
    private class JMSQueueManagerNameConstraint
    implements MetadataNameConstraint {
        private OMRJMSQueueManager m_qMan;

        JMSQueueManagerNameConstraint(OMRJMSQueueManager qMan) {
            this.m_qMan = qMan;
        }

        @Override
        public boolean isNameValid(MetadataInterface object, String name) throws ServiceException, RemoteException {
            boolean isUnique = true;
            String query = "<XMLSelect search=\"*[@PublicType=:'MQM.' and @Name='" + name + "']\"/>";
            Filter filter = new Filter();
            filter.setType("ServerComponent");
            filter.setOMRFlags(16384);
            filter.setExplicitSearchString("omi", query);
            int count = ((MetadataServerInterface)this.m_qMan.getRepository().getServer()).getCountNoSecurity(filter, null);
            if (count > 1) {
                isUnique = false;
            }
            if (count == 1 && (((ServerComponent)object.getRepositoryEntity()).getPublicType() == null || ((ServerComponent)object.getRepositoryEntity()).getPublicType().equals(""))) {
                isUnique = false;
            }
            return isUnique;
        }
    }
}

